/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.separator;

import com.alee.laf.separator.IAbstractSeparatorPainter;
import com.alee.laf.separator.SeparatorLine;
import com.alee.laf.separator.SeparatorLines;
import com.alee.painter.AbstractPainter;
import com.alee.utils.GraphicsUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.SeparatorUI;

public abstract class AbstractSeparatorPainter<E extends JSeparator, U extends SeparatorUI>
extends AbstractPainter<E, U>
implements IAbstractSeparatorPainter<E, U> {
    protected SeparatorLines lines;

    protected int getLinesCount() {
        return this.lines != null && this.lines.getLines() != null ? this.lines.getLines().size() : 0;
    }

    @Override
    public Boolean isOpaque() {
        return false;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        if (this.getLinesCount() > 0) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Insets insets = ((JComponent)c).getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = ((JComponent)c).getWidth() - insets.left - insets.right;
            int height = ((JComponent)c).getHeight() - insets.top - insets.bottom;
            boolean vertical = ((JSeparator)c).getOrientation() == 1;
            for (int i = 0; i < this.lines.getLines().size(); ++i) {
                int y2;
                int y1;
                int x1;
                int x2;
                SeparatorLine line = this.lines.getLines().get(i);
                if (vertical) {
                    x2 = this.ltr ? x + i : x + width - i - 1;
                    x1 = x2;
                    y1 = y;
                    y2 = y + height - 1;
                } else {
                    x1 = x;
                    x2 = x + width - 1;
                    y1 = y2 = y + i;
                }
                Stroke stroke = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)line.getStroke(), (line.getStroke() != null ? 1 : 0) != 0);
                Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)line.getPaint(x1, y1, x2, y2));
                g2d.drawLine(x1, y1, x2, y2);
                GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
                GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)stroke, (line.getStroke() != null ? 1 : 0) != 0);
            }
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = ((JSeparator)this.component).getInsets();
        int lines = this.getLinesCount();
        return ((JSeparator)this.component).getOrientation() == 1 ? new Dimension(insets.left + lines + insets.right, insets.top + insets.bottom) : new Dimension(insets.left + insets.right, insets.top + lines + insets.bottom);
    }
}

