/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.spinner;

import com.alee.laf.button.WebButton;
import com.alee.laf.spinner.AdaptiveSpinnerPainter;
import com.alee.laf.spinner.ISpinnerPainter;
import com.alee.laf.spinner.SpinnerPainter;
import com.alee.laf.spinner.WebSpinnerLayout;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;

public class WebSpinnerUI
extends BasicSpinnerUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    protected static final ImageIcon UP_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/up.png"));
    protected static final ImageIcon DOWN_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/down.png"));
    @DefaultPainter(value=SpinnerPainter.class)
    protected ISpinnerPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.spinner);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.spinner);
        super.uninstallUI(c);
    }

    @Override
    protected LayoutManager createLayout() {
        return new WebSpinnerLayout();
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        editor.setInheritsPopupMenu(true);
        if (editor instanceof JTextComponent) {
            this.configureEditor((JTextComponent)editor, this.spinner);
        } else {
            JSpinner.DefaultEditor container = (JSpinner.DefaultEditor)editor;
            this.configureEditorContainer(container, this.spinner);
            this.configureEditor(container.getTextField(), this.spinner);
        }
        return editor;
    }

    protected void configureEditorContainer(JSpinner.DefaultEditor container, JSpinner spinner) {
        StyleId.spinnerEditorContainer.at(spinner).set(container);
    }

    protected void configureEditor(JTextComponent field, JSpinner spinner) {
        StyleId.spinnerEditor.at(spinner).set(field);
    }

    @Override
    protected Component createNextButton() {
        WebButton nextButton = new WebButton(StyleId.spinnerNextButton.at(this.spinner), (Icon)UP_ICON);
        nextButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(nextButton);
        return nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        WebButton prevButton = new WebButton(StyleId.spinnerPreviousButton.at(this.spinner), (Icon)DOWN_ICON);
        prevButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(prevButton);
        return prevButton;
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.spinner);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.spinner, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.spinner, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.spinner, new DataRunnable<ISpinnerPainter>(){

            public void run(ISpinnerPainter newPainter) {
                WebSpinnerUI.this.painter = newPainter;
            }
        }, this.painter, painter, ISpinnerPainter.class, AdaptiveSpinnerPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

