/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.splitpane.WebSplitPaneUI;
import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ComponentListener;
import java.util.Map;
import javax.swing.JSplitPane;

public class WebSplitPane
extends JSplitPane
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    public WebSplitPane() {
    }

    public WebSplitPane(int newOrientation) {
        super(newOrientation);
    }

    public WebSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
    }

    public WebSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
    }

    public WebSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
    }

    public WebSplitPane(StyleId id) {
        this.setStyleId(id);
    }

    public WebSplitPane(StyleId id, int newOrientation) {
        super(newOrientation);
        this.setStyleId(id);
    }

    public WebSplitPane(StyleId id, int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.setStyleId(id);
    }

    public WebSplitPane(StyleId id, int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.setStyleId(id);
    }

    public WebSplitPane(StyleId id, int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.setStyleId(id);
    }

    public void addDividerListener(ComponentListener listener) {
        this.getWebUI().getDivider().addComponentListener(listener);
    }

    public void removeDividerListener(ComponentListener listener) {
        this.getWebUI().getDivider().removeComponentListener(listener);
    }

    public Color getDragDividerColor() {
        return this.getWebUI().getDragDividerColor();
    }

    public WebSplitPane setDragDividerColor(Color dragDividerColor) {
        this.getWebUI().setDragDividerColor(dragDividerColor);
        return this;
    }

    public boolean isDrawDividerBorder() {
        return this.getWebUI().isDrawDividerBorder();
    }

    public void setDrawDividerBorder(boolean draw) {
        this.getWebUI().setDrawDividerBorder(draw);
    }

    public Color getDividerBorderColor() {
        return this.getWebUI().getDividerBorderColor();
    }

    public void setDividerBorderColor(Color color) {
        this.getWebUI().setDividerBorderColor(color);
    }

    public double getProportionalDividerLocation() {
        int l = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        return Math.max(0.0, Math.min((double)this.getDividerLocation() / (double)(l - this.getDividerSize()), 1.0));
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    private WebSplitPaneUI getWebUI() {
        return (WebSplitPaneUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebSplitPaneUI)) {
            try {
                this.setUI((WebSplitPaneUI)ReflectUtils.createInstance((String)WebLookAndFeel.splitPaneUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebSplitPaneUI());
            }
        } else {
            this.setUI(this.getUI());
        }
        this.revalidate();
    }
}

