/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPaneUI;
import com.alee.managers.language.LM;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.log.Log;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.FontMethods;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class WebTabbedPane
extends JTabbedPane
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
LanguageMethods,
SettingsMethods,
FontMethods<WebTabbedPane>,
LanguageContainerMethods {
    public WebTabbedPane() {
    }

    public WebTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public WebTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    public WebTabbedPane(StyleId id) {
        this.setStyleId(id);
    }

    public WebTabbedPane(StyleId id, int tabPlacement) {
        super(tabPlacement);
        this.setStyleId(id);
    }

    public WebTabbedPane(StyleId id, int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.setStyleId(id);
    }

    @Override
    public String getTitleAt(int index) {
        return LM.get((String)super.getTitleAt(index));
    }

    public int getTabAt(Point point) {
        return this.getTabAt(point.x, point.y);
    }

    public int getTabAt(int x, int y) {
        return this.indexAtLocation(x, y);
    }

    public Rectangle getBoundsAt(Point point) {
        return this.getBoundsAt(point.x, point.y);
    }

    public Rectangle getBoundsAt(int x, int y) {
        int index = this.getTabAt(x, y);
        return index != -1 ? this.getBoundsAt(index) : null;
    }

    public boolean isRotateTabInsets() {
        return this.getWebUI().isRotateTabInsets();
    }

    public void setRotateTabInsets(boolean rotateTabInsets) {
        this.getWebUI().setRotateTabInsets(rotateTabInsets);
    }

    public Insets getContentInsets() {
        return this.getWebUI().getContentInsets();
    }

    public void setContentInsets(Insets contentInsets) {
        this.getWebUI().setContentInsets(contentInsets);
    }

    public Insets getTabInsets() {
        return this.getWebUI().getTabInsets();
    }

    public void setTabInsets(Insets tabInsets) {
        this.getWebUI().setTabInsets(tabInsets);
    }

    public void setSelectedForegroundAt(int tabIndex, Color foreground) {
        this.getWebUI().setSelectedForegroundAt(tabIndex, foreground);
    }

    public Color getSelectedForegroundAt(int tabIndex) {
        return this.getWebUI().getSelectedForegroundAt(tabIndex);
    }

    public void setBackgroundPainterAt(int tabIndex, Painter painter) {
        this.getWebUI().setBackgroundPainterAt(tabIndex, painter);
    }

    public Painter getBackgroundPainterAt(int tabIndex) {
        return this.getWebUI().getBackgroundPainterAt(tabIndex);
    }

    public TabbedPaneStyle getTabbedPaneStyle() {
        return this.getWebUI().getTabbedPaneStyle();
    }

    public void setTabbedPaneStyle(TabbedPaneStyle tabbedPaneStyle) {
        this.getWebUI().setTabbedPaneStyle(tabbedPaneStyle);
    }

    public int getTabRunIndent() {
        return this.getWebUI().getTabRunIndent();
    }

    public void setTabRunIndent(int tabRunIndent) {
        this.getWebUI().setTabRunIndent(tabRunIndent);
    }

    public int getTabOverlay() {
        return this.getWebUI().getTabOverlay();
    }

    public void setTabOverlay(int tabOverlay) {
        this.getWebUI().setTabOverlay(tabOverlay);
    }

    public TabStretchType getTabStretchType() {
        return this.getWebUI().getTabStretchType();
    }

    public void setTabStretchType(TabStretchType tabStretchType) {
        this.getWebUI().setTabStretchType(tabStretchType);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    public WebTabbedPaneUI getWebUI() {
        return (WebTabbedPaneUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTabbedPaneUI)) {
            try {
                this.setUI((WebTabbedPaneUI)ReflectUtils.createInstance((String)WebLookAndFeel.tabbedPaneUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebTabbedPaneUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this);
    }

    @Override
    public WebTabbedPane setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTabbedPane setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTabbedPane setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTabbedPane setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTabbedPane setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTabbedPane setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTabbedPane setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTabbedPane setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTabbedPane setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTabbedPane changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTabbedPane setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTabbedPane setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTabbedPane setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }
}

