/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.table.ITableHeaderPainter;
import com.alee.laf.table.WebTableHeaderUI;
import com.alee.painter.AbstractPainter;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderPainter<E extends JTableHeader, U extends WebTableHeaderUI>
extends AbstractPainter<E, U>
implements ITableHeaderPainter<E, U> {
    protected int headerHeight;
    protected Color topLineColor;
    protected Color bottomLineColor;
    protected Color topBgColor;
    protected Color bottomBgColor;
    protected Color gridColor;
    protected Color borderColor;
    protected CellRendererPane rendererPane = null;
    protected JTable table = null;

    @Override
    public void prepareToPaint(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        int column;
        this.table = ((JTableHeader)this.component).getTable();
        Paint bgPaint = this.createBackgroundPaint(0, 1, 0, ((JTableHeader)this.component).getHeight() - 1);
        g2d.setPaint(bgPaint);
        g2d.fillRect(0, 1, ((JTableHeader)this.component).getWidth(), ((JTableHeader)this.component).getHeight() - 1);
        g2d.setPaint(this.topLineColor);
        g2d.drawLine(0, 0, ((JTableHeader)this.component).getWidth(), 0);
        g2d.setPaint(this.bottomLineColor);
        g2d.drawLine(0, ((JTableHeader)this.component).getHeight() - 1, ((JTableHeader)this.component).getWidth(), ((JTableHeader)this.component).getHeight() - 1);
        if (((JTableHeader)this.component).getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g2d.getClipBounds();
        Point left = clip.getLocation();
        Point right = this.p(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = ((JTableHeader)this.component).getColumnModel();
        int cMin = ((JTableHeader)this.component).columnAtPoint(this.ltr ? left : right);
        int cMax = ((JTableHeader)this.component).columnAtPoint(this.ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = ((JTableHeader)this.component).getDraggedColumn();
        Rectangle cellRect = ((JTableHeader)this.component).getHeaderRect(this.ltr ? cMin : cMax);
        if (this.ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g2d, cellRect, column, aColumn, draggedColumn, cm);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g2d, cellRect, column, aColumn, draggedColumn, cm);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = ((JTableHeader)this.component).getHeaderRect(draggedColumnIndex);
            draggedCellRect.x += ((JTableHeader)this.component).getDraggedDistance();
            g2d.setPaint(bgPaint);
            g2d.fillRect(draggedCellRect.x - 1, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height - 1);
            this.paintCell(g2d, draggedCellRect, draggedColumnIndex, draggedColumn, draggedColumn, cm);
        }
        this.rendererPane = null;
        this.table = null;
    }

    protected Paint createBackgroundPaint(int x1, int y1, int x2, int y2) {
        if (this.bottomBgColor == null || CompareUtils.equals((Object)this.topBgColor, (Object[])new Object[]{this.bottomBgColor})) {
            return this.topBgColor;
        }
        return new GradientPaint(x1, y1, this.topBgColor, x2, y2, this.bottomBgColor);
    }

    protected void paintCell(Graphics g, Rectangle rect, int columnIndex, TableColumn column, TableColumn draggedColumn, TableColumnModel columnModel) {
        boolean paintTrailingBorder;
        JScrollPane scrollPane = SwingUtils.getScrollPane(this.table);
        boolean bl = scrollPane != null && (column == draggedColumn || this.table.getAutoResizeMode() == 0 && scrollPane.getViewport().getWidth() > this.table.getWidth() || (this.ltr ? columnIndex != columnModel.getColumnCount() - 1 : columnIndex != 0)) ? true : (paintTrailingBorder = false);
        if (this.ltr || paintTrailingBorder) {
            g.setColor(this.borderColor);
            g.drawLine(rect.x - 1, rect.y + 2, rect.x - 1, rect.y + rect.height - 4);
        }
        JComponent headerRenderer = (JComponent)this.getHeaderRenderer(columnIndex);
        headerRenderer.setOpaque(false);
        headerRenderer.setEnabled(this.table.isEnabled());
        this.rendererPane.paintComponent(g, headerRenderer, this.component, rect.x, rect.y, rect.width, rect.height, true);
        if (!this.ltr || paintTrailingBorder) {
            g.setColor(this.gridColor);
            g.drawLine(rect.x + rect.width - 1, rect.y + 2, rect.x + rect.width - 1, rect.y + rect.height - 4);
        }
    }

    protected Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = ((JTableHeader)this.component).getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = ((JTableHeader)this.component).getDefaultRenderer();
        }
        boolean hasFocus = !((JTableHeader)this.component).isPaintingForPrint() && ((JTableHeader)this.component).hasFocus();
        return renderer.getTableCellRendererComponent(((JTableHeader)this.component).getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = ((JTableHeader)this.component).getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        ps.height = Math.max(ps.height, this.headerHeight);
        return ps;
    }
}

