/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.ScrollCornerProvider;
import com.alee.laf.table.AdaptiveTablePainter;
import com.alee.laf.table.ITablePainter;
import com.alee.laf.table.TablePainter;
import com.alee.laf.table.editors.WebBooleanEditor;
import com.alee.laf.table.editors.WebDateEditor;
import com.alee.laf.table.editors.WebGenericEditor;
import com.alee.laf.table.editors.WebNumberEditor;
import com.alee.laf.table.renderers.WebBooleanRenderer;
import com.alee.laf.table.renderers.WebDateRenderer;
import com.alee.laf.table.renderers.WebDoubleRenderer;
import com.alee.laf.table.renderers.WebIconRenderer;
import com.alee.laf.table.renderers.WebNumberRenderer;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;

public class WebTableUI
extends BasicTableUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
ScrollCornerProvider {
    @DefaultPainter(value=TablePainter.class)
    protected ITablePainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.setDefaultRenderer(Object.class, new WebTableCellRenderer());
        this.table.setDefaultRenderer(Number.class, new WebNumberRenderer());
        this.table.setDefaultRenderer(Double.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Float.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Date.class, new WebDateRenderer());
        this.table.setDefaultRenderer(Icon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(ImageIcon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(Boolean.class, new WebBooleanRenderer());
        this.table.setDefaultEditor(Object.class, new WebGenericEditor());
        this.table.setDefaultEditor(Number.class, new WebNumberEditor());
        this.table.setDefaultEditor(Boolean.class, new WebBooleanEditor());
        this.table.setDefaultEditor(Date.class, new WebDateEditor());
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTableHeader header = WebTableUI.this.table.getTableHeader();
                if (header != null) {
                    StyleId.tableHeader.at(WebTableUI.this.table).set(header);
                }
            }
        };
        this.table.addPropertyChangeListener("tableHeader", this.propertyChangeListener);
        StyleManager.installSkin(this.table);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.table);
        this.table.removePropertyChangeListener("tableHeader", this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.table);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.table, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.table, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.table, new DataRunnable<ITablePainter>(){

            public void run(ITablePainter newPainter) {
                WebTableUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITablePainter.class, AdaptiveTablePainter.class);
    }

    @Override
    public JComponent getCorner(String key) {
        return "UPPER_TRAILING_CORNER".equals(key) ? new WebPanel(StyleId.tableCorner.at(this.table)) : null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.prepareToPaint(this.rendererPane);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

