/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.text.AdaptiveTextAreaPainter;
import com.alee.laf.text.ITextAreaPainter;
import com.alee.laf.text.TextAreaPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class WebTextAreaUI
extends BasicTextAreaUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=TextAreaPainter.class)
    protected ITextAreaPainter painter;
    protected String inputPrompt;
    protected JTextArea textArea = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTextAreaUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.textArea = (JTextArea)c;
        StyleManager.installSkin(this.textArea);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.textArea);
        this.textArea = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.textArea);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.textArea, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.textArea, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.textArea, new DataRunnable<ITextAreaPainter>(){

            public void run(ITextAreaPainter newPainter) {
                WebTextAreaUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITextAreaPainter.class, AdaptiveTextAreaPainter.class);
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String text) {
        if (!CompareUtils.equals((Object)text, (Object[])new Object[]{this.inputPrompt})) {
            this.inputPrompt = text;
            this.textArea.repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        if (this.painter != null) {
            ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
            JTextComponent c = this.getComponent();
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

