/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.toolbar.AdaptiveToolBarPainter;
import com.alee.laf.toolbar.IToolBarPainter;
import com.alee.laf.toolbar.ToolBarPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class WebToolBarUI
extends BasicToolBarUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=ToolBarPainter.class)
    protected IToolBarPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.toolBar);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.toolBar);
        super.uninstallUI(c);
        this.toolBar = null;
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.toolBar);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.toolBar, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.toolBar, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.toolBar, new DataRunnable<IToolBarPainter>(){

            public void run(IToolBarPainter newPainter) {
                WebToolBarUI.this.painter = newPainter;
            }
        }, this.painter, painter, IToolBarPainter.class, AdaptiveToolBarPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtils.getWindowAncestor((Component)toolbar);
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName()) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName()) : new ToolBarDialog((Frame)null, toolbar.getName()));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    @Override
    protected BasicToolBarUI.DragWindow createDragWindow(JToolBar toolbar) {
        BasicToolBarUI.DragWindow dragWindow = super.createDragWindow(toolbar);
        ProprietaryUtils.setWindowOpacity(dragWindow, 0.5f);
        return dragWindow;
    }

    @Override
    protected void installRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNormalBorders(JComponent c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    protected class ToolBarDialog
    extends WebDialog {
        public ToolBarDialog(Frame owner, String title) {
            super(owner, title, false);
        }

        public ToolBarDialog(Dialog owner, String title) {
            super(owner, title, false);
        }

        @Override
        protected JRootPane createRootPane() {
            JRootPane rootPane = new JRootPane(){
                private boolean packing = false;

                @Override
                public void validate() {
                    super.validate();
                    if (!this.packing) {
                        this.packing = true;
                        ToolBarDialog.this.pack();
                        this.packing = false;
                    }
                }
            };
            rootPane.setOpaque(true);
            return rootPane;
        }
    }
}

