/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.ITreeDropLocationPainter;
import com.alee.laf.tree.WebTreeUI;
import com.alee.painter.decoration.AbstractSectionDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeDropLocationPainter<E extends JTree, U extends WebTreeUI, D extends IDecoration<E, D>>
extends AbstractSectionDecorationPainter<E, U, D>
implements ITreeDropLocationPainter<E, U> {
    protected JTree.DropLocation location;

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (this.location != null) {
            states.add(this.isDropBetween(this.location) ? "dropBetween" : "dropOn");
        }
        return states;
    }

    @Override
    public void prepareToPaint(JTree.DropLocation location) {
        this.location = location;
        this.updateDecorationState();
    }

    @Override
    protected Rectangle adjustBounds(Rectangle bounds) {
        return this.getDropViewBounds(this.location);
    }

    @Override
    protected boolean isPlainBackgroundPaintAllowed(E c) {
        return false;
    }

    @Override
    protected boolean isDecorationPaintAllowed(D decoration) {
        return this.location != null && super.isDecorationPaintAllowed(decoration);
    }

    @Override
    public Rectangle getDropViewBounds(JTree.DropLocation location) {
        return this.isDropBetween(location) ? this.getDropBetweenViewBounds(location) : this.getDropOnViewBounds(location);
    }

    protected boolean isDropBetween(JTree.DropLocation location) {
        return location != null && location.getPath() != null && location.getChildIndex() != -1;
    }

    protected Rectangle getDropOnViewBounds(JTree.DropLocation location) {
        TreePath dropPath = location.getPath();
        return ((JTree)this.component).getPathBounds(dropPath);
    }

    protected Rectangle getDropBetweenViewBounds(JTree.DropLocation location) {
        Rectangle rect;
        TreePath path = location.getPath();
        int index = location.getChildIndex();
        Insets insets = ((JTree)this.component).getInsets();
        Dimension ps = this.getPreferredSize();
        if (((JTree)this.component).getRowCount() == 0) {
            rect = new Rectangle(insets.left, insets.top, ((JTree)this.component).getWidth() - insets.left - insets.right, 0);
        } else {
            TreeModel model = ((JTree)this.component).getModel();
            Object root = model.getRoot();
            if (path.getLastPathComponent() == root && index >= model.getChildCount(root)) {
                Rectangle xRect;
                rect = ((JTree)this.component).getRowBounds(((JTree)this.component).getRowCount() - 1);
                rect.y += rect.height;
                if (!((JTree)this.component).isRootVisible()) {
                    xRect = ((JTree)this.component).getRowBounds(0);
                } else if (model.getChildCount(root) == 0) {
                    int totalChildIndent = ((WebTreeUI)this.ui).getLeftChildIndent() + ((WebTreeUI)this.ui).getRightChildIndent();
                    xRect = ((JTree)this.component).getRowBounds(0);
                    xRect.x += totalChildIndent;
                    xRect.width -= totalChildIndent + totalChildIndent;
                } else {
                    int lastIndex = model.getChildCount(root) - 1;
                    Object lastObject = model.getChild(root, lastIndex);
                    TreePath lastChildPath = path.pathByAddingChild(lastObject);
                    xRect = ((JTree)this.component).getPathBounds(lastChildPath);
                }
                rect.x = xRect.x;
                rect.width = xRect.width;
            } else {
                rect = ((JTree)this.component).getPathBounds(path.pathByAddingChild(model.getChild(path.getLastPathComponent(), index)));
            }
        }
        if (rect.y != 0) {
            --rect.y;
        }
        if (!this.ltr) {
            rect.x = rect.x + rect.width - ps.width;
        }
        rect.width = ps.width;
        rect.height = ps.height;
        return rect;
    }
}

