/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.managers.drag.DragViewHandler;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;

public abstract class ComponentDragViewHandler<T extends JComponent>
implements DragViewHandler<T> {
    protected Point location;
    protected WeakReference<T> reference;

    @Override
    public BufferedImage getView(T object, DragSourceDragEvent event) {
        if (this.reference == null || this.reference.get() != object) {
            Point los = ((Component)object).getLocationOnScreen();
            Point eloc = event.getLocation();
            this.location = new Point(los.x - eloc.x, los.y - eloc.y);
            this.reference = new WeakReference<T>(object);
        }
        return SwingUtils.createComponentSnapshot(object, this.getSnapshotOpacity());
    }

    public float getSnapshotOpacity() {
        return 0.8f;
    }

    @Override
    public Point getViewRelativeLocation(T object, DragSourceDragEvent event) {
        return this.location;
    }

    @Override
    public void dragEnded(T object, DragSourceDropEvent event) {
        this.location = null;
        this.reference = null;
    }
}

