/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyleConverter;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.managers.style.data.PainterStyle;
import com.alee.painter.Painter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.MergeUtils;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Insets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

@XStreamAlias(value="style")
@XStreamConverter(value=ComponentStyleConverter.class)
public final class ComponentStyle
implements Serializable,
Cloneable {
    public static final String BASE_PAINTER_ID = "painter";
    private StyleableComponent type;
    private String id;
    private String extendsId;
    private Map<String, Object> componentProperties;
    private Map<String, Object> uiProperties;
    private List<PainterStyle> painters;
    private List<ComponentStyle> styles;
    private transient ComponentStyle parent;

    public StyleableComponent getType() {
        return this.type;
    }

    public ComponentStyle setType(StyleableComponent type) {
        this.type = type;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCompleteId() {
        return this.getParent() != null ? this.getParent().getCompleteId() + "." + this.getId() : this.getId();
    }

    public ComponentStyle setId(String id) {
        this.id = id;
        return this;
    }

    public String getExtendsId() {
        return this.extendsId;
    }

    public ComponentStyle setExtendsId(String id) {
        this.extendsId = id;
        return this;
    }

    public Map<String, Object> getComponentProperties() {
        return this.componentProperties;
    }

    public ComponentStyle setComponentProperties(Map<String, Object> componentProperties) {
        this.componentProperties = componentProperties;
        return this;
    }

    public Map<String, Object> getUIProperties() {
        return this.uiProperties;
    }

    public ComponentStyle setUIProperties(Map<String, Object> uiProperties) {
        this.uiProperties = uiProperties;
        return this;
    }

    public List<PainterStyle> getPainters() {
        return this.painters;
    }

    public ComponentStyle setPainters(List<PainterStyle> painters) {
        this.painters = painters;
        return this;
    }

    public PainterStyle getBasePainter() {
        if (this.painters.size() == 1) {
            return this.painters.get(0);
        }
        for (PainterStyle painter : this.painters) {
            if (!painter.isBase()) continue;
            return painter;
        }
        return null;
    }

    public List<ComponentStyle> getStyles() {
        return this.styles;
    }

    public int getStylesCount() {
        return this.getStyles() != null ? this.getStyles().size() : 0;
    }

    public ComponentStyle setStyles(List<ComponentStyle> styles) {
        this.styles = styles;
        return this;
    }

    public ComponentStyle getParent() {
        return this.parent;
    }

    public ComponentStyle setParent(ComponentStyle parent) {
        this.parent = parent;
        return this;
    }

    public boolean apply(JComponent component) {
        try {
            ComponentUI ui = this.getComponentUIImpl(component);
            for (PainterStyle painterStyle : this.getPainters()) {
                this.installPainter(ui, component, true, painterStyle);
            }
            this.applyProperties(ui, this.appendEmptyUIProperties(ui, this.getUIProperties()));
            this.applyProperties(component, this.getComponentProperties());
            return true;
        }
        catch (Throwable e) {
            Log.error((Object)this, (Throwable)e);
            return false;
        }
    }

    protected void installPainter(Object object, JComponent component, boolean customizable, PainterStyle painterStyle) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Painter painter;
        Map<String, Painter> customPainters;
        Map<String, Painter> map = customPainters = customizable ? StyleManager.getCustomPainters(component) : null;
        if (customPainters != null && customPainters.containsKey(painterStyle.getId())) {
            painter = customPainters.get(painterStyle.getId());
        } else {
            String painterClass = painterStyle.getPainterClass();
            painter = (Painter)ReflectUtils.createInstanceSafely((String)painterClass, (Object[])new Object[0]);
            if (painter == null) {
                String msg = "Unable to create painter \"%s\" for component \"%s\" in style \"%s\"";
                String componentType = component != null ? component.toString() : "none";
                throw new StyleException(String.format("Unable to create painter \"%s\" for component \"%s\" in style \"%s\"", painterClass, componentType, this.getId()));
            }
            this.applyProperties(painter, painterStyle.getProperties());
        }
        this.setFieldValue(object, painterStyle.getId(), painter);
    }

    private void applyProperties(Object object, Map<String, Object> skinProperties) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (skinProperties != null && skinProperties.size() > 0) {
            for (Map.Entry<String, Object> entry : skinProperties.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof PainterStyle) {
                    PainterStyle style = (PainterStyle)value;
                    style.setId(entry.getKey());
                    this.installPainter(object, null, false, style);
                    continue;
                }
                this.setFieldValue(object, entry.getKey(), value);
            }
        }
    }

    protected Map<String, Object> appendEmptyUIProperties(ComponentUI ui, Map<String, Object> uiProperties) {
        if (ui instanceof MarginSupport && !uiProperties.containsKey("margin")) {
            uiProperties.put("margin", new Insets(0, 0, 0, 0));
        }
        if (ui instanceof PaddingSupport && !uiProperties.containsKey("padding")) {
            uiProperties.put("padding", new Insets(0, 0, 0, 0));
        }
        return uiProperties;
    }

    public boolean remove(JComponent component) {
        try {
            ComponentUI ui = this.getComponentUIImpl(component);
            for (PainterStyle painterStyle : this.getPainters()) {
                String setterMethod = ReflectUtils.getSetterMethodName((String)painterStyle.getId());
                ReflectUtils.callMethod((Object)ui, (String)setterMethod, (Object[])new Object[]{null});
            }
            return true;
        }
        catch (Throwable e) {
            Log.error((Object)this, (Throwable)e);
            return false;
        }
    }

    private boolean setFieldValue(Object object, String field, Object value) throws InvocationTargetException, IllegalAccessException {
        if (value == IgnoredValue.VALUE) {
            return false;
        }
        try {
            String setterMethod = ReflectUtils.getSetterMethodName((String)field);
            ReflectUtils.callMethod((Object)object, (String)setterMethod, (Object[])new Object[]{value});
            return true;
        }
        catch (NoSuchMethodException setterMethod) {
            try {
                Field actualField = ReflectUtils.getField(object.getClass(), (String)field);
                actualField.set(object, value);
                return true;
            }
            catch (NoSuchFieldException e) {
                Log.error(ComponentStyle.class, (Throwable)e);
                return false;
            }
        }
    }

    private ComponentUI getComponentUIImpl(JComponent component) {
        Object ui = LafUtils.getUI(component);
        if (ui == null) {
            throw new StyleException("Unable to retrieve UI from component: " + component);
        }
        return ui;
    }

    public <T extends Painter> T getPainter(JComponent component) {
        return this.getPainter(component, BASE_PAINTER_ID);
    }

    public <T extends Painter> T getPainter(JComponent component, String painterId) {
        String pid = painterId != null ? painterId : this.getBasePainter().getId();
        ComponentUI ui = this.getComponentUIImpl(component);
        return (T)((Painter)ComponentStyle.getFieldValue(ui, pid));
    }

    public static <T> T getFieldValue(Object object, String field) {
        Class<?> objectClass = object.getClass();
        try {
            Method getter = ReflectUtils.getFieldGetter((Object)object, (String)field);
            return (T)getter.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Log.error(ComponentStyle.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.error(ComponentStyle.class, (Throwable)e);
        }
        try {
            Field actualField = ReflectUtils.getField(objectClass, (String)field);
            return (T)actualField.get(object);
        }
        catch (NoSuchFieldException e) {
            Log.error(ComponentStyle.class, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.error(ComponentStyle.class, (Throwable)e);
            return null;
        }
    }

    public ComponentStyle merge(ComponentStyle style) {
        this.setParent(style.getParent());
        this.setId(style.getId());
        this.setExtendsId(style.getExtendsId());
        this.extend(style);
        return this;
    }

    private ComponentStyle extend(ComponentStyle style) {
        this.mergeProperties(this.getComponentProperties(), style.getComponentProperties());
        this.mergeProperties(this.getUIProperties(), style.getUIProperties());
        this.mergePainters(this, style);
        int nestedCount = this.getStylesCount();
        int mergedCount = style.getStylesCount();
        if (nestedCount > 0 && mergedCount > 0) {
            for (ComponentStyle child : this.getStyles()) {
                this.extendChild(style, child);
            }
            List<ComponentStyle> nestedStyles = this.getStyles();
            for (ComponentStyle mergedNestedStyle : style.getStyles()) {
                ComponentStyle existing = null;
                for (ComponentStyle nestedStyle : this.getStyles()) {
                    if (mergedNestedStyle.getType() != nestedStyle.getType() || !CompareUtils.equals((Object)mergedNestedStyle.getId(), (Object[])new Object[]{nestedStyle.getId()})) continue;
                    existing = nestedStyle;
                    break;
                }
                if (existing != null) {
                    nestedStyles.remove(existing);
                    super.extend(mergedNestedStyle);
                    nestedStyles.add(existing);
                    continue;
                }
                ComponentStyle mergedNestedStyleClone = mergedNestedStyle.clone();
                mergedNestedStyleClone.setParent(this);
                nestedStyles.add(mergedNestedStyleClone);
            }
            this.setStyles(nestedStyles);
        } else if (mergedCount > 0) {
            List mergedStylesClone = (List)MergeUtils.clone(style.getStyles());
            for (ComponentStyle mergedStyleClone : mergedStylesClone) {
                mergedStyleClone.setParent(this);
            }
            this.setStyles(mergedStylesClone);
        } else if (nestedCount > 0) {
            List baseStylesClone = (List)MergeUtils.clone(this.getStyles());
            for (ComponentStyle baseStyleClone : baseStylesClone) {
                baseStyleClone.setParent(this);
            }
            this.setStyles(baseStylesClone);
        }
        return this;
    }

    private void extendChild(ComponentStyle style, ComponentStyle child) {
        for (ComponentStyle newParentChild : style.getStyles()) {
            if (!child.getId().equals(newParentChild.getId())) continue;
            return;
        }
        for (ComponentStyle mergedChild : style.getStyles()) {
            if (!CompareUtils.equals((Object)child.getExtendsId(), (Object[])new Object[]{mergedChild.getId()})) continue;
            style.getStyles().add(child.clone().extend(mergedChild));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergePainters(ComponentStyle style, ComponentStyle merged) {
        Map<String, PainterStyle> stylePainters = this.collectPainters(style, style.getPainters());
        Map<String, PainterStyle> mergedPainters = this.collectPainters(merged, merged.getPainters());
        for (Map.Entry<String, PainterStyle> entry : stylePainters.entrySet()) {
            String string = entry.getKey();
            PainterStyle stylePainter = entry.getValue();
            if (mergedPainters.containsKey(string)) {
                PainterStyle mergedPainter = mergedPainters.get(string);
                Class painterClass = ReflectUtils.getClassSafely((String)mergedPainter.getPainterClass());
                Class extendedPainterClass = ReflectUtils.getClassSafely((String)stylePainter.getPainterClass());
                if (painterClass == null || extendedPainterClass == null) {
                    String pc = painterClass == null ? mergedPainter.getPainterClass() : stylePainter.getPainterClass();
                    String sid = (Object)((Object)merged.getType()) + ":" + merged.getId();
                    throw new StyleException("Component style \"" + sid + "\" points to missing painter class: \"" + pc + "\"");
                }
                if (ReflectUtils.isAssignable((Class)extendedPainterClass, (Class)painterClass)) {
                    stylePainter.setBase(mergedPainter.isBase());
                    stylePainter.setPainterClass(mergedPainter.getPainterClass());
                    this.mergeProperties(stylePainter.getProperties(), mergedPainter.getProperties());
                    mergedPainters.put(string, stylePainter);
                    continue;
                }
                mergedPainters.put(string, mergedPainter.clone());
                continue;
            }
            mergedPainters.put(string, stylePainter.clone());
        }
        if (mergedPainters.size() > 0) {
            boolean hasBase = false;
            for (Map.Entry<String, PainterStyle> entry : mergedPainters.entrySet()) {
                PainterStyle painterStyle = entry.getValue();
                if (!painterStyle.isBase()) continue;
                hasBase = true;
                break;
            }
            if (!hasBase) {
                void var6_11;
                PainterStyle painterStyle = mergedPainters.get(BASE_PAINTER_ID);
                if (painterStyle == null) {
                    PainterStyle painterStyle2 = mergedPainters.entrySet().iterator().next().getValue();
                }
                var6_11.setBase(true);
            }
        }
        style.setPainters(new ArrayList<PainterStyle>(mergedPainters.values()));
    }

    private void mergeProperties(Map<String, Object> properties, Map<String, Object> merged) {
        for (Map.Entry<String, Object> property : merged.entrySet()) {
            String key = property.getKey();
            Object e = properties.get(key);
            Object m = property.getValue();
            try {
                Object existing = MergeUtils.clone((Object)e);
                Object result = MergeUtils.merge((Object)existing, (Object)m);
                properties.put(key, result);
            }
            catch (Throwable ex) {
                Log.get().error("Unable to merge property \"" + key + "\" values: " + e + " and " + m, ex);
            }
        }
    }

    private Map<String, PainterStyle> collectPainters(ComponentStyle style, List<PainterStyle> painters) {
        LinkedHashMap<String, PainterStyle> paintersMap = new LinkedHashMap<String, PainterStyle>(painters.size());
        for (PainterStyle painter : painters) {
            String painterId = painter.getId();
            if (paintersMap.containsKey(painterId)) {
                String sid = (Object)((Object)style.getType()) + ":" + style.getId();
                throw new StyleException("Component style \"" + sid + "\" has duplicate painters for id \"" + painterId + "\"");
            }
            paintersMap.put(painterId, painter);
        }
        return paintersMap;
    }

    public ComponentStyle clone() {
        ComponentStyle clone = (ComponentStyle)MergeUtils.cloneByFieldsSafely((Object)this, (Object[])new Object[0]);
        clone.setParent(this.getParent());
        if (!CollectionUtils.isEmpty(clone.getStyles())) {
            for (ComponentStyle style : clone.getStyles()) {
                style.setParent(clone);
            }
        }
        return clone;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + ":" + this.getCompleteId();
    }
}

