/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.PainterStyle;
import com.alee.managers.style.data.PainterStyleConverter;
import com.alee.managers.style.data.StyleConverterUtils;
import com.alee.painter.Painter;
import com.alee.utils.CompareUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.xml.InsetsConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class ComponentStyleConverter
extends ReflectionConverter {
    public static final String STYLE_NODE = "style";
    public static final String COMPONENT_TYPE_ATTRIBUTE = "type";
    public static final String STYLE_ID_ATTRIBUTE = "id";
    public static final String STYLE_IDS_SEPARATOR = ",";
    public static final String EXTENDS_ID_ATTRIBUTE = "extends";
    public static final String MARGIN_ATTRIBUTE = "margin";
    public static final String PADDING_ATTRIBUTE = "padding";
    public static final String COMPONENT_NODE = "component";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String UI_NODE = "ui";
    public static final String PAINTER_NODE = "painter";
    public static final String PAINTER_ID_ATTRIBUTE = "id";
    public static final String PAINTER_IDS_SEPARATOR = ",";
    public static final String PAINTER_CLASS_ATTRIBUTE = "class";
    public static final String DEFAULT_PAINTER_ID = "painter";
    public static final String CONTEXT_COMPONENT_TYPE = "component.type";
    public static final String CONTEXT_STYLE_ID = "style.id";
    public static final String CONTEXT_COMPONENT_CLASS = "component.class";
    public static final String CONTEXT_UI_CLASS = "ui.class";
    public static final String CONTEXT_PAINTER_CLASS = "painter.class";

    public ComponentStyleConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(ComponentStyle.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String extendsId;
        ComponentStyle componentStyle = (ComponentStyle)source;
        Map<String, Object> componentProperties = componentStyle.getComponentProperties();
        Map<String, Object> uiProperties = componentStyle.getUIProperties();
        List<PainterStyle> painters = componentStyle.getPainters();
        StyleableComponent type = componentStyle.getType();
        writer.addAttribute(COMPONENT_TYPE_ATTRIBUTE, type.toString());
        String styleId = componentStyle.getId();
        if (styleId != null && !type.getDefaultStyleId().getCompleteId().equals(styleId)) {
            writer.addAttribute("id", styleId);
        }
        if ((extendsId = componentStyle.getExtendsId()) != null) {
            writer.addAttribute(EXTENDS_ID_ATTRIBUTE, extendsId);
        }
        if (uiProperties != null) {
            Insets insets;
            Insets margin = (Insets)uiProperties.get(MARGIN_ATTRIBUTE);
            if (margin != null) {
                writer.addAttribute(MARGIN_ATTRIBUTE, InsetsConverter.insetsToString((Insets)margin));
            }
            if ((insets = (Insets)uiProperties.get(PADDING_ATTRIBUTE)) != null) {
                writer.addAttribute(PADDING_ATTRIBUTE, InsetsConverter.insetsToString((Insets)insets));
            }
        }
        if (componentProperties != null) {
            writer.startNode(COMPONENT_NODE);
            for (Map.Entry entry : componentProperties.entrySet()) {
                writer.startNode((String)entry.getKey());
                context.convertAnother(entry.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if (uiProperties != null) {
            writer.startNode(UI_NODE);
            for (Map.Entry entry : uiProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (CompareUtils.equals((Object)key, (Object[])new Object[]{MARGIN_ATTRIBUTE, PADDING_ATTRIBUTE})) continue;
                writer.startNode(key);
                context.convertAnother(entry.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if (painters != null) {
            for (PainterStyle painterStyle : painters) {
                String painterPackage;
                String skinClassName;
                Class skinClass;
                writer.startNode("painter");
                if (!CompareUtils.equals((Object)painterStyle.getId(), (Object[])new Object[]{"painter"})) {
                    writer.addAttribute("id", painterStyle.getId());
                }
                if ((skinClass = ReflectUtils.getClassSafely((String)(skinClassName = (String)context.get((Object)"skin.class")))) == null) {
                    throw new StyleException("Specified skin class cannot be found: " + skinClassName);
                }
                String painterClassName = painterStyle.getPainterClass();
                Class painterClass = ReflectUtils.getClassSafely((String)painterClassName);
                if (painterClass == null) {
                    throw new StyleException("Specified painter class cannot be found: " + painterClassName);
                }
                String skinPackage = skinClass.getPackage().getName();
                if (skinPackage.equals(painterPackage = painterClass.getPackage().getName())) {
                    writer.addAttribute("class", painterClassName.substring(skinPackage.length() + 1));
                } else {
                    writer.addAttribute("class", painterClassName);
                }
                for (Map.Entry<String, Object> property : painterStyle.getProperties().entrySet()) {
                    writer.startNode(property.getKey());
                    context.convertAnother(property.getValue());
                    writer.endNode();
                }
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String padding;
        ComponentStyle style = new ComponentStyle();
        LinkedHashMap<String, Object> componentProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> uiProperties = new LinkedHashMap<String, Object>();
        ArrayList<PainterStyle> painters = new ArrayList<PainterStyle>();
        ArrayList<ComponentStyle> styles = new ArrayList<ComponentStyle>();
        String sct = reader.getAttribute(COMPONENT_TYPE_ATTRIBUTE);
        StyleableComponent type = StyleableComponent.valueOf(sct);
        if (type == null) {
            throw new StyleException("Styleable component type was not specified or cannot be resolved: " + sct);
        }
        style.setType(type);
        StyleableComponent oldComponentType = (StyleableComponent)((Object)context.get((Object)CONTEXT_COMPONENT_TYPE));
        context.put((Object)CONTEXT_COMPONENT_TYPE, (Object)type);
        String styleId = reader.getAttribute("id");
        style.setId(styleId != null ? styleId : type.getDefaultStyleId().getCompleteId());
        String oldStyleId = (String)context.get((Object)CONTEXT_STYLE_ID);
        context.put((Object)CONTEXT_STYLE_ID, (Object)styleId);
        style.setExtendsId(reader.getAttribute(EXTENDS_ID_ATTRIBUTE));
        String margin = reader.getAttribute(MARGIN_ATTRIBUTE);
        if (margin != null) {
            uiProperties.put(MARGIN_ATTRIBUTE, InsetsConverter.insetsFromString((String)margin));
        }
        if ((padding = reader.getAttribute(PADDING_ATTRIBUTE)) != null) {
            uiProperties.put(PADDING_ATTRIBUTE, InsetsConverter.insetsFromString((String)padding));
        }
        Object occ = context.get((Object)CONTEXT_COMPONENT_CLASS);
        Object ouic = context.get((Object)CONTEXT_UI_CLASS);
        Object opc = context.get((Object)CONTEXT_PAINTER_CLASS);
        context.put((Object)CONTEXT_COMPONENT_CLASS, type.getComponentClass());
        context.put((Object)CONTEXT_UI_CLASS, type.getUIClass());
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(COMPONENT_NODE)) {
                this.readComponentProperties(reader, context, componentProperties, type, styleId);
            } else if (nodeName.equals(UI_NODE)) {
                this.readUIProperties(reader, context, uiProperties, type, styleId);
            } else if (nodeName.equals("painter")) {
                this.readPainterStyles(reader, context, painters, type, styleId);
            } else if (nodeName.equals(STYLE_NODE)) {
                this.readChildStyle(context, style, styles);
            } else {
                throw new StyleException("Unknown \"" + nodeName + "\" style settings block provided for \"" + styleId + "\" style");
            }
            reader.moveUp();
        }
        context.put((Object)CONTEXT_COMPONENT_CLASS, occ);
        context.put((Object)CONTEXT_UI_CLASS, ouic);
        context.put((Object)CONTEXT_PAINTER_CLASS, opc);
        if (style.getExtendsId() == null) {
            if (painters.size() == 1) {
                ((PainterStyle)painters.get(0)).setBase(true);
            } else {
                boolean baseSet = false;
                for (PainterStyle painter : painters) {
                    if (!painter.isBase()) continue;
                    baseSet = true;
                    break;
                }
                if (!baseSet && painters.size() > 0) {
                    ((PainterStyle)painters.get(0)).setBase(true);
                }
            }
        }
        style.setComponentProperties(componentProperties);
        style.setUIProperties(uiProperties);
        style.setPainters(painters);
        style.setStyles(styles);
        context.put((Object)CONTEXT_STYLE_ID, (Object)oldStyleId);
        context.put((Object)CONTEXT_COMPONENT_TYPE, (Object)oldComponentType);
        return style;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readComponentProperties(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, Object> properties, StyleableComponent type, String styleId) {
        Class componentType = type.getComponentClass();
        String componentClassName = reader.getAttribute("class");
        if (componentClassName != null) {
            Class cc = ReflectUtils.getClassSafely((String)componentClassName);
            if (cc == null) throw new StyleException("Specified custom component class \"" + componentClassName + "\" for style \"" + styleId + "\" cannot be found");
            if (!componentType.isAssignableFrom(cc)) throw new StyleException("Specified custom component class \"" + cc.getCanonicalName() + "\" for style \"" + styleId + "\" is not assignable from base component class \"" + componentType.getCanonicalName() + "\"");
            componentType = cc;
        }
        context.put((Object)CONTEXT_COMPONENT_CLASS, componentType);
        StyleConverterUtils.readProperties(reader, context, properties, componentType, styleId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readUIProperties(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, Object> properties, StyleableComponent type, String styleId) {
        Class uiType = type.getUIClass();
        String uiClassName = reader.getAttribute("class");
        if (uiClassName != null) {
            Class uic = ReflectUtils.getClassSafely((String)uiClassName);
            if (uic == null) throw new StyleException("Specified custom UI class \"" + uiClassName + "\" for style \"" + styleId + "\" cannot be found");
            if (!uiType.isAssignableFrom(uic)) throw new StyleException("Specified custom UI class \"" + uic.getCanonicalName() + "\" for style \"" + styleId + "\" is not assignable from base UI class \"" + uiType.getCanonicalName() + "\"");
            uiType = uic;
        }
        context.put((Object)CONTEXT_UI_CLASS, uiType);
        StyleConverterUtils.readProperties(reader, context, properties, uiType, styleId);
    }

    protected void readPainterStyles(HierarchicalStreamReader reader, UnmarshallingContext context, List<PainterStyle> painters, StyleableComponent type, String styleId) {
        String ids = reader.getAttribute("id");
        boolean emptyIds = TextUtils.isEmpty((String)ids);
        ArrayList<String> indices = new ArrayList<String>(1);
        if (!emptyIds && ids.contains(",")) {
            StringTokenizer st = new StringTokenizer(ids, ",", false);
            while (st.hasMoreTokens()) {
                String id = st.nextToken();
                indices.add(TextUtils.isEmpty((String)id) ? "painter" : id);
            }
        } else {
            indices.add(emptyIds ? "painter" : ids);
        }
        Class uiClass = (Class)context.get((Object)CONTEXT_UI_CLASS);
        Class<? extends Painter> defaultPainter = StyleConverterUtils.getDefaultPainter(uiClass, "painter");
        Class painterClass = PainterStyleConverter.unmarshalPainterClass(reader, context, defaultPainter, styleId);
        Object opc = context.get((Object)CONTEXT_PAINTER_CLASS);
        context.put((Object)CONTEXT_PAINTER_CLASS, (Object)painterClass);
        ArrayList<PainterStyle> separateStyles = new ArrayList<PainterStyle>(indices.size());
        for (String id : indices) {
            PainterStyle painterStyle = new PainterStyle();
            painterStyle.setId(id);
            painterStyle.setPainterClass(painterClass.getCanonicalName());
            separateStyles.add(painterStyle);
        }
        LinkedHashMap<String, Object> painterProperties = new LinkedHashMap<String, Object>();
        StyleConverterUtils.readProperties(reader, context, painterProperties, painterClass, styleId);
        for (PainterStyle painterStyle : separateStyles) {
            painterStyle.setProperties(MapUtils.copyLinkedHashMap(painterProperties));
        }
        painters.addAll(separateStyles);
        context.put((Object)CONTEXT_PAINTER_CLASS, opc);
    }

    protected void readChildStyle(UnmarshallingContext context, ComponentStyle style, List<ComponentStyle> styles) {
        ComponentStyle childStyle = (ComponentStyle)context.convertAnother((Object)style, ComponentStyle.class);
        childStyle.setParent(style);
        String styleId = childStyle.getId();
        if (styleId.contains(",")) {
            List styleIds = TextUtils.stringToList((String)styleId, (String)",");
            for (String id : styleIds) {
                if (TextUtils.isEmpty((String)id)) continue;
                styles.add(childStyle.clone().setId(id.trim()));
            }
        } else {
            styles.add(childStyle);
        }
    }
}

