/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.painter.decoration.IDecoration;
import com.alee.utils.MergeUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.xml.ListToStringConverter;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractDecoration<E extends JComponent, I extends AbstractDecoration<E, I>>
implements IDecoration<E, I> {
    public static final String defaultStateId = "default";
    @XStreamAsAttribute
    @XStreamConverter(value=ListToStringConverter.class)
    protected List<String> states;
    @XStreamAsAttribute
    protected Boolean visible = true;
    @XStreamAsAttribute
    protected Dimension size;
    @XStreamAsAttribute
    protected Float opacity;
    protected transient Boolean section;

    public String getId() {
        return this.states != null ? TextUtils.listToString(this.states, (String)",") : defaultStateId;
    }

    @Override
    public List<String> getStates() {
        return this.states;
    }

    @Override
    public boolean isVisible() {
        return this.visible == null || this.visible != false;
    }

    @Override
    public boolean isSection() {
        return this.section != null && this.section != false;
    }

    @Override
    public void setSection(boolean section) {
        this.section = section;
    }

    public float getOpacity() {
        return this.opacity != null ? this.opacity.floatValue() : 1.0f;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size != null ? this.size : null;
    }

    public I merge(I state) {
        if (((AbstractDecoration)state).visible != null) {
            this.visible = ((AbstractDecoration)state).visible;
        }
        if (((AbstractDecoration)state).size != null) {
            this.size = ((AbstractDecoration)state).size;
        }
        if (((AbstractDecoration)state).opacity != null) {
            this.opacity = ((AbstractDecoration)state).opacity;
        }
        return (I)this;
    }

    public I clone() {
        return (I)((AbstractDecoration)MergeUtils.cloneByFieldsSafely((Object)this, (Object[])new Object[0]));
    }

    public String toString() {
        return ReflectUtils.getClassName((Object)this) + " [ id=" + this.getId() + "; visible=" + this.isVisible() + " ]";
    }
}

