/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.managers.style.Bounds;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.background.IBackground;
import com.alee.painter.decoration.border.IBorder;
import com.alee.painter.decoration.content.IContent;
import com.alee.painter.decoration.layout.IContentLayout;
import com.alee.painter.decoration.shadow.IShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.IShape;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.WebShape;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MergeUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="decoration")
public class WebDecoration<E extends JComponent, I extends WebDecoration<E, I>>
extends AbstractDecoration<E, I> {
    @XStreamImplicit
    protected List<IShape> shapes = new ArrayList<IShape>(1);
    @XStreamImplicit
    protected List<IShadow> shades = new ArrayList<IShadow>(1);
    @XStreamImplicit
    protected List<IBorder> borders = new ArrayList<IBorder>(1);
    @XStreamImplicit
    protected List<IBackground> background = new ArrayList<IBackground>(1);
    @XStreamImplicit
    protected List<IContentLayout> layout = new ArrayList<IContentLayout>(1);
    @XStreamImplicit
    protected List<IContent> contents = new ArrayList<IContent>(1);

    public IShape getShape() {
        return !CollectionUtils.isEmpty(this.shapes) ? this.shapes.get(0) : null;
    }

    public IShadow getShade(ShadowType type) {
        if (!CollectionUtils.isEmpty(this.shades)) {
            for (IShadow shade : this.shades) {
                if (shade.getType() != type) continue;
                return shade;
            }
        }
        return null;
    }

    public int getShadeWidth(ShadowType type) {
        IShadow shade = this.getShade(type);
        return shade != null ? shade.getWidth() : 0;
    }

    public IBorder getBorder() {
        return !CollectionUtils.isEmpty(this.borders) ? this.borders.get(0) : null;
    }

    public float getBorderWidth() {
        IBorder border = this.getBorder();
        return border != null ? border.getWidth() : 0.0f;
    }

    public List<IBackground> getBackgrounds() {
        return !CollectionUtils.isEmpty(this.background) ? this.background : null;
    }

    public IContentLayout getLayout() {
        return !CollectionUtils.isEmpty(this.layout) ? this.layout.get(0) : null;
    }

    public List<IContent> getContents() {
        return !CollectionUtils.isEmpty(this.contents) ? this.contents : null;
    }

    @Override
    public Insets getBorderInsets(E c) {
        IShape shape;
        Insets insets = null;
        if (this.isVisible() && (shape = this.getShape()) != null) {
            insets = shape.getBorderInsets(c, this);
        }
        return insets;
    }

    @Override
    public Shape provideShape(E component, Rectangle bounds) {
        IShape shape = this.getShape();
        return this.isVisible() && shape != null ? shape.getShape(ShapeType.background, bounds, component, this) : bounds;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        IShape shape;
        if (this.isVisible() && (shape = this.getShape()) != null) {
            List<IContent> contents;
            IBorder border;
            IShadow inner;
            List<IBackground> backgrounds;
            Object oaa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(this.getOpacity()), (this.getOpacity() < 1.0f ? 1 : 0) != 0);
            Rectangle cl = g2d.getClip() instanceof Rectangle ? (Rectangle)g2d.getClip() : ((JComponent)c).getVisibleRect();
            Shape ocl = GraphicsUtils.setupClip((Graphics2D)g2d, (Shape)Bounds.margin.of((JComponent)c, this, bounds).intersection(cl));
            IShadow outer = this.getShade(ShadowType.outer);
            if (outer != null && shape.isVisible(ShapeType.outerShade, c, this)) {
                Shape s = shape.getShape(ShapeType.outerShade, bounds, c, this);
                outer.paint(g2d, bounds, c, this, s);
            }
            if (!CollectionUtils.isEmpty(backgrounds = this.getBackgrounds()) && shape.isVisible(ShapeType.background, c, this)) {
                Shape s = shape.getShape(ShapeType.background, bounds, c, this);
                for (IBackground background : backgrounds) {
                    background.paint(g2d, bounds, c, this, s);
                }
            }
            if ((inner = this.getShade(ShadowType.inner)) != null && shape.isVisible(ShapeType.innerShade, c, this)) {
                Shape s = shape.getShape(ShapeType.innerShade, bounds, c, this);
                inner.paint(g2d, bounds, c, this, s);
            }
            if ((border = this.getBorder()) != null && shape.isVisible(ShapeType.border, c, this)) {
                Shape s = shape.getShape(ShapeType.border, bounds, c, this);
                border.paint(g2d, bounds, c, this, s);
                if (shape instanceof WebShape) {
                    WebShape webShape = (WebShape)shape;
                    boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
                    boolean paintTop = webShape.isPaintTop(c, this);
                    boolean paintBottom = webShape.isPaintBottom(c, this);
                    boolean actualPaintLeft = ltr ? webShape.isPaintLeft(c, this) : webShape.isPaintRight(c, this);
                    boolean actualPaintRight = ltr ? webShape.isPaintRight(c, this) : webShape.isPaintLeft(c, this);
                    boolean paintTopLine = webShape.isPaintTopLine(c, this);
                    boolean paintBottomLine = webShape.isPaintBottomLine(c, this);
                    boolean actualPaintLeftLine = ltr ? webShape.isPaintLeftLine(c, this) : webShape.isPaintRightLine(c, this);
                    boolean actualPaintRightLine = ltr ? webShape.isPaintRightLine(c, this) : webShape.isPaintLeftLine(c, this);
                    int shadeWidth = this.getShadeWidth(ShadowType.outer);
                    Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)border.getStroke(), (border.getStroke() != null ? 1 : 0) != 0);
                    Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)border.getColor(), (border.getColor() != null ? 1 : 0) != 0);
                    if (!paintTop && paintTopLine) {
                        int x1 = bounds.x + (actualPaintLeft ? shadeWidth : 0);
                        int x2 = bounds.x + bounds.width - (actualPaintRight ? shadeWidth : 0) - 1;
                        g2d.drawLine(x1, bounds.y, x2, bounds.y);
                    }
                    if (!paintBottom && paintBottomLine) {
                        int y = bounds.y + bounds.height - 1;
                        int x1 = bounds.x + (actualPaintLeft ? shadeWidth : 0);
                        int x2 = bounds.x + bounds.width - (actualPaintRight ? shadeWidth : 0) - 1;
                        g2d.drawLine(x1, y, x2, y);
                    }
                    if (!actualPaintLeft && actualPaintLeftLine) {
                        int y1 = bounds.y + (paintTop ? shadeWidth : 0);
                        int y2 = bounds.y + bounds.height - (paintBottom ? shadeWidth : 0) - 1;
                        g2d.drawLine(bounds.x, y1, bounds.x, y2);
                    }
                    if (!actualPaintRight && actualPaintRightLine) {
                        int x = bounds.x + bounds.width - 1;
                        int y1 = bounds.y + (paintTop ? shadeWidth : 0);
                        int y2 = bounds.y + bounds.height - (paintBottom ? shadeWidth : 0) - 1;
                        g2d.drawLine(x, y1, x, y2);
                    }
                    GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op, (border.getColor() != null ? 1 : 0) != 0);
                    GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os, (border.getStroke() != null ? 1 : 0) != 0);
                }
            }
            if ((contents = this.getContents()) != null) {
                IContentLayout layout = this.getLayout();
                List<Rectangle> cb = layout != null ? layout.layout(bounds, c, this, contents) : null;
                for (int i = 0; i < contents.size(); ++i) {
                    IContent content = contents.get(i);
                    Rectangle b = cb != null ? cb.get(i) : content.getBoundsType().of((JComponent)c, this, bounds);
                    content.paint(g2d, b, c, this);
                }
            }
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)ocl);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)oaa);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc);
        }
    }

    @Override
    public I merge(I decoration) {
        super.merge(decoration);
        this.shapes = (List)MergeUtils.merge(this.shapes, ((WebDecoration)decoration).shapes);
        this.shades = (List)MergeUtils.merge(this.shades, ((WebDecoration)decoration).shades);
        this.borders = (List)MergeUtils.merge(this.borders, ((WebDecoration)decoration).borders);
        this.background = (List)MergeUtils.merge(this.background, ((WebDecoration)decoration).background);
        this.layout = (List)MergeUtils.merge(this.layout, ((WebDecoration)decoration).layout);
        this.contents = (List)MergeUtils.merge(this.contents, ((WebDecoration)decoration).contents);
        return (I)this;
    }
}

