/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.CompareUtils;
import com.alee.utils.GraphicsUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import javax.swing.JComponent;

public abstract class AbstractTextureBackground<E extends JComponent, D extends IDecoration<E, D>, I extends AbstractTextureBackground<E, D, I>>
extends AbstractBackground<E, D, I> {
    protected transient TexturePaint paint = null;
    protected transient Rectangle bounds = null;

    public void clearCache() {
        this.paint = null;
        this.bounds = null;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        float opacity = this.getOpacity();
        if (opacity > 0.0f && this.isPaintable()) {
            Rectangle b = shape.getBounds();
            if (this.paint == null || !CompareUtils.equals((Object)this.bounds, (Object[])new Object[]{b})) {
                this.paint = this.getTexturePaint(b);
            }
            if (this.paint != null) {
                Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
                Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.paint);
                g2d.setPaint(this.paint);
                g2d.fill(shape);
                GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
                GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
            }
        }
    }

    protected abstract boolean isPaintable();

    protected abstract TexturePaint getTexturePaint(Rectangle var1);
}

