/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.states.CompassDirection;
import com.alee.utils.ShapeUtils;
import com.alee.utils.swing.DataProvider;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

@XStreamAlias(value="ArrowShape")
public class ArrowShape<E extends JComponent, D extends WebDecoration<E, D>, I extends ArrowShape<E, D, I>>
extends AbstractShape<E, D, I> {
    @XStreamAsAttribute
    protected CompassDirection direction;

    public CompassDirection getDirection(E c) {
        return this.direction != null ? this.direction.adjust(((Component)c).getComponentOrientation()) : CompassDirection.north;
    }

    @Override
    public Insets getBorderInsets(E c, D d) {
        return null;
    }

    @Override
    public Shape getShape(final ShapeType type, final Rectangle bounds, E c, D d) {
        final CompassDirection direction = this.getDirection(c);
        return ShapeUtils.getShape(c, (String)("ArrowShape." + (Object)((Object)type)), (DataProvider)new DataProvider<Shape>(){

            public Shape provide() {
                return ArrowShape.this.createArrowButtonShape(type, bounds, direction);
            }
        }, (Object[])new Object[]{type, bounds, direction});
    }

    protected Shape createArrowButtonShape(ShapeType type, Rectangle bounds, CompassDirection direction) {
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width + (type == ShapeType.border ? -1 : 0);
        int h = bounds.height + (type == ShapeType.border ? -1 : 0);
        GeneralPath shape = new GeneralPath(0);
        switch (direction) {
            case north: {
                shape.moveTo(x, y + h);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)(h * 2) / 3.0f, x + w, y + h);
                shape.lineTo((float)x + (float)w / 2.0f, y);
                break;
            }
            case south: {
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)h / 3.0f, x + w, y);
                shape.lineTo((float)x + (float)w / 2.0f, y + h);
                break;
            }
            case west: {
                shape.moveTo(x + w, y);
                shape.quadTo((float)x + (float)(w * 2) / 3.0f, (float)y + (float)h / 2.0f, x + w, y + h);
                shape.lineTo(x, (float)y + (float)h / 2.0f);
                break;
            }
            case east: {
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 3.0f, (float)y + (float)h / 2.0f, x, y + h);
                shape.lineTo(x + w, (float)y + (float)h / 2.0f);
            }
        }
        shape.closePath();
        return shape;
    }

    @Override
    public Object[] getShapeSettings(Rectangle bounds, E c, D d) {
        return new Object[]{this.getDirection(c)};
    }

    @Override
    public I merge(I shape) {
        super.merge(shape);
        if (((ArrowShape)shape).direction != null) {
            this.direction = ((ArrowShape)shape).direction;
        }
        return (I)this;
    }
}

