/*
 * Decompiled with CFR 0.152.
 */
package com.alee.skin.ninepatch;

import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.painter.AbstractPainter;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

@Deprecated
public class NPDecorationPainter<E extends JComponent, U extends ComponentUI>
extends AbstractPainter<E, U> {
    protected boolean undecorated = false;
    protected boolean paintFocus = false;
    protected boolean paintTop = true;
    protected boolean paintLeft = true;
    protected boolean paintBottom = true;
    protected boolean paintRight = true;
    protected boolean paintTopLine = true;
    protected boolean paintLeftLine = true;
    protected boolean paintBottomLine = true;
    protected boolean paintRightLine = true;
    protected boolean detectSideByContentPatches = false;
    protected int hiddenSideSpacing = 0;
    protected NinePatchIcon backgroundIcon = null;
    protected NinePatchIcon focusedBackgroundIcon = null;
    protected NinePatchIcon separatorIcon = null;
    protected NinePatchIcon topSeparatorIcon = null;
    protected NinePatchIcon leftSeparatorIcon = null;
    protected NinePatchIcon bottomSeparatorIcon = null;
    protected NinePatchIcon rightSeparatorIcon = null;
    protected FocusTracker focusTracker;
    protected boolean focused = false;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public boolean isTrackingEnabled() {
                return !NPDecorationPainter.this.undecorated && NPDecorationPainter.this.paintFocus;
            }

            @Override
            public void focusChanged(boolean focused) {
                NPDecorationPainter.this.focused = focused;
                NPDecorationPainter.this.repaint();
            }
        };
        FocusManager.addFocusTracker(c, this.focusTracker);
    }

    @Override
    public void uninstall(E c, U ui) {
        FocusManager.removeFocusTracker(this.focusTracker);
        this.focusTracker = null;
        super.uninstall(c, ui);
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        if (this.undecorated != undecorated) {
            this.undecorated = undecorated;
            this.updateAll();
        }
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setPaintFocus(boolean paint) {
        if (this.paintFocus != paint) {
            this.paintFocus = paint;
            this.repaint();
        }
    }

    public int getShadeWidth() {
        return 0;
    }

    public void setShadeWidth(int width) {
    }

    public boolean isPaintTop() {
        return this.paintTop;
    }

    public void setPaintTop(boolean top) {
        if (this.paintTop != top) {
            this.paintTop = top;
            this.updateAll();
        }
    }

    public boolean isPaintLeft() {
        return this.paintLeft;
    }

    public void setPaintLeft(boolean left) {
        if (this.paintLeft != left) {
            this.paintLeft = left;
            this.updateAll();
        }
    }

    public boolean isPaintBottom() {
        return this.paintBottom;
    }

    public void setPaintBottom(boolean bottom) {
        if (this.paintBottom != bottom) {
            this.paintBottom = bottom;
            this.updateAll();
        }
    }

    public boolean isPaintRight() {
        return this.paintRight;
    }

    public void setPaintRight(boolean right) {
        if (this.paintRight != right) {
            this.paintRight = right;
            this.updateAll();
        }
    }

    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        if (this.paintTop != top || this.paintLeft != left || this.paintBottom != bottom || this.paintRight != right) {
            this.paintTop = top;
            this.paintLeft = left;
            this.paintBottom = bottom;
            this.paintRight = right;
            this.updateAll();
        }
    }

    public boolean isPaintTopLine() {
        return this.paintTopLine;
    }

    public void setPaintTopLine(boolean top) {
        if (this.paintTopLine != top) {
            this.paintTopLine = top;
            this.updateAll();
        }
    }

    public boolean isPaintLeftLine() {
        return this.paintLeftLine;
    }

    public void setPaintLeftLine(boolean left) {
        if (this.paintLeftLine != left) {
            this.paintLeftLine = left;
            this.updateAll();
        }
    }

    public boolean isPaintBottomLine() {
        return this.paintBottomLine;
    }

    public void setPaintBottomLine(boolean bottom) {
        if (this.paintBottomLine != bottom) {
            this.paintBottomLine = bottom;
            this.updateAll();
        }
    }

    public boolean isPaintRightLine() {
        return this.paintRightLine;
    }

    public void setPaintRightLine(boolean right) {
        if (this.paintRightLine != right) {
            this.paintRightLine = right;
            this.updateAll();
        }
    }

    public void setPaintSideLines(boolean top, boolean left, boolean bottom, boolean right) {
        if (this.paintTopLine != top || this.paintLeftLine != left || this.paintBottomLine != bottom || this.paintRightLine != right) {
            this.paintTopLine = top;
            this.paintLeftLine = left;
            this.paintBottomLine = bottom;
            this.paintRightLine = right;
            this.updateAll();
        }
    }

    public boolean isDetectSideByContentPatches() {
        return this.detectSideByContentPatches;
    }

    public void setDetectSideByContentPatches(boolean detectSideByContentPatches) {
        if (this.detectSideByContentPatches != detectSideByContentPatches) {
            this.detectSideByContentPatches = detectSideByContentPatches;
            this.updateAll();
        }
    }

    public int getHiddenSideSpacing() {
        return this.hiddenSideSpacing;
    }

    public void setHiddenSideSpacing(int spacing) {
        if (this.hiddenSideSpacing != spacing) {
            this.hiddenSideSpacing = spacing;
            this.updateAll();
        }
    }

    public NinePatchIcon getBackgroundIcon() {
        return this.backgroundIcon;
    }

    public void setBackgroundIcon(NinePatchIcon icon) {
        this.backgroundIcon = icon;
        if (!(this.undecorated || this.paintFocus && this.focused)) {
            this.updateAll();
        }
    }

    public NinePatchIcon getFocusedBackgroundIcon() {
        return this.focusedBackgroundIcon;
    }

    public void setFocusedBackgroundIcon(NinePatchIcon icon) {
        this.focusedBackgroundIcon = icon;
        if (!this.undecorated && this.paintFocus && this.focused) {
            this.updateAll();
        }
    }

    public NinePatchIcon getSeparatorIcon() {
        return this.separatorIcon;
    }

    public void setSeparatorIcon(NinePatchIcon icon) {
        this.separatorIcon = icon;
        if (!this.undecorated && this.isAnyLineShouldBePainted()) {
            this.updateAll();
        }
    }

    public NinePatchIcon getTopSeparatorIcon() {
        return this.topSeparatorIcon;
    }

    public void setTopSeparatorIcon(NinePatchIcon icon) {
        this.topSeparatorIcon = icon;
        if (!this.undecorated && this.isTopLineShouldBePainted()) {
            this.updateAll();
        }
    }

    public NinePatchIcon getLeftSeparatorIcon() {
        return this.leftSeparatorIcon;
    }

    public void setLeftSeparatorIcon(NinePatchIcon icon) {
        this.leftSeparatorIcon = icon;
        if (!this.undecorated && this.isLeftLineShouldBePainted()) {
            this.updateAll();
        }
    }

    public NinePatchIcon getBottomSeparatorIcon() {
        return this.bottomSeparatorIcon;
    }

    public void setBottomSeparatorIcon(NinePatchIcon icon) {
        this.bottomSeparatorIcon = icon;
        if (!this.undecorated && this.isBottomLineShouldBePainted()) {
            this.updateAll();
        }
    }

    public NinePatchIcon getRightSeparatorIcon() {
        return this.rightSeparatorIcon;
    }

    public void setRightSeparatorIcon(NinePatchIcon icon) {
        this.rightSeparatorIcon = icon;
        if (!this.undecorated && this.isRightLineShouldBePainted()) {
            this.updateAll();
        }
    }

    @Override
    public Insets getBorders() {
        NinePatchIcon backgroundIcon = this.getCurrentBackgroundIcon();
        if (!this.undecorated && backgroundIcon != null) {
            NinePatchIcon icon;
            Insets margin = backgroundIcon.getMargin();
            if (!this.paintTop) {
                icon = this.getCurrentTopSeparatorIcon();
                margin.top = (this.paintTopLine && icon != null ? icon.getPreferredSize().height : 0) + this.hiddenSideSpacing;
            }
            if (!this.paintLeft) {
                icon = this.getCurrentLeftSeparatorIcon();
                margin.left = (this.paintLeftLine && icon != null ? icon.getPreferredSize().width : 0) + this.hiddenSideSpacing;
            }
            if (!this.paintBottom) {
                icon = this.getCurrentBottomSeparatorIcon();
                margin.bottom = (this.paintBottomLine && icon != null ? icon.getPreferredSize().height : 0) + this.hiddenSideSpacing;
            }
            if (!this.paintRight) {
                icon = this.getCurrentRightSeparatorIcon();
                margin.right = (this.paintRightLine && icon != null ? icon.getPreferredSize().width : 0) + this.hiddenSideSpacing;
            }
            return margin;
        }
        return super.getBorders();
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        if (!this.undecorated) {
            Dimension ps;
            NinePatchIcon icon;
            NinePatchIcon backgroundIcon = this.getCurrentBackgroundIcon();
            if (backgroundIcon != null) {
                backgroundIcon.paintIcon(g2d, this.getBackgroundBounds(backgroundIcon, bounds, c));
            }
            if (this.isTopLineShouldBePainted() && (icon = this.getCurrentTopSeparatorIcon()) != null) {
                ps = icon.getPreferredSize();
                icon.paintIcon(g2d, bounds.x, bounds.y, bounds.width, ps.height);
            }
            if (this.isLeftLineShouldBePainted() && (icon = this.getCurrentLeftSeparatorIcon()) != null) {
                ps = icon.getPreferredSize();
                icon.paintIcon(g2d, bounds.x, bounds.y, ps.width, bounds.height);
            }
            if (this.isBottomLineShouldBePainted() && (icon = this.getCurrentBottomSeparatorIcon()) != null) {
                ps = icon.getPreferredSize();
                icon.paintIcon(g2d, bounds.x, bounds.y + bounds.height - ps.height, bounds.width, ps.height);
            }
            if (this.isRightLineShouldBePainted() && (icon = this.getCurrentRightSeparatorIcon()) != null) {
                ps = icon.getPreferredSize();
                icon.paintIcon(g2d, bounds.x + bounds.width - ps.width, bounds.y, ps.width, bounds.height);
            }
        }
    }

    protected NinePatchIcon getCurrentBackgroundIcon() {
        return this.focused && this.focusedBackgroundIcon != null ? this.focusedBackgroundIcon : this.backgroundIcon;
    }

    protected NinePatchIcon getCurrentTopSeparatorIcon() {
        return this.topSeparatorIcon != null ? this.topSeparatorIcon : this.separatorIcon;
    }

    protected NinePatchIcon getCurrentLeftSeparatorIcon() {
        return this.leftSeparatorIcon != null ? this.leftSeparatorIcon : this.separatorIcon;
    }

    protected NinePatchIcon getCurrentBottomSeparatorIcon() {
        return this.bottomSeparatorIcon != null ? this.bottomSeparatorIcon : this.separatorIcon;
    }

    protected NinePatchIcon getCurrentRightSeparatorIcon() {
        return this.rightSeparatorIcon != null ? this.rightSeparatorIcon : this.separatorIcon;
    }

    protected boolean isAnyLineShouldBePainted() {
        return this.isTopLineShouldBePainted() || this.isLeftLineShouldBePainted() || this.isBottomLineShouldBePainted() || this.isRightLineShouldBePainted();
    }

    protected boolean isTopLineShouldBePainted() {
        return !this.paintTop && this.paintTopLine;
    }

    protected boolean isLeftLineShouldBePainted() {
        return !this.paintLeft && this.paintLeftLine;
    }

    protected boolean isBottomLineShouldBePainted() {
        return !this.paintBottom && this.paintBottomLine;
    }

    protected boolean isRightLineShouldBePainted() {
        return !this.paintRight && this.paintRightLine;
    }

    protected Rectangle getBackgroundBounds(NinePatchIcon icon, Rectangle b, E c) {
        if (!this.undecorated && icon != null) {
            Insets margin = this.detectSideByContentPatches ? icon.getMargin() : icon.getStretchMargin();
            int ts = this.paintTop ? 0 : margin.top;
            int ls = this.paintLeft ? 0 : margin.left;
            int bs = this.paintBottom ? 0 : margin.bottom;
            int rs = this.paintRight ? 0 : margin.right;
            return new Rectangle(b.x - ls, b.y - ts, b.width + ls + rs, b.height + ts + bs);
        }
        return b;
    }
}

