/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.Behavior;
import com.alee.managers.drag.DragManager;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class AbstractHoverBehavior<C extends JComponent>
extends MouseAdapter
implements ComponentListener,
Behavior {
    protected final C component;
    protected boolean enabledOnly;
    protected boolean hover;

    public AbstractHoverBehavior(C component) {
        this(component, true);
    }

    public AbstractHoverBehavior(C component, boolean enabledOnly) {
        this.enabledOnly = enabledOnly;
        this.component = component;
        this.hover = false;
    }

    public void install() {
        ((Component)this.component).addMouseListener(this);
        ((Component)this.component).addMouseMotionListener(this);
        ((Component)this.component).addComponentListener(this);
    }

    public void uninstall() {
        ((Component)this.component).removeMouseListener(this);
        ((Component)this.component).removeMouseMotionListener(this);
        ((Component)this.component).removeComponentListener(this);
    }

    public boolean isEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(boolean enabledOnly) {
        this.enabledOnly = enabledOnly;
        this.updateHover();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setHover(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setHover(false);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateHover();
    }

    protected void updateHover() {
        if (((Component)this.component).isShowing() && !DragManager.isDragging()) {
            Point mousePoint = CoreSwingUtils.getMousePoint(this.component);
            if (((JComponent)this.component).getVisibleRect().contains(mousePoint)) {
                this.setHover(true);
            } else {
                this.setHover(false);
            }
        } else {
            this.setHover(false);
        }
    }

    protected void setHover(boolean hover) {
        if ((!this.enabledOnly || ((Component)this.component).isEnabled()) && this.hover != hover) {
            this.hover = hover;
            this.hoverChanged(hover);
        }
    }

    public abstract void hoverChanged(boolean var1);
}

