/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class AutoExpandSingleChildNodeListener
implements TreeExpansionListener {
    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        JTree tree = (JTree)event.getSource();
        TreePath expandedPath = event.getPath();
        Object expandedObject = expandedPath.getLastPathComponent();
        if (tree.getModel().getChildCount(expandedObject) == 1) {
            Object[] parentPath = expandedPath.getPath();
            Object[] path = Arrays.copyOf(parentPath, parentPath.length + 1);
            path[parentPath.length] = tree.getModel().getChild(expandedObject, 0);
            tree.expandPath(new TreePath(path));
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public static AutoExpandSingleChildNodeListener install(JTree tree) {
        AutoExpandSingleChildNodeListener.uninstall(tree);
        AutoExpandSingleChildNodeListener adapter = new AutoExpandSingleChildNodeListener();
        tree.addTreeExpansionListener(adapter);
        return adapter;
    }

    public static void uninstall(JTree tree) {
        for (TreeExpansionListener listener : tree.getTreeExpansionListeners()) {
            if (!(listener instanceof AutoExpandSingleChildNodeListener)) continue;
            tree.removeTreeExpansionListener(listener);
        }
    }

    public static boolean isInstalled(JTree tree) {
        for (TreeExpansionListener listener : tree.getTreeExpansionListeners()) {
            if (!(listener instanceof AutoExpandSingleChildNodeListener)) continue;
            return true;
        }
        return false;
    }
}

