/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedDocument
extends PlainDocument {
    private final int limit;
    private final boolean toUppercase;

    public LimitedDocument() {
        this.limit = 0;
        this.toUppercase = false;
    }

    public LimitedDocument(int limit) {
        this.limit = limit;
        this.toUppercase = false;
    }

    public LimitedDocument(int limit, boolean upper) {
        this.limit = limit;
        this.toUppercase = upper;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isToUppercase() {
        return this.toUppercase;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.getLimit() > 0 && this.getLength() + str.length() <= this.getLimit()) {
            if (this.isToUppercase()) {
                str = str.toUpperCase(Locale.ROOT);
            }
            super.insertString(offset, str, attr);
        }
    }
}

