/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.ButtonGroupListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class UnselectableButtonGroup
extends ButtonGroup {
    protected final List<ButtonGroupListener> listeners = new ArrayList<ButtonGroupListener>(1);
    protected boolean unselectable = true;

    public UnselectableButtonGroup() {
    }

    public UnselectableButtonGroup(AbstractButton ... buttons) {
        this.add(buttons);
    }

    public UnselectableButtonGroup(List<AbstractButton> buttons) {
        this.add(buttons);
    }

    public UnselectableButtonGroup(boolean unselectable) {
        this.setUnselectable(unselectable);
    }

    public List<AbstractButton> getButtons() {
        return CollectionUtils.copy((Collection)this.buttons);
    }

    public void add(AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            this.add(button);
        }
    }

    public void add(List<AbstractButton> buttons) {
        for (AbstractButton button : buttons) {
            this.add(button);
        }
    }

    public void removeAll() {
        this.clearSelection();
        for (int i = this.buttons.size() - 1; i >= 0; --i) {
            AbstractButton b = (AbstractButton)this.buttons.get(i);
            this.buttons.remove(i);
            b.getModel().setGroup(null);
        }
    }

    public boolean isUnselectable() {
        return this.unselectable;
    }

    public void setUnselectable(boolean unselectable) {
        this.unselectable = unselectable;
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        if (selected || !this.unselectable) {
            super.setSelected(model, selected);
        } else {
            this.clearSelection();
        }
        this.fireSelectionChanged();
    }

    public void addButtonGroupListener(ButtonGroupListener listener) {
        this.listeners.add(listener);
    }

    public void removeButtonGroupListener(ButtonGroupListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelectionChanged() {
        for (ButtonGroupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged();
        }
    }

    public static UnselectableButtonGroup group(AbstractButton ... buttons) {
        return new UnselectableButtonGroup(buttons);
    }

    public static UnselectableButtonGroup group(List<AbstractButton> buttons) {
        return new UnselectableButtonGroup(buttons);
    }
}

