/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.xml.BasicStrokeConverterSupport;
import com.alee.utils.xml.StrokeConverterSupport;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;

public class StrokeConverter
extends AbstractSingleValueConverter {
    public static final String separator = ";";
    public static final String subSeparator = ",";
    public static final List<StrokeConverterSupport> supported = new ArrayList<StrokeConverterSupport>();

    public boolean canConvert(Class type) {
        if (Stroke.class.equals((Object)type)) {
            return true;
        }
        if (Stroke.class.isAssignableFrom(type)) {
            for (StrokeConverterSupport support : supported) {
                if (!support.getType().equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public Object fromString(String stroke) {
        int idEnd = stroke.indexOf(separator);
        String id = idEnd != -1 ? stroke.substring(0, idEnd) : stroke;
        for (StrokeConverterSupport supportedStroke : supported) {
            if (!id.equals(supportedStroke.getId())) continue;
            return supportedStroke.fromString(stroke);
        }
        throw new RuntimeException("Unsupported stroke ID provided: " + id);
    }

    public String toString(Object stroke) {
        Class<?> type = stroke.getClass();
        for (StrokeConverterSupport supportedStroke : supported) {
            if (supportedStroke.getType() != type) continue;
            return supportedStroke.toString((Stroke)stroke);
        }
        throw new RuntimeException("Unsupported stroke provided: " + type);
    }

    static {
        supported.add(new BasicStrokeConverterSupport());
    }
}

