/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuBar;
import javax.swing.event.InternalFrameEvent;

public interface AbstractWindow {
    public static final int REGULAR = 0;
    public static final int SUPPORT = 1;
    public static final int PALETTE = 2;
    public static final int TYPES_MASK = 15;

    public void init();

    public Container getContentPane();

    public void setContentPane(Container var1);

    public void setTitle(String var1);

    public String getTitle();

    public Component getWindow();

    public void pack();

    public void setDefaultCloseOperation(int var1);

    public void dispose();

    public void setVisible(boolean var1);

    public boolean isVisible();

    public void toFront();

    public boolean isFloating();

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public boolean isActive();

    public Dimension getSize();

    public Rectangle getBounds();

    public Point getLocation();

    public void setBounds(Rectangle var1);

    public void setSize(Dimension var1);

    public void setLocation(Point var1);

    public Insets getInsets();

    public void setJMenuBar(JMenuBar var1);

    public JMenuBar getJMenuBar();

    public InputMap getInputMap(int var1);

    public ActionMap getActionMap();

    public Window[] getOwnedWindows();

    public void setFocusTraversalKeysEnabled(boolean var1);

    public void setDirty(boolean var1);

    public void setLocationRelativeTo(Component var1);

    public void setResizable(boolean var1);

    public void setUndecorated(boolean var1);

    public boolean isResizable();

    public void revalidate();

    public static class Event
    extends AWTEvent {
        public static int WINDOW_FIRST = 200;
        public static int WINDOW_OPENED = 200;
        public static int WINDOW_CLOSING = 201;
        public static int WINDOW_CLOSED = 202;
        public static int WINDOW_ICONIFIED = 203;
        public static int WINDOW_DEICONIFIED = 204;
        public static int WINDOW_ACTIVATED = 205;
        public static int WINDOW_DEACTIVATED = 206;
        private final AbstractWindow w;

        public Event(AbstractWindow abstractWindow, int n) {
            super(abstractWindow, n);
            this.w = abstractWindow;
        }

        public AbstractWindow getWindow() {
            return this.w;
        }

        public static Event convert(AbstractWindow abstractWindow, WindowEvent windowEvent) {
            return new Event(abstractWindow, windowEvent.getID());
        }

        public static Event convert(AbstractWindow abstractWindow, InternalFrameEvent internalFrameEvent) {
            return new Event(abstractWindow, internalFrameEvent.getID() - 25549 + WINDOW_FIRST);
        }
    }

    public static class Adapter
    implements Listener {
        @Override
        public void windowOpened(Event event) {
        }

        @Override
        public void windowClosing(Event event) {
        }

        @Override
        public void windowClosed(Event event) {
        }

        @Override
        public void windowIconified(Event event) {
        }

        @Override
        public void windowDeiconified(Event event) {
        }

        @Override
        public void windowActivated(Event event) {
        }

        @Override
        public void windowDeactivated(Event event) {
        }
    }

    public static interface Listener {
        public void windowOpened(Event var1);

        public void windowClosing(Event var1);

        public void windowClosed(Event var1);

        public void windowIconified(Event var1);

        public void windowDeiconified(Event var1);

        public void windowActivated(Event var1);

        public void windowDeactivated(Event var1);
    }
}

