/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.AbstractApplication;
import de.sciss.app.AbstractWindow;
import de.sciss.app.Application;
import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.common.BasicWindowHandler;
import de.sciss.common.SmartJFrame;
import de.sciss.gui.AquaWindowBar;
import de.sciss.gui.EmptyInternalFrameUI;
import de.sciss.gui.FloatingPaletteHandler;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.InternalFrameListenerWrapper;
import de.sciss.gui.TemporaryFocusTracker;
import de.sciss.gui.WindowListenerWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.beans.PropertyVetoException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class AppWindow
implements AbstractWindow {
    private static final String KEY_LOCATION = "location";
    private static final String KEY_SIZE = "size";
    private static final String KEY_VISIBLE = "visible";
    private ComponentListener cmpListener = null;
    private AbstractWindow.Listener winListener = null;
    protected Preferences classPrefs = null;
    private final Component c;
    private final Window w;
    private final Frame f;
    private final Dialog d;
    private final JComponent jc;
    private final JDialog jd;
    protected final SmartJFrame jf;
    protected final JInternalFrame jif;
    private final AquaWindowBar ggTitle;
    private boolean floating;
    protected final boolean ownMenuBar;
    protected final boolean borrowMenuBar;
    protected final BasicWindowHandler wh;
    protected JMenuBar bar = null;
    protected AbstractWindow barBorrower = null;
    protected boolean active = false;
    protected boolean initialized = false;
    private static final int TEMPFLOAT_TIMEOUT = 100;
    protected final boolean tempFloating;
    protected Timer tempFloatingTimer;

    public AppWindow(int n) {
        Application application = AbstractApplication.getApplication();
        int n2 = n & 0xF;
        this.wh = (BasicWindowHandler)application.getWindowHandler();
        switch (n2) {
            case 0: 
            case 1: {
                if (this.wh.usesInternalFrames()) {
                    this.jif = new JInternalFrame(null, true, true, true, true);
                    this.jc = this.jif;
                    this.c = this.jif;
                    this.jf = null;
                    this.f = null;
                    this.w = null;
                    this.jd = null;
                    this.d = null;
                    this.wh.getDesktop().add(this.jif);
                    this.ownMenuBar = n2 == 0;
                } else {
                    this.jf = new SmartJFrame(this.wh.usesScreenMenuBar());
                    this.f = this.jf;
                    this.w = this.jf;
                    this.c = this.jf;
                    this.jif = null;
                    this.jc = null;
                    this.jd = null;
                    this.d = null;
                    this.ownMenuBar = this.wh.usesScreenMenuBar() || n2 == 0;
                }
                this.floating = this.tempFloating = n2 == 1 && this.wh.usesFloating();
                this.borrowMenuBar = false;
                this.ggTitle = null;
                break;
            }
            case 2: {
                this.floating = this.wh.usesFloating();
                this.tempFloating = false;
                this.ownMenuBar = false;
                if (this.wh.usesInternalFrames()) {
                    this.jif = new JInternalFrame(null, true, true, true, true);
                    this.jc = this.jif;
                    this.c = this.jif;
                    this.jf = null;
                    this.f = null;
                    this.w = null;
                    this.jd = null;
                    this.d = null;
                    this.borrowMenuBar = true;
                    this.ggTitle = null;
                    if (this.floating) {
                        this.jif.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
                    }
                    this.wh.getDesktop().add((Component)this.jif, this.floating ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
                    break;
                }
                this.jf = new SmartJFrame(this.wh.usesScreenMenuBar());
                this.f = this.jf;
                this.w = this.jf;
                this.c = this.jf;
                this.jif = null;
                this.jc = null;
                this.jd = null;
                this.d = null;
                if (this.floating) {
                    String string = System.getProperty("java.version");
                    if (UIManager.getLookAndFeel().getName().indexOf("Mac OS X") >= 0 && Float.valueOf(string.substring(0, string.indexOf(46, string.indexOf(46) + 1))).floatValue() >= 1.5f) {
                        this.jf.getRootPane().putClientProperty("Window.style", "small");
                        if (GUIUtil.setAlwaysOnTop(this.jf, true)) {
                            this.jf.setFocusableWindowState(false);
                            new TemporaryFocusTracker(this.jf);
                        }
                        this.ggTitle = null;
                    } else {
                        this.ggTitle = new AquaWindowBar(this, true);
                        this.ggTitle.setAlwaysOnTop(true);
                        this.jf.setUndecorated(true);
                        Container container = this.jf.getContentPane();
                        container.add((Component)this.ggTitle, "North");
                    }
                    this.borrowMenuBar = false;
                    break;
                }
                this.borrowMenuBar = this.wh.usesScreenMenuBar();
                this.ggTitle = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported window type : " + (n & 0xF));
            }
        }
        this.initTempFloating();
    }

    protected AppWindow(Dialog dialog) {
        Application application = AbstractApplication.getApplication();
        this.wh = (BasicWindowHandler)application.getWindowHandler();
        this.w = dialog;
        this.c = this.w;
        this.jf = null;
        this.f = null;
        this.jif = null;
        this.jc = null;
        this.jd = null;
        this.d = null;
        this.ownMenuBar = false;
        this.tempFloating = false;
        this.floating = false;
        this.borrowMenuBar = false;
        this.ggTitle = null;
    }

    private void initTempFloating() {
        if (this.tempFloating) {
            this.tempFloatingTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GUIUtil.setAlwaysOnTop(AppWindow.this.getWindow(), true);
                }
            });
            this.tempFloatingTimer.setRepeats(false);
        }
    }

    public BasicWindowHandler getWindowHandler() {
        return this.wh;
    }

    protected static Dimension stringToDimension(String string) {
        Dimension dimension = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                dimension = new Dimension(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return dimension;
    }

    protected static Point stringToPoint(String string) {
        Point point = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                point = new Point(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return point;
    }

    protected static String pointToString(Point point) {
        return point != null ? point.x + " " + point.y : null;
    }

    public static String dimensionToString(Dimension dimension) {
        return dimension != null ? dimension.width + " " + dimension.height : null;
    }

    @Override
    public boolean isFloating() {
        return this.floating;
    }

    private void restoreFromPrefs() {
        String string = this.classPrefs.get(KEY_SIZE, null);
        String string2 = this.classPrefs.get(KEY_LOCATION, null);
        String string3 = this.classPrefs.get(KEY_VISIBLE, null);
        Rectangle rectangle = this.c.getBounds();
        Dimension dimension = AppWindow.stringToDimension(string);
        if (dimension == null || this.alwaysPackSize()) {
            this.pack();
            dimension = this.c.getSize();
        }
        rectangle.setSize(dimension);
        Point point = AppWindow.stringToPoint(string2);
        if (point != null) {
            rectangle.setLocation(point);
            this.c.setBounds(rectangle);
        } else {
            this.c.setSize(dimension);
            Point2D point2D = this.getPreferredLocation();
            this.wh.place(this, (float)point2D.getX(), (float)point2D.getY());
        }
        this.c.invalidate();
        this.c.validate();
        if (string3 != null && this.restoreVisibility()) {
            this.setVisible(new Boolean(string3));
        }
    }

    public static void lookAndFeelUpdate() {
    }

    protected boolean alwaysPackSize() {
        return true;
    }

    protected boolean restoreVisibility() {
        return true;
    }

    protected boolean autoUpdatePrefs() {
        return false;
    }

    protected Point2D getPreferredLocation() {
        return new Point2D.Float(0.5f, 0.5f);
    }

    @Override
    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Window was already initialized.");
        }
        if (this.borrowMenuBar) {
            this.borrowMenuBar(this.wh.getMenuBarBorrower());
            this.wh.addBorrowListener(this);
        } else if (this.ownMenuBar) {
            this.setJMenuBar(this.wh.getMenuBarRoot().createBar(this));
        }
        this.winListener = new AbstractWindow.Adapter(){

            @Override
            public void windowOpened(AbstractWindow.Event event) {
                if (AppWindow.this.classPrefs != null) {
                    AppWindow.this.classPrefs.putBoolean(AppWindow.KEY_VISIBLE, true);
                }
                if (!AppWindow.this.initialized) {
                    System.err.println("WARNING: window not initialized (" + event.getWindow() + ")");
                }
            }

            @Override
            public void windowClosed(AbstractWindow.Event event) {
                if (AppWindow.this.classPrefs != null) {
                    AppWindow.this.classPrefs.putBoolean(AppWindow.KEY_VISIBLE, false);
                }
            }

            @Override
            public void windowActivated(AbstractWindow.Event event) {
                try {
                    AppWindow.this.active = true;
                    if (AppWindow.this.wh.usesInternalFrames() && AppWindow.this.ownMenuBar) {
                        AppWindow.this.wh.getMasterFrame().setJMenuBar(AppWindow.this.bar);
                    } else if (AppWindow.this.borrowMenuBar && AppWindow.this.barBorrower != null) {
                        AppWindow.this.barBorrower.setJMenuBar(null);
                        if (AppWindow.this.jf != null) {
                            AppWindow.this.jf.setJMenuBar(AppWindow.this.bar);
                        } else if (AppWindow.this.jif != null) {
                            AppWindow.this.wh.getMasterFrame().setJMenuBar(AppWindow.this.bar);
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                    if (AppWindow.this.tempFloating) {
                        if (AppWindow.this.jif == null) {
                            AppWindow.this.tempFloatingTimer.restart();
                        } else {
                            AppWindow.this.jif.setLayer(JLayeredPane.MODAL_LAYER);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }

            @Override
            public void windowDeactivated(AbstractWindow.Event event) {
                try {
                    AppWindow.this.active = false;
                    if (AppWindow.this.wh.usesInternalFrames() && AppWindow.this.ownMenuBar) {
                        if (AppWindow.this.wh.getMasterFrame().getJMenuBar() == AppWindow.this.bar) {
                            AppWindow.this.wh.getMasterFrame().setJMenuBar(null);
                        }
                    } else if (AppWindow.this.borrowMenuBar && AppWindow.this.barBorrower != null) {
                        if (AppWindow.this.jf != null) {
                            AppWindow.this.jf.setJMenuBar(null);
                        }
                        AppWindow.this.barBorrower.setJMenuBar(AppWindow.this.bar);
                    }
                    if (AppWindow.this.tempFloating) {
                        if (AppWindow.this.jif == null) {
                            GUIUtil.setAlwaysOnTop(AppWindow.this.getWindow(), false);
                            AppWindow.this.tempFloatingTimer.stop();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractWindow abstractWindow = FloatingPaletteHandler.getInstance().getFocussedWindow();
                                    if (abstractWindow != null) {
                                        abstractWindow.toFront();
                                    }
                                }
                            });
                        } else {
                            AppWindow.this.jif.setLayer(JLayeredPane.DEFAULT_LAYER);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
        };
        this.addListener(this.winListener);
        if (this.autoUpdatePrefs()) {
            this.getClassPrefs();
            this.restoreFromPrefs();
            this.cmpListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    AppWindow.this.classPrefs.put(AppWindow.KEY_SIZE, AppWindow.dimensionToString(componentEvent.getComponent().getSize()));
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    AppWindow.this.classPrefs.put(AppWindow.KEY_LOCATION, AppWindow.pointToString(componentEvent.getComponent().getLocation()));
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    AppWindow.this.classPrefs.putBoolean(AppWindow.KEY_VISIBLE, true);
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    AppWindow.this.classPrefs.putBoolean(AppWindow.KEY_VISIBLE, false);
                }
            };
            this.c.addComponentListener(this.cmpListener);
        } else if (this.alwaysPackSize()) {
            this.pack();
        }
        this.wh.addWindow(this, null);
        this.initialized = true;
    }

    protected Preferences getClassPrefs() {
        if (this.classPrefs == null) {
            String string = this.getClass().getName();
            this.classPrefs = AbstractApplication.getApplication().getUserPrefs().node(string.substring(string.lastIndexOf(46) + 1));
        }
        return this.classPrefs;
    }

    protected void addDynamicListening(DynamicListening dynamicListening) {
        if (this.c instanceof RootPaneContainer) {
            new DynamicAncestorAdapter(dynamicListening).addTo(((RootPaneContainer)((Object)this.c)).getRootPane());
        } else if (this.jc != null) {
            new DynamicAncestorAdapter(dynamicListening).addTo(this.jc);
        }
    }

    @Override
    public Component getWindow() {
        return this.c;
    }

    @Override
    public Insets getInsets() {
        if (this.w != null) {
            return this.w.getInsets();
        }
        if (this.jif != null) {
            return this.jif.getInsets();
        }
        throw new IllegalStateException();
    }

    @Override
    public void dispose() {
        if (this.tempFloatingTimer != null) {
            this.tempFloatingTimer.stop();
        }
        if (this.initialized) {
            if (this.winListener != null) {
                this.removeListener(this.winListener);
            }
            if (this.cmpListener != null) {
                this.c.removeComponentListener(this.cmpListener);
            }
            this.wh.removeWindow(this, null);
            if (this.borrowMenuBar) {
                this.borrowMenuBar(null);
                this.wh.removeBorrowListener(this);
            }
            if (this.wh.getMenuBarBorrower() == this) {
                this.wh.setMenuBarBorrower(null);
            }
            if (this.ownMenuBar) {
                this.setJMenuBar(null);
                this.wh.getMenuBarRoot().destroy(this);
            }
        }
        if (this.w != null) {
            this.w.dispose();
        } else if (this.jif != null) {
            this.jif.dispose();
        }
        if (this.ggTitle != null) {
            this.ggTitle.dispose();
        }
        this.classPrefs = null;
        this.cmpListener = null;
        this.winListener = null;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.c.setSize(dimension);
    }

    @Override
    public Dimension getSize() {
        return this.c.getSize();
    }

    @Override
    public Rectangle getBounds() {
        return this.c.getBounds();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.c.setBounds(rectangle);
    }

    @Override
    public void setLocation(Point point) {
        this.c.setLocation(point);
    }

    @Override
    public Point getLocation() {
        return this.c.getLocation();
    }

    public void setPreferredSize(Dimension dimension) {
        if (this.c instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.c)).getRootPane().setPreferredSize(dimension);
        } else if (this.jc != null) {
            this.jc.setPreferredSize(dimension);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isActive() {
        if (this.w != null) {
            return this.w.isActive();
        }
        return false;
    }

    @Override
    public void addListener(AbstractWindow.Listener listener) {
        if (this.w != null) {
            WindowListenerWrapper.add(listener, this);
        } else if (this.jif != null) {
            InternalFrameListenerWrapper.add(listener, this);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeListener(AbstractWindow.Listener listener) {
        if (this.w != null) {
            WindowListenerWrapper.remove(listener, this);
        } else if (this.jif != null) {
            InternalFrameListenerWrapper.remove(listener, this);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void toFront() {
        if (this.w != null) {
            this.w.toFront();
        } else if (this.jif != null) {
            this.jif.toFront();
            try {
                this.jif.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.c.setVisible(bl);
    }

    @Override
    public boolean isVisible() {
        return this.c.isVisible();
    }

    @Override
    public void setDefaultCloseOperation(int n) {
        if (this.ggTitle != null) {
            this.ggTitle.setDefaultCloseOperation(n);
        } else if (this.jf != null) {
            this.jf.setDefaultCloseOperation(n);
        } else if (this.jd != null) {
            this.jd.setDefaultCloseOperation(n);
        } else if (this.jif != null) {
            this.jif.setDefaultCloseOperation(n);
        } else {
            throw new IllegalStateException("setDefaultCloseOperation wrapper not yet implemented");
        }
    }

    @Override
    public void pack() {
        if (this.w != null) {
            boolean bl = this.w.getFocusableWindowState();
            if (!bl) {
                this.w.setFocusableWindowState(true);
            }
            this.w.pack();
            if (!bl) {
                this.w.setFocusableWindowState(false);
            }
        } else if (this.jif != null) {
            this.jif.pack();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setTitle(String string) {
        if (this.ggTitle != null) {
            this.ggTitle.setTitle(string);
        } else if (this.f != null) {
            this.f.setTitle(string);
        } else if (this.d != null) {
            this.d.setTitle(string);
        } else if (this.jif != null) {
            this.jif.setTitle(string);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getTitle() {
        if (this.f != null) {
            return this.f.getTitle();
        }
        if (this.d != null) {
            return this.d.getTitle();
        }
        if (this.jif != null) {
            return this.jif.getTitle();
        }
        return null;
    }

    @Override
    public Container getContentPane() {
        if (this.c instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.c)).getContentPane();
        }
        return this.w;
    }

    @Override
    public void setContentPane(Container container) {
        if (!(this.c instanceof RootPaneContainer)) {
            throw new IllegalStateException();
        }
        ((RootPaneContainer)((Object)this.c)).setContentPane(container);
    }

    @Override
    public void setJMenuBar(JMenuBar jMenuBar) {
        block5: {
            try {
                if (this.jf != null) {
                    this.bar = jMenuBar;
                    this.jf.setJMenuBar(jMenuBar);
                    break block5;
                }
                if (this.jif != null) {
                    this.bar = jMenuBar;
                    if (this.active && this.ownMenuBar) {
                        this.wh.getMasterFrame().setJMenuBar(this.bar);
                    }
                    break block5;
                }
                throw new IllegalStateException();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.bar;
    }

    protected void borrowMenuBar(AbstractWindow abstractWindow) {
        if (this.borrowMenuBar && this.barBorrower != abstractWindow) {
            if (this.bar != null && this.barBorrower != null) {
                this.barBorrower.setJMenuBar(this.bar);
                this.bar = null;
            }
            this.barBorrower = abstractWindow;
            JMenuBar jMenuBar = this.bar = this.barBorrower == null ? null : this.barBorrower.getJMenuBar();
            if (this.active) {
                if (this.barBorrower != null) {
                    this.barBorrower.setJMenuBar(null);
                }
                if (this.jf != null) {
                    this.jf.setJMenuBar(this.bar);
                } else if (this.jif != null) {
                    this.wh.getMasterFrame().setJMenuBar(this.bar);
                } else {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public InputMap getInputMap(int n) {
        if (this.c instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.c)).getRootPane().getInputMap(n);
        }
        throw new IllegalStateException();
    }

    @Override
    public ActionMap getActionMap() {
        if (this.c instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.c)).getRootPane().getActionMap();
        }
        throw new IllegalStateException();
    }

    @Override
    public Window[] getOwnedWindows() {
        if (this.w != null) {
            return this.w.getOwnedWindows();
        }
        return new Window[0];
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean bl) {
        this.c.setFocusTraversalKeysEnabled(bl);
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.c instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.c)).getRootPane().putClientProperty("windowModified", new Boolean(bl));
        }
    }

    @Override
    public void setLocationRelativeTo(Component component) {
        if (this.w != null) {
            this.w.setLocationRelativeTo(component);
        } else {
            Point point;
            if (component == null) {
                if (this.jif == null) {
                    point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                } else {
                    component = this.wh.getMasterFrame().getWindow();
                    point = new Point(component.getWidth() >> 1, component.getHeight() >> 1);
                }
            } else {
                point = component.getLocation();
                point.translate(component.getWidth() >> 1, component.getHeight() >> 1);
            }
            Point point2 = SwingUtilities.convertPoint(component, point, this.c);
            point2.translate(-(this.c.getWidth() >> 1), -(this.c.getHeight() >> 1));
            this.c.setLocation(point2);
        }
    }

    @Override
    public void setUndecorated(boolean bl) {
        if (this.d != null) {
            this.d.setUndecorated(bl);
        } else if (this.f != null) {
            this.f.setUndecorated(bl);
        } else if (this.jif != null) {
            this.jif.setUI(new EmptyInternalFrameUI(this.jif));
        } else {
            throw new IllegalStateException("setUndecorated() is not supported by this window type");
        }
    }

    @Override
    public void setResizable(boolean bl) {
        if (this.f != null) {
            this.f.setResizable(bl);
        } else if (this.d != null) {
            this.d.setResizable(bl);
        } else if (this.jif != null) {
            this.jif.setResizable(bl);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isResizable() {
        if (this.f != null) {
            return this.f.isResizable();
        }
        if (this.d != null) {
            return this.d.isResizable();
        }
        if (this.jif != null) {
            return this.jif.isResizable();
        }
        throw new IllegalStateException();
    }

    @Override
    public void revalidate() {
        if (this.c instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.c)).getRootPane().revalidate();
        } else if (this.jc != null) {
            this.jc.revalidate();
        }
    }
}

