/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractApplication;
import de.sciss.app.Application;
import de.sciss.gui.AbstractAboutFrame;
import de.sciss.gui.GUIUtil;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutBox
extends AbstractAboutFrame
implements HyperlinkListener {
    public static final Object COMP_ABOUTBOX = AboutBox.class.getName();
    private static final String CREDITS_START = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\"><html><head><style type=\"text/css\"><!--\np { font-family:\"Lucida Grande\" Helvetica sans-serif;font-size:10pt;padding:2pt 0 2pt 0;margin:0; }\n--></style></head><body>";
    private static final String CREDITS_END = "</body></html>";

    public AboutBox() {
        super(AbstractApplication.getApplication().getName(), String.valueOf(AbstractApplication.getApplication().getVersion()));
        StringBuffer stringBuffer = new StringBuffer(CREDITS_START);
        Application application = AbstractApplication.getApplication();
        URL uRL = application.getClass().getResource("application.png");
        if (uRL != null) {
            this.setApplicationIcon(new ImageIcon(uRL));
        }
        this.setCopyright(application.getResourceString("copyright"));
        this.setHyperlinkListener(this);
        stringBuffer.append(application.getResourceString("credits"));
        stringBuffer.append("<P>Java ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append("</P>");
        stringBuffer.append(CREDITS_END);
        this.setCredits(stringBuffer.toString(), "text/html");
        application.addComponent(COMP_ABOUTBOX, this);
    }

    @Override
    public void dispose() {
        AbstractApplication.getApplication().removeComponent(COMP_ABOUTBOX);
        super.dispose();
    }

    public void setBuildVersion(File file) {
        long l = file.lastModified();
        if (l != 0L) {
            this.setBuildVersion(DateFormat.getDateInstance(3).format(new Date(l)));
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URI uRI = hyperlinkEvent.getURL().toURI();
                Desktop.getDesktop().browse(uRI);
            }
            catch (Exception exception) {
                GUIUtil.displayError(this, exception, this.getTitle());
            }
        }
    }
}

