/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.TopPainter;
import de.sciss.util.Disposable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ComponentHost
extends JComponent
implements Disposable {
    private Image limited = null;
    private boolean imageUpdate = false;
    private boolean imageUpdateC = false;
    private int recentWidth;
    private int recentHeight;
    private final List collTopPainters = new ArrayList();
    private static Paint pntBackgroundDark;
    private static Paint pntBackgroundLight;
    private static final int[] pntBgAquaPixels;
    private static final int[] pntBgDarkPixels;
    private final Rectangle updateRect = new Rectangle();
    private final Paint pntBackground;
    private final Object sync = new Object();

    public ComponentHost() {
        boolean bl = UIManager.getBoolean("dark-skin");
        this.pntBackground = bl ? pntBackgroundDark : pntBackgroundLight;
        this.setOpaque(true);
        this.setDoubleBuffered(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Component component) {
        Object object = this.sync;
        synchronized (object) {
            Rectangle rectangle = component.getBounds();
            if (this.updateRect.isEmpty()) {
                this.updateRect.setBounds(rectangle);
            } else {
                this.updateRect.setBounds(this.updateRect.union(rectangle));
            }
            this.imageUpdate = true;
            this.repaint(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Rectangle rectangle) {
        Object object = this.sync;
        synchronized (object) {
            if (this.updateRect.isEmpty()) {
                this.updateRect.setBounds(rectangle);
            } else {
                this.updateRect.setBounds(this.updateRect.union(rectangle));
            }
            this.imageUpdate = true;
            this.repaint(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll() {
        Object object = this.sync;
        synchronized (object) {
            this.updateRect.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.imageUpdate = true;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawImage() {
        if (this.limited == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.limited.getGraphics();
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Object object = this.sync;
        synchronized (object) {
            if (this.imageUpdateC) {
                this.updateRect.setBounds(0, 0, this.recentWidth, this.recentHeight);
                this.imageUpdateC = false;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                Rectangle rectangle = component.getBounds();
                if (!rectangle.intersects(this.updateRect)) continue;
                if (!component.isOpaque()) {
                    graphics2D.setPaint(this.pntBackground);
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.translate(rectangle.x, rectangle.y);
                component.paint(graphics2D);
                graphics2D.setClip(shape);
                graphics2D.setTransform(affineTransform);
            }
            this.updateRect.setBounds(0, 0, 0, 0);
            this.imageUpdate = false;
        }
        graphics2D.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.flushImage();
        Object object = this.sync;
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof Disposable)) continue;
                ((Disposable)((Object)component)).dispose();
            }
            this.removeAll();
        }
    }

    private void flushImage() {
        if (this.limited != null) {
            this.limited.flush();
            this.limited = null;
        }
    }

    private void recreateImage() {
        this.flushImage();
        this.limited = this.createImage(this.recentWidth, this.recentHeight);
        this.imageUpdateC = true;
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.recentWidth || n2 != this.recentHeight) {
            this.recentWidth = n;
            this.recentHeight = n2;
            this.recreateImage();
        }
        if (this.imageUpdate || this.imageUpdateC) {
            this.redrawImage();
        }
        if (this.limited != null) {
            graphics.drawImage(this.limited, 0, 0, this);
        }
        if (!this.collTopPainters.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this.collTopPainters.size(); ++i) {
                ((TopPainter)this.collTopPainters.get(i)).paintOnTop(graphics2D);
            }
        }
    }

    public void addTopPainter(TopPainter topPainter) {
        if (!this.collTopPainters.contains(topPainter)) {
            this.collTopPainters.add(topPainter);
        }
    }

    public void removeTopPainter(TopPainter topPainter) {
        this.collTopPainters.remove(topPainter);
    }

    static {
        pntBgAquaPixels = new int[]{-986896, -986896, -986896, -986896, -986896, -986896, -986896, -986896, -1250068, -1250068, -1250068, -1250068, -1250068, -1250068, -1250068, -1250068};
        pntBgDarkPixels = new int[]{-15790321, -15790321, -15790321, -15790321, -15790321, -15790321, -15790321, -15790321, -15527149, -15527149, -15527149, -15527149, -15527149, -15527149, -15527149, -15527149};
        BufferedImage bufferedImage = new BufferedImage(4, 4, 2);
        bufferedImage.setRGB(0, 0, 4, 4, pntBgDarkPixels, 0, 4);
        pntBackgroundDark = new TexturePaint(bufferedImage, new Rectangle(0, 0, 4, 4));
        BufferedImage bufferedImage2 = new BufferedImage(4, 4, 2);
        bufferedImage2.setRGB(0, 0, 4, 4, pntBgAquaPixels, 0, 4);
        pntBackgroundLight = new TexturePaint(bufferedImage2, new Rectangle(0, 0, 4, 4));
    }
}

