/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.ParamField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.UIManager;

public class DefaultUnitViewFactory
implements ParamField.UnitViewFactory {
    @Override
    public Object createView(int n) {
        String string;
        String string2 = null;
        switch (n & 0xF0000) {
            case 65536: {
                return "";
            }
            case 131072: {
                return new ClockIcon();
            }
            case 196608: {
                return "\u266a";
            }
        }
        switch (n & 0xF000) {
            case 4096: {
                if ((n & 0xF00) == 256) {
                    return "%";
                }
                return "\u0394 %";
            }
            case 8192: {
                return "dB";
            }
        }
        switch (n & 0xF0) {
            case 0: {
                string = "";
                break;
            }
            case 32: {
                string2 = "s";
                string = "secs";
                break;
            }
            case 48: {
                string = "smps";
                break;
            }
            case 64: {
                string2 = "b";
                string = "beats";
                break;
            }
            case 80: {
                string = "Hz";
                break;
            }
            case 96: {
                string = "pch";
                break;
            }
            case 112: {
                string = "\u00b0";
                break;
            }
            case 128: {
                string = "m";
                break;
            }
            case 144: {
                string = "px";
                break;
            }
            default: {
                string = "???";
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        switch (n & 0xF000) {
            case 12288: {
                string = "m" + string2;
                break;
            }
            case 16384: {
                string = "c" + string2;
                break;
            }
            case 20480: {
                string = "k" + string2;
                break;
            }
        }
        switch (n & 0xF00) {
            case 256: {
                return "";
            }
            case 512: {
                return "\u0394 " + string;
            }
        }
        return string;
    }

    private static class ClockIcon
    implements Icon {
        private static final Stroke strkOutline = new BasicStroke(1.5f);
        private static final Stroke strkHand = new BasicStroke(0.5f);
        private static final Color colrOutlineLight = new Color(0, 0, 0, 192);
        private static final Color colrOutlineDark = new Color(200, 200, 200, 192);
        private static final Color colrInnerLight = Color.black;
        private static final Color colrInnerDark = new Color(200, 200, 200);
        private final Color colrOutline;
        private final Color colrInner;

        protected ClockIcon() {
            boolean bl = UIManager.getBoolean("dark-skin");
            this.colrOutline = bl ? colrOutlineDark : colrOutlineLight;
            this.colrInner = bl ? colrInnerDark : colrInnerLight;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(0.5f + (float)n, 0.5f + (float)n2);
            graphics2D.setColor(this.colrOutline);
            graphics2D.setStroke(strkOutline);
            graphics2D.drawOval(n, n2, 14, 14);
            graphics2D.setStroke(strkHand);
            graphics2D.setColor(this.colrInner);
            graphics2D.drawLine(n + 7, n2 + 7, n + 7, n2 + 2);
            graphics2D.drawLine(n + 7, n2 + 7, n + 10, n2 + 10);
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
        }
    }
}

