/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.GUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ModificationButton
extends JButton {
    public static final int DEFAULT_SIZE = 13;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_PRESSED = 1;
    public static final int TYPE_DISABLED = 2;
    public static final int SHAPE_PLUS = 0;
    public static final int SHAPE_MINUS = 1;
    public static final int SHAPE_INFO = 2;
    public static final int SHAPE_LIST = 3;
    public static final int SHAPE_REVEAL = 4;
    public static final int SHAPE_ABORT = 5;
    private static final String[] toolTip = new String[]{"buttonAddItemTT", "buttonDelItemTT", "buttonInfoTT", "buttonListTT", "buttonRevealTT", "buttonAbortTT"};
    protected final Icon icnNormal;
    protected final Icon icnPressed;
    protected final Icon icnDisabled;

    protected ModificationButton(Icon icon, Icon icon2, Icon icon3) {
        this.icnNormal = icon;
        this.icnPressed = icon2;
        this.icnDisabled = icon3;
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        Dimension dimension = new Dimension(n + 8, n2 + 4);
        this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.setMargin(new Insets(2, 4, 2, 4));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
    }

    public ModificationButton(int n, int n2) {
        this(new ModificationIcon(n, 0, n2), new ModificationIcon(n, 1, n2), new ModificationIcon(n, 2, n2));
        this.setToolTipText(GUIUtil.getResourceString(toolTip[n]));
    }

    public ModificationButton(int n) {
        this(n, 13);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Icon icon = this.isEnabled() ? (this.getModel().isPressed() ? this.icnPressed : this.icnNormal) : this.icnDisabled;
        icon.paintIcon(this, graphics, 4, 2);
    }

    private static class ModificationIcon
    implements Icon {
        private static final Color[] colrLight = new Color[]{new Color(108, 108, 108, 255), new Color(54, 54, 54, 255), new Color(108, 108, 108, 127)};
        private static final Color[] colrDark = new Color[]{new Color(147, 147, 147, 255), new Color(73, 73, 73, 255), new Color(147, 147, 147, 127)};
        private final Area icon;
        private final Color color;
        private final int size;

        public ModificationIcon(int n, int n2, int n3, Color color) {
            this.color = color;
            this.size = n3;
            this.icon = new Area(new Ellipse2D.Float(0.0f, 0.0f, n3, n3));
            float f = (float)n3 / 13.0f;
            switch (n) {
                case 0: {
                    this.icon.subtract(new Area(new Rectangle2D.Float(3.0f * f, 5.5f * f, 7.0f * f, 2.0f * f)));
                    this.icon.subtract(new Area(new Rectangle2D.Float(5.5f * f, 3.0f * f, 2.0f * f, 7.0f * f)));
                    break;
                }
                case 1: {
                    this.icon.subtract(new Area(new Rectangle2D.Float(3.0f * f, 5.5f * f, 7.0f * f, 2.0f * f)));
                    break;
                }
                case 2: {
                    this.icon.subtract(new Area(new Ellipse2D.Float(5.5f * f, 3.0f * f, 2.0f * f, 2.0f * f)));
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(7.5f * f, 5.5f * f);
                    generalPath.lineTo(4.5f * f, 6.0f * f);
                    generalPath.lineTo(4.5f * f, 6.25f * f);
                    generalPath.lineTo(5.5f * f, 6.5f * f);
                    generalPath.lineTo(5.5f * f, 9.5f * f);
                    generalPath.lineTo(4.5f * f, 9.75f * f);
                    generalPath.lineTo(4.5f * f, 10.0f * f);
                    generalPath.lineTo(8.5f * f, 10.0f * f);
                    generalPath.lineTo(8.5f * f, 9.75f * f);
                    generalPath.lineTo(7.5f * f, 9.5f * f);
                    generalPath.closePath();
                    this.icon.subtract(new Area(generalPath));
                    break;
                }
                case 3: {
                    this.icon.subtract(new Area(new Rectangle2D.Float(3.0f * f, 2.5f * f, 7.0f * f, 2.0f * f)));
                    this.icon.subtract(new Area(new Rectangle2D.Float(3.0f * f, 5.5f * f, 7.0f * f, 2.0f * f)));
                    this.icon.subtract(new Area(new Rectangle2D.Float(3.0f * f, 8.5f * f, 7.0f * f, 2.0f * f)));
                    break;
                }
                case 4: {
                    Area area = new Area(new Ellipse2D.Float(1.5f * f, 1.5f * f, 7.0f * f, 7.0f * f));
                    area.subtract(new Area(new Ellipse2D.Float(2.75f * f, 2.75f * f, 4.5f * f, 4.5f * f)));
                    this.icon.subtract(area);
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(7.5f * f, 6.25f * f);
                    generalPath.lineTo(10.75f * f, 9.5f * f);
                    generalPath.lineTo(9.25f * f, 11.0f * f);
                    generalPath.lineTo(6.0f * f, 7.75f * f);
                    generalPath.closePath();
                    this.icon.subtract(new Area(generalPath));
                    break;
                }
                case 5: {
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(2.9f * f, 4.1f * f);
                    generalPath.lineTo(4.1f * f, 2.9f * f);
                    generalPath.lineTo(10.1f * f, 8.9f * f);
                    generalPath.lineTo(8.9f * f, 10.1f * f);
                    generalPath.closePath();
                    this.icon.subtract(new Area(generalPath));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(4.1f * f, 10.1f * f);
                    generalPath.lineTo(2.9f * f, 8.9f * f);
                    generalPath.lineTo(8.9f * f, 2.9f * f);
                    generalPath.lineTo(10.1f * f, 4.1f * f);
                    generalPath.closePath();
                    this.icon.subtract(new Area(generalPath));
                    break;
                }
            }
        }

        public ModificationIcon(int n, int n2, int n3) {
            this(n, n2, n3, UIManager.getBoolean("dark-skin") ? colrDark[n2] : colrLight[n2]);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.color);
            graphics2D.fill(this.icon);
            graphics2D.translate(-n, -n2);
        }
    }
}

