/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.AquaFocusBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JFrame;

public class MultiStateButton
extends AbstractButton
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
PropertyChangeListener,
Composite,
CompositeContext {
    private DefaultButtonModel model;
    private String lastTxt;
    private int txtAscent;
    private int txtWidth;
    private int txtHeight;
    private int state = -1;
    private int numStates = 0;
    private int lastModifiers = 0;
    private int recentWidth = -1;
    private final List collStateViews = new ArrayList();
    private static final int NORMAL = 0;
    private static final int ARMED = 1;
    private static final int DISABLED = 2;
    private static final int W1 = 76;
    private static final int W2 = 180;
    private static final int[] pntBackPix = new int[]{-1184275, -1118482, -986896, -921103, -855310, -789517};
    private static final int[] pntBackPixN = new int[]{0x12000000, 0x11000000, 0xF000000, 0xE000000, 0xD000000, 0xC000000};
    private static final Color[] colrBorderTop = new Color[]{new Color(127, 127, 127), new Color(63, 63, 63), new Color(127, 127, 127, 127)};
    private static final Color[] colrBorderRest = new Color[]{new Color(151, 151, 151), new Color(75, 75, 75), new Color(151, 151, 151, 127)};
    private static final Color[] colrBorderCorner = new Color[]{new Color(131, 131, 131), new Color(65, 65, 65), new Color(131, 131, 131, 127)};
    private static final Color colrBorderTopS = new Color(0, 0, 0, 21);
    private static final Color colrBorderBotS = new Color(255, 255, 255, 128);
    private static final Color[] colrBackTop = new Color[]{new Color(251, 251, 251), new Color(125, 125, 125), new Color(251, 251, 251, 127)};
    private static final Color[] colrBackBot = new Color[]{new Color(236, 236, 236), new Color(118, 118, 118), new Color(236, 236, 236, 127)};
    private static final Paint[] pntBackBot;
    private static final Color colrBackTopN;
    private static final Color colrBackBotN;
    private int numColumns = 0;
    private boolean autoStep = true;

    public MultiStateButton() {
        this.setBorder(new AquaFocusBorder());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addPropertyChangeListener("font", this);
        this.model = new DefaultButtonModel();
        this.setModel(this.model);
        this.setFocusable(true);
    }

    public void setNumColumns(int n) {
        if (n != this.numColumns) {
            this.numColumns = n;
            this.recalcPrefSize();
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setAutoStep(boolean bl) {
        this.autoStep = bl;
    }

    public boolean getAutoStep() {
        return this.autoStep;
    }

    private void recalcPrefSize() {
        Rectangle2D rectangle2D;
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getNormalizingTransform(), true, true);
        int n = 0;
        int n2 = 0;
        if (this.numColumns == 0) {
            for (int i = 0; i < this.numStates; ++i) {
                StateView stateView = (StateView)this.collStateViews.get(i);
                if (stateView.text != null) {
                    rectangle2D = font.getStringBounds(stateView.text, fontRenderContext);
                    n = Math.max(n, (int)rectangle2D.getWidth());
                }
                if (stateView.icon == null) continue;
                n = Math.max(n, stateView.icon.getIconWidth());
                n2 = Math.max(n2, stateView.icon.getIconWidth());
            }
            rectangle2D = font.getStringBounds("Mp", fontRenderContext);
        } else {
            rectangle2D = font.getStringBounds("Mp", fontRenderContext);
            n = (int)(rectangle2D.getWidth() * (double)this.numColumns / 2.0);
        }
        n2 = Math.max(n2, (int)rectangle2D.getHeight());
        this.setPreferredSize(new Dimension(n + 24, n2 + 13));
    }

    private void configureTextColor(StateView stateView, Color color) {
        stateView.colrLabel[0] = color;
        stateView.colrLabel[1] = MultiStateButton.createArmedColor(stateView.colrLabel[0]);
        stateView.colrLabel[2] = MultiStateButton.createDisabledColor(stateView.colrLabel[0]);
    }

    private void configureBgColor(StateView stateView) {
        stateView.pntBack = null;
        stateView.isGradient = false;
        stateView.isClear = true;
    }

    private void configureBgColor(StateView stateView, Color color) {
        this.configureColor(stateView.colrSVBackTop, colrBackTop[0], colrBackTopN, color);
        this.configureColor(stateView.colrSVBackBot, colrBackBot[0], colrBackBotN, color);
        int[] nArray = this.mixPixels(pntBackPix, pntBackPixN, color);
        BufferedImage bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, nArray, 0, 1);
        stateView.pntSVBackBot[0] = new TexturePaint(bufferedImage, new Rectangle(0, 0, 1, 6));
        bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, MultiStateButton.createdArmedPixels(nArray), 0, 1);
        stateView.pntSVBackBot[1] = new TexturePaint(bufferedImage, new Rectangle(0, 0, 1, 6));
        bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, MultiStateButton.createdDisabledPixels(nArray), 0, 1);
        stateView.pntSVBackBot[2] = new TexturePaint(bufferedImage, new Rectangle(0, 0, 1, 6));
        stateView.pntBack = color;
        stateView.isGradient = false;
    }

    private int[] mixPixels(int[] nArray, int[] nArray2, Color color) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = this.mixPixel(nArray[i], nArray2[i], color);
        }
        return nArray3;
    }

    private int mixPixel(int n, int n2, Color color) {
        float f = (float)color.getAlpha() / 255.0f;
        float f2 = 1.0f - f;
        float f3 = (float)(n >> 24 & 0xFF) * f + (float)(n2 >> 24 & 0xFF) * f2;
        float f4 = (float)(n >> 16 & 0xFF) * f + (float)(n2 >> 16 & 0xFF) * f2;
        float f5 = (float)(n >> 8 & 0xFF) * f + (float)(n2 >> 8 & 0xFF) * f2;
        float f6 = (float)(n & 0xFF) * f + (float)(n2 & 0xFF) * f2;
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        return (int)f3 << 24 | (int)(f4 * 76.0f + f4 * (float)n3 / 255.0f * 180.0f) << 8 & 0xFF0000 | (int)(f5 * 76.0f + f5 * (float)n4 / 255.0f * 180.0f) & 0xFF00 | (int)(f6 * 76.0f + f6 * (float)n5 / 255.0f * 180.0f) >> 8;
    }

    private void configureColor(Color[] colorArray, Color color, Color color2, Color color3) {
        colorArray[0] = this.mixColor(color, color2, color3);
        colorArray[1] = MultiStateButton.createArmedColor(colorArray[0]);
        colorArray[2] = MultiStateButton.createDisabledColor(colorArray[0]);
    }

    private Color mixColor(Color color, Color color2, Color color3) {
        if (color3 == null) {
            return color;
        }
        float f = (float)color3.getAlpha() / 255.0f;
        float f2 = 1.0f - f;
        float f3 = (float)color.getRed() * f + (float)color2.getRed() * f2;
        float f4 = (float)color.getGreen() * f + (float)color2.getGreen() * f2;
        float f5 = (float)color.getBlue() * f + (float)color2.getBlue() * f2;
        float f6 = (float)color.getAlpha() * f + (float)color2.getAlpha() * f2;
        return new Color((int)(f3 * 76.0f + f3 * (float)color3.getRed() / 255.0f * 180.0f) >> 8, (int)(f4 * 76.0f + f4 * (float)color3.getGreen() / 255.0f * 180.0f) >> 8, (int)(f5 * 76.0f + f5 * (float)color3.getBlue() / 255.0f * 180.0f) >> 8, (int)f6);
    }

    private void configureBgColor(StateView stateView, Color color, Color color2) {
        stateView.pntBack = null;
        stateView.colrBackGrad1 = color;
        stateView.colrBackGrad2 = color2;
        stateView.isGradient = true;
    }

    private static Color createArmedColor(Color color) {
        return new Color(color.getRed() >> 1, color.getGreen() >> 1, color.getBlue() >> 1, 255 - (255 - color.getAlpha() >> 1));
    }

    private static int[] createdArmedPixels(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i] >> 1 & 0x7F7F7F | 255 - (255 - (nArray[i] >> 24 & 0xFF) >> 1) << 24;
        }
        return nArray2;
    }

    private static int[] createdDisabledPixels(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        float[] fArray = new float[3];
        for (int i = 0; i < nArray2.length; ++i) {
            Color.RGBtoHSB(nArray[i] >> 16 & 0xFF, nArray[i] >> 8 & 0xFF, nArray[i] & 0xFF, fArray);
            int n = (int)(fArray[2] * 255.0f);
            nArray2[i] = n << 16 | n << 8 | n | nArray[i] >> 1 & 0x7F000000;
        }
        return nArray2;
    }

    private static Color createDisabledColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        int n = (int)(fArray[2] * 255.0f);
        return new Color(n, n, n, color.getAlpha() >> 1);
    }

    public void setNumItems(int n) {
        if (n >= 0 && n != this.numStates) {
            if (this.state >= n) {
                this.setSelectedIndex(n - 1);
            }
            while (this.numStates > n) {
                this.collStateViews.remove(this.numStates - 1);
                --this.numStates;
            }
            while (this.numStates < n) {
                StateView stateView = new StateView();
                this.collStateViews.add(stateView);
                ++this.numStates;
                this.configureTextColor(stateView, Color.black);
                this.configureBgColor(stateView);
            }
            if (this.numColumns == 0) {
                this.recalcPrefSize();
            }
        }
    }

    public void removeAllItems() {
        this.setNumItems(0);
    }

    public void setItemText(int n, String string) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            stateView.text = string;
            if (this.numColumns == 0) {
                this.recalcPrefSize();
            }
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItemIcon(int n, Icon icon) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            stateView.icon = icon;
            if (this.numColumns == 0) {
                this.recalcPrefSize();
            }
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItemTextColor(int n, Color color) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            this.configureTextColor(stateView, color == null ? Color.black : color);
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItemBgColor(int n, Color color) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            if (color == null) {
                this.configureBgColor(stateView);
            } else {
                this.configureBgColor(stateView, color);
            }
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItemBgColor(int n, Color color, Color color2) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            this.configureBgColor(stateView, color == null ? Color.white : color, color2 == null ? Color.white : color2);
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItem(int n, String string, Color color, Color color2) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            stateView.text = string;
            this.configureTextColor(stateView, color == null ? Color.black : color);
            if (color2 == null) {
                this.configureBgColor(stateView);
            } else {
                this.configureBgColor(stateView, color2);
            }
            if (this.numColumns == 0) {
                this.recalcPrefSize();
            }
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void setItem(int n, String string, Color color, Color color2, Color color3) {
        if (n < this.numStates) {
            StateView stateView = (StateView)this.collStateViews.get(n);
            stateView.text = string;
            this.configureTextColor(stateView, color == null ? Color.black : color);
            this.configureBgColor(stateView, color2 == null ? Color.white : color2, color3 == null ? Color.white : color3);
            if (this.numColumns == 0) {
                this.recalcPrefSize();
            }
            if (n == this.state) {
                this.repaint();
            }
        }
    }

    public void addItem(Object object) {
        this.addItem(object.toString(), Color.black, null);
    }

    public void addItem(String string, Color color, Color color2) {
        int n = this.numStates++;
        StateView stateView = new StateView();
        this.collStateViews.add(stateView);
        stateView.text = string;
        this.configureTextColor(stateView, color == null ? Color.black : color);
        if (color2 == null) {
            this.configureBgColor(stateView);
        } else {
            this.configureBgColor(stateView, color2);
        }
        if (this.numColumns == 0) {
            this.recalcPrefSize();
        }
        if (n == 0) {
            this.setSelectedIndex(n);
        }
    }

    public void addItem(String string, Color color, Color color2, Color color3) {
        int n = this.numStates++;
        StateView stateView = new StateView();
        this.collStateViews.add(stateView);
        stateView.text = string;
        this.configureTextColor(stateView, color == null ? Color.black : color);
        this.configureBgColor(stateView, color2 == null ? Color.white : color2, color3 == null ? Color.white : color3);
        if (this.numColumns == 0) {
            this.recalcPrefSize();
        }
        if (n == 0) {
            this.setSelectedIndex(n);
        }
    }

    public void setSelectedIndex(int n) {
        if (this.state != n) {
            this.state = n;
            this.repaint();
        }
    }

    public int getSelectedIndex() {
        return this.state;
    }

    public int getLastModifiers() {
        return this.lastModifiers;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        StateView stateView;
        super.paintComponent(graphics);
        if (this.state < 0 || this.state >= this.numStates) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Composite composite = graphics2D.getComposite();
        int n7 = this.isEnabled() ? (this.model.isArmed() ? 1 : 0) : 2;
        Insets insets = this.getInsets();
        int n8 = insets.left;
        int n9 = insets.top;
        int n10 = n8 + 3;
        int n11 = n9 + 3;
        int n12 = this.getWidth() - insets.right;
        int n13 = this.getHeight() - insets.bottom;
        int n14 = n12 - n8;
        int n15 = n13 - n9;
        int n16 = n14 - 6;
        int n17 = n15 - 6;
        int n18 = n15 >> 1;
        int n19 = n15 - n18;
        if (n14 != this.recentWidth) {
            for (int i = 0; i < this.collStateViews.size(); ++i) {
                stateView = (StateView)this.collStateViews.get(i);
                if (!stateView.isGradient) continue;
                stateView.pntBack = null;
            }
            this.recentWidth = n14;
        }
        stateView = (StateView)this.collStateViews.get(this.state);
        if (stateView.isGradient && stateView.pntBack == null) {
            stateView.pntBack = new GradientPaint(0.0f, 0.0f, stateView.colrBackGrad1, n14 - 1, 0.0f, stateView.colrBackGrad2);
        }
        if (stateView.isGradient || stateView.isClear) {
            graphics2D.setColor(colrBackTop[n7]);
            graphics2D.fillRect(n8 + 1, n9 + 1, n14 - 2, n18 - 1);
            graphics2D.setColor(colrBackBot[n7]);
            graphics2D.fillRect(n8 + 1, n9 + n18, n14 - 2, n19 - 7);
            graphics2D.translate(n8 + 1, n13 - 7);
            graphics2D.setPaint(pntBackBot[n7]);
            graphics2D.fillRect(0, 0, n14 - 2, 6);
            if (stateView.isGradient) {
                graphics2D.translate(0, n9 - n13 + 8);
                graphics2D.setComposite(this);
                graphics2D.setPaint(stateView.pntBack);
                graphics2D.fillRect(0, 0, n14 - 2, n15 - 2);
                graphics2D.setComposite(composite);
            }
        } else {
            graphics2D.setColor(stateView.colrSVBackTop[n7]);
            graphics2D.fillRect(n8 + 1, n9 + 1, n14 - 2, n18 - 1);
            graphics2D.setColor(stateView.colrSVBackBot[n7]);
            graphics2D.fillRect(n8 + 1, n9 + n18, n14 - 2, n19 - 7);
            graphics2D.translate(n8 + 1, n13 - 7);
            graphics2D.setPaint(stateView.pntSVBackBot[n7]);
            graphics2D.fillRect(0, 0, n14 - 2, 6);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(colrBorderCorner[n7]);
        graphics2D.drawLine(n8, n9, n8 + 1, n9);
        graphics2D.drawLine(n12 - 2, n9, n12 - 1, n9);
        graphics2D.setColor(colrBorderTopS);
        graphics2D.drawLine(n8, n9 - 1, n12, n9 - 1);
        graphics2D.setColor(colrBorderTop[n7]);
        graphics2D.drawLine(n8 + 1, n9, n12 - 2, n9);
        graphics2D.setColor(colrBorderRest[n7]);
        graphics2D.drawLine(n8, n9 + 1, n8, n13 - 2);
        graphics2D.drawLine(n12 - 1, n9 + 1, n12 - 1, n13 - 2);
        graphics2D.drawLine(n8, n13 - 1, n12 - 1, n13 - 1);
        graphics2D.setColor(colrBorderBotS);
        graphics2D.drawLine(n8, n13, n12 - 1, n13);
        if (stateView.text != null && stateView.text != this.lastTxt) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.lastTxt = stateView.text;
            this.txtWidth = fontMetrics.stringWidth(this.lastTxt);
            this.txtHeight = fontMetrics.getHeight();
            this.txtAscent = fontMetrics.getAscent();
        }
        if (stateView.icon == null) {
            n6 = 0;
            n5 = 0;
            if (stateView.text == null) {
                n4 = 0;
                n3 = 0;
            } else {
                n4 = this.txtWidth;
                n3 = this.txtHeight;
            }
        } else {
            n6 = stateView.icon.getIconWidth();
            n5 = stateView.icon.getIconHeight();
            if (stateView.text == null) {
                n4 = n6;
                n3 = n5;
            } else {
                n4 = this.getHorizontalTextPosition() != 0 ? n6 + this.txtWidth + this.getIconTextGap() : Math.max(n6, this.txtWidth);
                n3 = Math.max(this.txtHeight, n5);
            }
        }
        switch (this.getHorizontalAlignment()) {
            case 0: {
                n2 = (n16 - n4 >> 1) + n10;
                break;
            }
            case 2: 
            case 10: {
                n2 = n10;
                break;
            }
            case 4: 
            case 11: {
                n2 = n16 - n4 + n10;
                break;
            }
            default: {
                throw new IllegalArgumentException("horizontalAlignment " + this.getHorizontalAlignment());
            }
        }
        switch (this.getVerticalAlignment()) {
            case 0: {
                n = (n17 - n3 >> 1) + n11;
                break;
            }
            case 1: {
                n = n11;
                break;
            }
            case 3: {
                n = n17 - n3 + n11;
                break;
            }
            default: {
                throw new IllegalArgumentException("verticalAlignment " + this.getVerticalAlignment());
            }
        }
        if (stateView.icon != null) {
            int n20;
            int n21;
            switch (this.getHorizontalTextPosition()) {
                case 0: {
                    n21 = (n4 - n6 >> 1) + n2;
                    break;
                }
                case 2: 
                case 10: {
                    n21 = n4 - n6 + n2;
                    break;
                }
                case 4: 
                case 11: {
                    n21 = n2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("horizontalTextPosition " + this.getHorizontalTextPosition());
                }
            }
            switch (this.getVerticalTextPosition()) {
                case 0: {
                    n20 = (n3 - n5 >> 1) + n;
                    break;
                }
                case 1: {
                    n20 = n;
                    break;
                }
                case 3: {
                    n20 = n3 - n5 + n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("verticalTextPosition " + this.getVerticalTextPosition());
                }
            }
            stateView.icon.paintIcon(this, graphics, n21, n20);
        }
        if (stateView.text != null) {
            int n22;
            int n23;
            switch (this.getHorizontalTextPosition()) {
                case 0: {
                    n23 = (n4 - this.txtWidth >> 1) + n2;
                    break;
                }
                case 2: 
                case 10: {
                    n23 = n2;
                    break;
                }
                case 4: 
                case 11: {
                    n23 = n4 - this.txtWidth + n2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("horizontalTextPosition " + this.getHorizontalTextPosition());
                }
            }
            switch (this.getVerticalTextPosition()) {
                case 0: {
                    n22 = (n3 - this.txtHeight >> 1) + n;
                    break;
                }
                case 1: {
                    n22 = n;
                    break;
                }
                case 3: {
                    n22 = n3 - this.txtHeight + n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("verticalTextPosition " + this.getVerticalTextPosition());
                }
            }
            graphics2D.setColor(stateView.colrLabel[n7]);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawString(this.lastTxt, n23, n22 + this.txtAscent);
        }
    }

    public static void makeTestFrame(int n, int n2) {
        JFrame jFrame = new JFrame("Test ");
        Container container = jFrame.getContentPane();
        int[] nArray = new int[]{2, 0, 4};
        int[] nArray2 = new int[]{1, 0, 3};
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(Color.red);
                graphics.drawRect(n, n2, 39, 39);
            }

            @Override
            public int getIconWidth() {
                return 40;
            }

            @Override
            public int getIconHeight() {
                return 40;
            }
        };
        container.setLayout(new GridLayout(3, 3));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                MultiStateButton multiStateButton = new MultiStateButton();
                multiStateButton.addItem("Test");
                multiStateButton.setItemIcon(0, icon);
                multiStateButton.setHorizontalAlignment(nArray[j]);
                multiStateButton.setVerticalAlignment(nArray2[i]);
                multiStateButton.setHorizontalTextPosition(n);
                multiStateButton.setVerticalTextPosition(n2);
                multiStateButton.setIconTextGap(16);
                container.add(multiStateButton);
            }
        }
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.toFront();
    }

    private void lala(InputEvent inputEvent) {
        this.model.setPressed(true);
        if (this.model.isArmed()) {
            if (this.autoStep && this.numStates > 0) {
                this.state = (this.state + 1) % this.numStates;
            }
            this.lastModifiers = inputEvent.getModifiers();
            this.fireActionPerformed(new ActionEvent(this, 1001, "", inputEvent.getWhen(), this.lastModifiers));
            this.model.setArmed(false);
            this.repaint();
        }
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return this;
    }

    @Override
    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = raster2.getDataBuffer();
        DataBuffer dataBuffer3 = writableRaster.getDataBuffer();
        int n = dataBuffer3.getSize();
        for (int i = 0; i < n; ++i) {
            int n2 = dataBuffer.getElem(i);
            int n3 = dataBuffer2.getElem(i);
            dataBuffer3.setElem(i, (n2 & 0xFF) * (n3 & 0xFF) >> 8 | (n2 >> 8 & 0xFF) * (n3 >> 8 & 0xFF) & 0xFF00 | (n2 >> 16 & 0xFF) * (n3 >> 16 & 0xFF) << 8 & 0xFF0000 | (n2 >> 24 & 0xFF) * (n3 >> 24 & 0xFF) << 16 & 0xFF000000);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        if (mouseEvent.isControlDown()) {
            return;
        }
        this.model.setArmed(true);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.lala(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        if (!this.isEnabled() || mouseEvent.isControlDown()) {
            return;
        }
        boolean bl2 = this.model.isArmed();
        if (bl2 != (bl = this.contains(mouseEvent.getPoint()))) {
            this.model.setArmed(bl);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled() && keyEvent.getKeyChar() == ' ' && !this.model.isArmed()) {
            this.model.setArmed(true);
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.isEnabled() && keyEvent.getKeyChar() == ' ') {
            this.lala(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.lastTxt = null;
        this.recalcPrefSize();
        this.repaint();
    }

    static {
        colrBackTopN = new Color(0, 0, 0, 4);
        colrBackBotN = new Color(0, 0, 0, 19);
        Rectangle rectangle = new Rectangle(0, 0, 1, 6);
        pntBackBot = new Paint[3];
        BufferedImage bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, pntBackPix, 0, 1);
        MultiStateButton.pntBackBot[0] = new TexturePaint(bufferedImage, rectangle);
        bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, MultiStateButton.createdArmedPixels(pntBackPix), 0, 1);
        MultiStateButton.pntBackBot[1] = new TexturePaint(bufferedImage, rectangle);
        bufferedImage = new BufferedImage(1, 6, 2);
        bufferedImage.setRGB(0, 0, 1, 6, MultiStateButton.createdDisabledPixels(pntBackPix), 0, 1);
        MultiStateButton.pntBackBot[2] = new TexturePaint(bufferedImage, rectangle);
    }

    private static class StateView {
        protected String text;
        protected Paint pntBack;
        protected Color[] colrLabel = new Color[3];
        protected Color colrBackGrad1;
        protected Color colrBackGrad2;
        protected boolean isGradient;
        protected boolean isClear;
        protected Color[] colrSVBackTop = new Color[3];
        protected Color[] colrSVBackBot = new Color[3];
        protected Paint[] pntSVBackBot = new Paint[3];
        protected Icon icon;

        protected StateView() {
        }
    }
}

