/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.ColouredTextField;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.PathButton;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathList;
import de.sciss.gui.PathListener;
import de.sciss.gui.SpringPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PathField
extends SpringPanel
implements ActionListener,
PathListener,
EventManager.Processor {
    public static final int TYPE_BASICMASK = 15;
    public static final int TYPE_INPUTFILE = 0;
    public static final int TYPE_FORMATFIELD = 16;
    public static final int TYPE_OUTPUTFILE = 1;
    public static final int TYPE_FOLDER = 2;
    protected static PathList userPaths = null;
    private static final int USERPATHS_NUM = 9;
    private static final int ABBR_LENGTH = 12;
    protected final IOTextField ggPath;
    protected final PathButton ggChoose;
    protected final JLabel lbWarn;
    protected ColouredTextField ggFormat = null;
    private static final Color COLOR_ERR = new Color(255, 0, 0, 47);
    private static final Color COLOR_EXISTS = new Color(0, 0, 255, 47);
    protected static final Color COLOR_PROPSET = new Color(0, 255, 0, 47);
    private final int type;
    protected String scheme;
    protected String protoScheme;
    private PathField[] superPaths;
    private final List collChildren = new ArrayList();
    private final EventManager elm = new EventManager(this);
    private static final int MENU_SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected static final int myMeta = MENU_SHORTCUT == 2 ? 3 : MENU_SHORTCUT;
    private static Icon icnAlertStop = null;
    private boolean warnWhenExists = false;
    private boolean errWhenExistsNot = false;
    private boolean errWhenWriteProtected = false;

    public PathField() {
        this(0);
    }

    public PathField(int n) {
        this.type = n;
        if (userPaths == null && (userPaths = new PathList(9, GUIUtil.getUserPrefs(), "usrpaths")).getPathCount() < 9) {
            File file = new File(System.getProperty("user.home"));
            File[] fileArray = file.listFiles();
            userPaths.addPathToHead(file);
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length && userPaths.getPathCount() < 9; ++i) {
                    if (!fileArray[i].isDirectory() || fileArray[i].isHidden()) continue;
                    userPaths.addPathToTail(fileArray[i]);
                }
            }
            while (userPaths.getPathCount() < 9) {
                userPaths.addPathToTail(file);
            }
        }
        this.lbWarn = new JLabel();
        this.gridAdd(this.lbWarn, 0, 0);
        this.ggPath = new IOTextField();
        this.ggPath.addActionListener(this);
        this.ggChoose = this.createPathButton(n);
        this.ggChoose.addPathListener(this);
        this.gridAdd(this.ggPath, 1, 0);
        if ((n & 0x10) != 0) {
            this.ggFormat = new ColouredTextField();
            this.ggFormat.setEditable(false);
            this.ggFormat.setBackground(null);
            this.gridAdd(this.ggFormat, 1, 1);
        }
        this.gridAdd(this.ggChoose, 2, 0);
        this.makeCompactGrid();
        this.deriveFrom(new PathField[0], "");
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Font font = ((PathField)propertyChangeEvent.getSource()).getFont();
                PathField.this.ggPath.setFont(font);
                if (PathField.this.ggFormat != null) {
                    PathField.this.ggFormat.setFont(font);
                }
            }
        });
    }

    public PathField(int n, String string) {
        this(n);
        this.ggChoose.setDialogText(string);
        if ((n & 1) != 0) {
            this.warnWhenExists = true;
            this.errWhenWriteProtected = true;
        } else {
            this.errWhenExistsNot = true;
        }
    }

    public void setPath(File file) {
        this.setPathIgnoreScheme(file);
        this.scheme = this.createScheme(file.getPath());
    }

    public void setWarnWhenExists(boolean bl) {
        if (this.warnWhenExists != bl) {
            this.warnWhenExists = bl;
            this.updateIconAndColour();
        }
    }

    public void setErrWhenExistsOn(boolean bl) {
        if (this.errWhenExistsNot != bl) {
            this.errWhenExistsNot = bl;
            this.updateIconAndColour();
        }
    }

    public void setErrWhenWriteProtected(boolean bl) {
        if (this.errWhenWriteProtected != bl) {
            this.errWhenWriteProtected = bl;
            this.updateIconAndColour();
        }
    }

    private void setPathIgnoreScheme(File file) {
        this.ggPath.setText(file.getPath());
        this.ggChoose.setPath(file);
        for (int i = 0; i < this.collChildren.size(); ++i) {
            ((PathField)this.collChildren.get(i)).motherSpeaks(file);
        }
        this.updateIconAndColour();
    }

    protected void setPathAndDispatchEvent(File file) {
        this.setPathIgnoreScheme(file);
        this.elm.dispatchEvent(new PathEvent(this, 0, System.currentTimeMillis(), file));
    }

    public File getPath() {
        return new File(this.ggPath.getText());
    }

    public void setFormat(String string, boolean bl) {
        if (this.ggFormat == null) {
            throw new IllegalStateException();
        }
        this.ggFormat.setText(string);
        this.ggFormat.setPaint(bl ? null : COLOR_ERR);
    }

    public String getFormat() {
        if (this.ggFormat != null) {
            return this.ggFormat.getText();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.ggChoose.setFilter(filenameFilter);
    }

    public FilenameFilter getFilter() {
        return this.ggChoose.getFilter();
    }

    public void selectFileName(boolean bl) {
        String string = this.ggPath.getText();
        int n = string.lastIndexOf(File.separatorChar) + 1;
        int n2 = string.lastIndexOf(46);
        this.ggPath.select(n, n2 >= n ? n2 : string.length());
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.ggPath.requestFocusInWindow();
    }

    public void deriveFrom(PathField[] pathFieldArray, String string) {
        this.superPaths = pathFieldArray;
        this.scheme = string;
        this.protoScheme = string;
        for (int i = 0; i < pathFieldArray.length; ++i) {
            pathFieldArray[i].addChildPathField(this);
        }
    }

    private void addChildPathField(PathField pathField) {
        if (!this.collChildren.contains(pathField)) {
            this.collChildren.add(pathField);
        }
    }

    private void motherSpeaks(File file) {
        this.setPathAndDispatchEvent(new File(this.evalScheme(this.scheme)));
    }

    public void addPathListener(PathListener pathListener) {
        this.elm.addListener(pathListener);
    }

    public void removePathListener(PathListener pathListener) {
        this.elm.removeListener(pathListener);
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            PathListener pathListener = (PathListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    pathListener.pathChanged((PathEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    private static Icon getAlertStopIcon() {
        if (icnAlertStop == null) {
            icnAlertStop = new ImageIcon(PathField.class.getResource("alertstop.png"));
        }
        return icnAlertStop;
    }

    private void updateIconAndColour() {
        File file = this.getPath();
        File file2 = file.getParentFile();
        boolean bl = (this.type & 2) != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.warnWhenExists || this.errWhenExistsNot || this.errWhenWriteProtected) {
            String string;
            Icon icon;
            Color color;
            try {
                bl2 = file2 != null && file2.isDirectory();
                boolean bl5 = bl3 = bl ? file.isDirectory() : file.isFile();
                if (this.errWhenWriteProtected) {
                    bl4 = bl2 && (bl3 && !file.canWrite() || !bl3 && !file2.canWrite());
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (this.errWhenWriteProtected && (bl4 || !bl2)) {
                color = COLOR_ERR;
                icon = GUIUtil.getNoWriteIcon();
                string = GUIUtil.getResourceString(bl ? "ttWarnFolderWriteProtected" : "ttWarnFileWriteProtected");
            } else if (this.errWhenExistsNot && !bl3) {
                color = COLOR_ERR;
                icon = PathField.getAlertStopIcon();
                string = GUIUtil.getResourceString(bl ? "ttWarnFolderExistsNot" : "ttWarnFileExistsNot");
            } else if (this.warnWhenExists && bl3) {
                color = COLOR_EXISTS;
                icon = PathField.getAlertStopIcon();
                string = GUIUtil.getResourceString(bl ? "ttWarnFolderExists" : "ttWarnFileExists");
            } else {
                color = null;
                icon = null;
                string = null;
            }
            if (color != this.ggPath.getPaint()) {
                this.ggPath.setPaint(color);
            }
            if (this.lbWarn.getIcon() != icon) {
                this.lbWarn.setIcon(icon);
            }
            if (this.lbWarn.getToolTipText() != string) {
                this.lbWarn.setToolTipText(string);
            }
        }
    }

    protected String evalScheme(String string) {
        int n;
        String string2;
        int n2;
        int n3 = string.indexOf("$D");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string = string.substring(0, n3) + string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1) + string.substring(n3 + 3);
            n3 = string.indexOf("$D", n3);
        }
        n3 = string.indexOf("$F");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string = string.substring(0, n3) + (n > 0 ? string2.substring(0, n) : string2) + string.substring(n3 + 3);
            n3 = string.indexOf("$F", n3);
        }
        n3 = string.indexOf("$X");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string = string.substring(0, n3) + (n > 0 ? string2.substring(n) : "") + string.substring(n3 + 3);
            n3 = string.indexOf("$X", n3);
        }
        n3 = string.indexOf("$B");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string2 = PathField.abbreviate(n > 0 ? string2.substring(0, n) : string2);
            string = string.substring(0, n3) + string2 + string.substring(n3 + 3);
            n3 = string.indexOf("$B", n3);
        }
        return string;
    }

    private static String abbreviate(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n2 && stringBuffer.length() + n2 - n > 12; ++n) {
            c = string.charAt(n);
            if (!Character.isLetterOrDigit(c)) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append(string.substring(n));
        string = stringBuffer.toString();
        n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string.charAt(0));
        for (n = 1; n < n2 - 1 && stringBuffer.length() + n2 - n > 12; ++n) {
            c = string.charAt(n);
            if ("aeiou\u221a\u00a7\u221a\u2202\u221a\u00ba".indexOf(c) >= 0) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append(string.substring(n));
        string = stringBuffer.toString();
        n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        n = 5;
        return string.substring(0, n) + '\'' + string.substring(string.length() - n);
    }

    private String createScheme(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        if (string.length() == 0) {
            return this.protoScheme;
        }
        for (n = 0; n < this.superPaths.length; ++n) {
            string2 = this.superPaths[n].getPath().getPath();
            if (!string.startsWith(string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1))) continue;
            string = "$D" + (char)(n + 48) + string.substring(string2.length());
            n2 = 3;
            break;
        }
        n2 = Math.max(n2, string.lastIndexOf(File.separatorChar) + 1);
        int n3 = -1;
        for (n = 0; n < this.superPaths.length; ++n) {
            boolean bl;
            string2 = this.superPaths[n].getPath().getPath();
            int n4 = (string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1)).lastIndexOf(46);
            String string3 = string2 = n4 > 0 ? string2.substring(0, n4) : string2;
            if (this.protoScheme.indexOf("$B" + (char)(n + 48)) < 0 || n3 == n) {
                n4 = string.indexOf(string2, n2);
                if (n4 >= 0) {
                    string = string.substring(0, n4) + "$F" + (char)(n + 48) + string.substring(n4 + string2.length());
                    n2 = n4 + 3;
                    continue;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (n3 == n) continue;
            n4 = string.indexOf(string2 = PathField.abbreviate(string2), n2);
            if (n4 >= 0) {
                string = string.substring(0, n4) + "$B" + (char)(n + 48) + string.substring(n4 + string2.length());
                n2 = n4 + 3;
                continue;
            }
            if (bl) continue;
            n3 = n--;
        }
        return string;
    }

    protected String abbrScheme(String string) {
        int n = string.lastIndexOf("$F");
        if (n >= 0) {
            return string.substring(0, n) + "$B" + string.substring(n + 2);
        }
        return string;
    }

    protected String expandScheme(String string) {
        int n = string.indexOf("$B");
        if (n >= 0) {
            return string.substring(0, n) + "$F" + string.substring(n + 2);
        }
        return string;
    }

    protected String udirScheme(String string, int n) {
        File file = userPaths.getPath(n);
        if (file == null) {
            return string;
        }
        int n2 = string.startsWith("$D") ? 3 : string.lastIndexOf(File.separatorChar) + 1;
        return new File(file, string.substring(n2)).getPath();
    }

    protected PathButton createPathButton(int n) {
        return new PathButton(n);
    }

    @Override
    public void pathChanged(PathEvent pathEvent) {
        File file = pathEvent.getPath();
        this.scheme = this.createScheme(file.getPath());
        this.setPathAndDispatchEvent(file);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.ggPath.getText();
        if (this.ggPath.getText().length() == 0) {
            string = this.evalScheme(this.scheme);
        } else {
            this.scheme = this.createScheme(string);
        }
        this.setPathAndDispatchEvent(new File(string));
    }

    protected class IOTextField
    extends ColouredTextField {
        protected IOTextField() {
            super(32);
            InputMap inputMap = this.getInputMap();
            ActionMap actionMap = this.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(37, myMeta + 8), "abbr");
            actionMap.put("abbr", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.abbrScheme(PathField.this.scheme);
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(39, myMeta + 8), "expd");
            actionMap.put("expd", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.expandScheme(PathField.this.scheme);
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(27, myMeta), "auto");
            actionMap.put("auto", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.protoScheme;
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "lost");
            actionMap.put("lost", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JRootPane jRootPane = SwingUtilities.getRootPane(IOTextField.this);
                    if (jRootPane != null) {
                        jRootPane.requestFocus();
                    }
                }
            });
            for (int i = 0; i < 9; ++i) {
                String string = "sudir" + i;
                inputMap.put(KeyStroke.getKeyStroke(97 + i, myMeta + 8), string);
                actionMap.put(string, new SetUserDirAction(i));
                string = "rudir" + i;
                inputMap.put(KeyStroke.getKeyStroke(97 + i, myMeta), string);
                actionMap.put(string, new RecallUserDirAction(i));
            }
        }

        private class RecallUserDirAction
        extends AbstractAction {
            private int idx;

            protected RecallUserDirAction(int n) {
                this.idx = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PathField.this.scheme = PathField.this.udirScheme(PathField.this.scheme, this.idx);
                PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
            }
        }

        private class SetUserDirAction
        extends AbstractAction {
            private int idx;
            private Timer visualFeedback;
            private Paint oldPaint = null;

            protected SetUserDirAction(int n) {
                this.idx = n;
                this.visualFeedback = new Timer(250, this);
                this.visualFeedback.setRepeats(false);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.visualFeedback) {
                    PathField.this.ggPath.setPaint(this.oldPaint);
                } else {
                    File file = PathField.this.getPath().getParentFile();
                    if (file != null) {
                        userPaths.setPath(this.idx, file);
                        if (this.visualFeedback.isRunning()) {
                            this.visualFeedback.restart();
                        } else {
                            this.oldPaint = PathField.this.ggPath.getPaint();
                            PathField.this.ggPath.setPaint(COLOR_PROPSET);
                            this.visualFeedback.start();
                        }
                    }
                }
            }
        }
    }
}

