/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.MenuAction;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;

public abstract class PrefMenuAction
extends MenuAction
implements PreferenceEntrySync,
PreferenceChangeListener,
LaterInvocationManager.Listener {
    private Preferences prefs = null;
    private String key = null;
    private LaterInvocationManager lim = null;
    private boolean readPrefs = true;
    private boolean writePrefs = true;

    public PrefMenuAction(String string, KeyStroke keyStroke) {
        super(string, keyStroke);
    }

    public PrefMenuAction(String string, KeyStroke keyStroke, boolean bl, boolean bl2) {
        this(string, keyStroke);
        this.setReadPrefs(bl);
        this.setWritePrefs(bl2);
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        this.writePrefs = bl;
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    protected boolean canWritePrefs() {
        return this.prefs != null && this.key != null;
    }

    protected boolean shouldWritePrefs() {
        return this.prefs != null && this.key != null && this.writePrefs;
    }

    @Override
    public void setPreferenceKey(String string) {
        this.key = string;
        this.readPrefs();
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        if (this.prefs != null && this.readPrefs) {
            this.prefs.removePreferenceChangeListener(this);
        }
        this.prefs = preferences;
        if (preferences != null) {
            if (this.readPrefs) {
                preferences.addPreferenceChangeListener(this);
            }
            this.readPrefs();
        }
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        this.key = string;
        this.setPreferenceNode(preferences);
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            if (this.lim == null) {
                this.lim = new LaterInvocationManager(this);
            }
            this.lim.queue(preferenceChangeEvent);
        }
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    @Override
    public final void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    protected abstract void readPrefsFromString(String var1);
}

