/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.ParamField;
import de.sciss.util.Param;
import de.sciss.util.ParamSpace;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PrefParamField
extends ParamField
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private ParamField.Listener listener;
    private Param defaultValue = null;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefParamField() {
        this.init();
    }

    public PrefParamField(ParamSpace.Translator translator) {
        super(translator);
        this.init();
    }

    private void init() {
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new ParamField.Listener(){

            @Override
            public void paramValueChanged(ParamField.Event event) {
                if (event.isAdjusting()) {
                    return;
                }
                if (PrefParamField.this.writePrefs) {
                    PrefParamField.this.writePrefs();
                }
            }

            @Override
            public void paramSpaceChanged(ParamField.Event event) {
                if (PrefParamField.this.writePrefs) {
                    PrefParamField.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addListener(this.listener);
                } else {
                    this.removeListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            String string = this.prefs.get(this.key, null);
            Param param = string == null ? null : Param.valueOf(string);
            Param param2 = this.getValue();
            if (param == null && param2 != null || param != null && (param2 == null || !param2.equals(param))) {
                this.prefs.put(this.key, param2.toString());
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            this.defaultValue = this.getValue();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.listening) {
            return;
        }
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (!this.listening) {
            return;
        }
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removeListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    public void readPrefsFromString(String string) {
        Param param;
        if (string == null) {
            if (this.defaultValue != null) {
                this.setValue(this.defaultValue);
                if (this.writePrefs) {
                    this.writePrefs();
                }
            }
            return;
        }
        int n = string.indexOf(32);
        Param param2 = this.getValue();
        ParamSpace paramSpace = null;
        boolean bl = false;
        try {
            int n2;
            double d;
            if (n >= 0) {
                d = Double.parseDouble(string.substring(0, n));
                n2 = ParamSpace.stringToUnit(string.substring(n + 1));
            } else {
                d = Double.parseDouble(string);
                n2 = param2.unit;
            }
            if (n2 != param2.unit) {
                for (int i = 0; i < this.collSpaces.size(); ++i) {
                    paramSpace = (ParamSpace)this.collSpaces.get(i);
                    if (paramSpace.unit != n2) continue;
                    bl = true;
                    break;
                }
                param = bl ? new Param(d, paramSpace.unit) : this.getTranslator().translate(new Param(d, n2), paramSpace);
            } else {
                param = new Param(d, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            param = param2;
        }
        if (!param.equals(param2)) {
            if (this.listening && this.writePrefs) {
                this.removeListener(this.listener);
            }
            if (bl) {
                this.setSpace(paramSpace);
                this.fireSpaceChanged();
            }
            this.setValue(param);
            this.fireValueChanged(false);
            if (this.listening && this.writePrefs) {
                this.addListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }

    @Override
    public void setItem(Object object) {
        if (!this.getComboGate() || object == null) {
            return;
        }
        super.setItem(object);
        if (this.writePrefs) {
            this.writePrefs();
        }
    }
}

