/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringPanel
extends JPanel {
    private final SpringLayout layout = new SpringLayout();
    private int xPad;
    private int yPad;
    private int initialX;
    private int initialY;
    private static final Object GRID = "de.sciss.gui.GRID";

    public SpringPanel() {
        this.setLayout(this.layout);
    }

    public SpringPanel(int n, int n2, int n3, int n4) {
        this();
        this.setPadding(n, n2, n3, n4);
    }

    public void setInitialX(int n) {
        this.initialX = n;
    }

    public void setInitialY(int n) {
        this.initialY = n;
    }

    public void setXPad(int n) {
        this.xPad = n;
    }

    public void setYPad(int n) {
        this.yPad = n;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.initialX = n;
        this.initialY = n2;
        this.xPad = n3;
        this.yPad = n4;
    }

    public void gridAdd(JComponent jComponent, int n, int n2) {
        this.gridAdd(jComponent, n, n2, 1, 1);
    }

    public void gridAdd(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.gridAdd(jComponent, new Rectangle(n, n2, n3, n4));
    }

    public void gridAdd(JComponent jComponent, Rectangle rectangle) {
        jComponent.putClientProperty(GRID, rectangle);
        this.add(jComponent);
    }

    public void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(null, string));
    }

    public void makeGrid(boolean bl) {
        Spring spring;
        Spring spring2;
        RatioSpring ratioSpring;
        RatioSpring ratioSpring2;
        SpringLayout.Constraints constraints;
        Spring spring3;
        Spring spring4;
        int n;
        JComponent jComponent;
        Rectangle rectangle;
        int n2;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.getComponentCount());
        int n3 = 0;
        int n4 = 0;
        Spring spring5 = Spring.constant(this.xPad);
        Spring spring6 = Spring.constant(this.yPad);
        Spring spring7 = Spring.constant(this.initialX);
        Spring spring8 = Spring.constant(this.initialY);
        for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
            Component component = this.getComponent(n2);
            this.layout.removeLayoutComponent(component);
            if (!(component instanceof JComponent) || !component.isVisible() || (rectangle = (Rectangle)(jComponent = (JComponent)component).getClientProperty(GRID)) == null) continue;
            arrayList.add(jComponent);
            n4 = Math.max(n4, rectangle.x + rectangle.width);
            n3 = Math.max(n3, rectangle.y + rectangle.height);
        }
        if (n4 == 0 || n3 == 0) {
            return;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            jComponent = (JComponent)arrayList.get(n2);
            rectangle = (Rectangle)jComponent.getClientProperty(GRID);
            n = rectangle.x;
            while (n < rectangle.x + rectangle.width) {
                int n5 = n++;
                nArray[n5] = nArray[n5] + 1;
            }
            n = rectangle.y;
            while (n < rectangle.y + rectangle.height) {
                int n6 = n++;
                nArray2[n6] = nArray2[n6] + 1;
            }
        }
        n = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (nArray[n2] <= 0) continue;
            nArray[n2] = n++;
        }
        n = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[n2] <= 0) continue;
            nArray2[n2] = n++;
        }
        int n7 = nArray[n4 - 1] + 1;
        int n8 = nArray2[n3 - 1] + 1;
        if (bl) {
            spring4 = new ComponentWidthRatioSpring(this, 1, n7);
            spring3 = new ComponentHeightRatioSpring(this, 1, n8);
        } else {
            spring4 = Spring.constant(0);
            spring3 = Spring.constant(0);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            jComponent = (JComponent)arrayList.get(n2);
            rectangle = (Rectangle)jComponent.getClientProperty(GRID);
            constraints = this.layout.getConstraints(jComponent);
            ratioSpring2 = new RatioSpring(constraints.getWidth(), 1, rectangle.width);
            ratioSpring = new RatioSpring(constraints.getHeight(), 1, rectangle.height);
            spring4 = Spring.max(spring4, ratioSpring2);
            spring3 = Spring.max(spring3, ratioSpring);
        }
        System.err.println("cols " + n4 + "; rows " + n3 + "; maxWidthSpring " + spring4.getValue() + "; maxHeightSpring " + spring3.getValue());
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            jComponent = (JComponent)arrayList.get(n2);
            rectangle = (Rectangle)jComponent.getClientProperty(GRID);
            constraints = this.layout.getConstraints(jComponent);
            ratioSpring2 = new RatioSpring(spring4, rectangle.width, 1);
            ratioSpring = new RatioSpring(spring3, rectangle.height, 1);
            constraints.setWidth(ratioSpring2);
            constraints.setHeight(ratioSpring);
            spring2 = spring7;
            if (nArray[rectangle.x] > 0) {
                spring2 = Spring.sum(spring2, new RatioSpring(spring4, nArray[rectangle.x], 1));
            }
            spring = spring8;
            if (nArray2[rectangle.y] > 0) {
                spring = Spring.sum(spring, new RatioSpring(spring3, nArray2[rectangle.y], 1));
            }
            constraints.setX(spring2);
            constraints.setY(spring);
            if (!(jComponent instanceof AbstractButton)) continue;
            System.out.println("For " + ((AbstractButton)jComponent).getText() + " spX " + spring2.getValue() + "; spY " + spring.getValue() + "; spW " + ((Spring)ratioSpring2).getValue() + "; spH " + ((Spring)ratioSpring).getValue() + "; r.x " + rectangle.x + "; r.y " + rectangle.y + "; r.width " + rectangle.width + "; r.height " + rectangle.height);
        }
        System.err.println("effCols = " + n7 + "; effRows = " + n8);
        if (!bl) {
            spring2 = Spring.sum(spring7, Spring.sum(spring5, new RatioSpring(spring4, n7, 1)));
            spring = Spring.sum(spring8, Spring.sum(spring6, new RatioSpring(spring3, n8, 1)));
            System.err.println(" yields east : " + Spring.sum(Spring.constant(this.xPad), spring2).getValue() + "; south : " + Spring.sum(Spring.constant(this.yPad), spring).getValue());
            constraints = this.layout.getConstraints(this);
            constraints.setConstraint("East", spring2);
            constraints.setConstraint("South", spring);
        }
    }

    public void makeCompactGrid() {
        this.makeCompactGrid(true, true);
    }

    public void makeCompactGrid(boolean bl, boolean bl2) {
        Spring spring;
        Spring spring2;
        int n;
        SpringLayout.Constraints constraints;
        JComponent jComponent;
        Rectangle rectangle;
        int n2;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.getComponentCount());
        int n3 = 0;
        int n4 = 0;
        Spring spring3 = Spring.constant(this.xPad);
        Spring spring4 = Spring.constant(this.yPad);
        for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
            Component component = this.getComponent(n2);
            this.layout.removeLayoutComponent(component);
            if (!(component instanceof JComponent) || !component.isVisible() || (rectangle = (Rectangle)(jComponent = (JComponent)component).getClientProperty(GRID)) == null) continue;
            arrayList.add(jComponent);
            n4 = Math.max(n4, rectangle.x + Math.abs(rectangle.width));
            n3 = Math.max(n3, rectangle.y + Math.abs(rectangle.height));
        }
        if (n4 == 0 || n3 == 0) {
            return;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n3];
        Spring[] springArray = new Spring[n4];
        Spring[] springArray2 = new Spring[n3];
        Spring[] springArray3 = new Spring[n4];
        Spring[] springArray4 = new Spring[n3];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            jComponent = (JComponent)arrayList.get(n2);
            rectangle = (Rectangle)jComponent.getClientProperty(GRID);
            constraints = this.layout.getConstraints(jComponent);
            for (n = rectangle.x; n < rectangle.x + Math.abs(rectangle.width); ++n) {
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
                spring2 = new RatioSpring(constraints.getWidth(), 1, Math.abs(rectangle.width));
                springArray3[n] = springArray3[n] == null ? spring2 : Spring.max(springArray3[n], spring2);
            }
            for (n = rectangle.y; n < rectangle.y + Math.abs(rectangle.height); ++n) {
                int n6 = n;
                nArray2[n6] = nArray2[n6] + 1;
                spring = new RatioSpring(constraints.getHeight(), 1, Math.abs(rectangle.height));
                springArray4[n] = springArray4[n] == null ? spring : Spring.max(springArray4[n], spring);
            }
        }
        Spring spring5 = Spring.constant(this.initialX);
        Spring spring6 = Spring.constant(this.initialY);
        n = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (nArray[n2] <= 0) continue;
            nArray[n2] = n++;
            springArray[n2] = spring5;
            spring5 = Spring.sum(spring5, Spring.sum(springArray3[n2], spring3));
        }
        n = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[n2] <= 0) continue;
            nArray2[n2] = n++;
            springArray2[n2] = spring6;
            spring6 = Spring.sum(spring6, Spring.sum(springArray4[n2], spring4));
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            jComponent = (JComponent)arrayList.get(n2);
            rectangle = (Rectangle)jComponent.getClientProperty(GRID);
            constraints = this.layout.getConstraints(jComponent);
            if (rectangle.width > 0) {
                spring2 = springArray3[rectangle.x];
                for (n = 1; n < rectangle.width; ++n) {
                    spring2 = Spring.sum(spring2, springArray3[rectangle.x + n]);
                }
                constraints.setWidth(spring2);
            }
            if (rectangle.height > 0) {
                spring = springArray4[rectangle.y];
                for (n = 1; n < rectangle.height; ++n) {
                    spring = Spring.sum(spring, springArray4[rectangle.y + n]);
                }
                constraints.setHeight(spring);
            }
            constraints.setX(springArray[rectangle.x]);
            constraints.setY(springArray2[rectangle.y]);
        }
        constraints = this.layout.getConstraints(this);
        if (bl) {
            spring5 = Spring.sum(springArray[n4 - 1], Spring.sum(spring3, springArray3[n4 - 1]));
            constraints.setConstraint("East", spring5);
        }
        if (bl2) {
            spring6 = Spring.sum(springArray2[n3 - 1], Spring.sum(spring4, springArray4[n3 - 1]));
            constraints.setConstraint("South", spring6);
        }
    }

    public static class ComponentWidthRatioSpring
    extends Spring {
        final Component c;
        final int nom;
        final int div;

        public ComponentWidthRatioSpring(Component component, int n, int n2) {
            this.c = component;
            this.nom = n;
            this.div = n2;
        }

        @Override
        public int getMinimumValue() {
            return this.c.getMinimumSize().width * this.nom / this.div;
        }

        @Override
        public int getPreferredValue() {
            return this.getValue();
        }

        @Override
        public int getMaximumValue() {
            return this.c.getMaximumSize().width * this.nom / this.div;
        }

        @Override
        public int getValue() {
            return this.c.getWidth() * this.nom / this.div;
        }

        @Override
        public void setValue(int n) {
        }
    }

    public static class ComponentHeightRatioSpring
    extends Spring {
        final Component c;
        final int nom;
        final int div;

        public ComponentHeightRatioSpring(Component component, int n, int n2) {
            this.c = component;
            this.nom = n;
            this.div = n2;
        }

        @Override
        public int getMinimumValue() {
            return this.c.getMinimumSize().height * this.nom / this.div;
        }

        @Override
        public int getPreferredValue() {
            return this.getValue();
        }

        @Override
        public int getMaximumValue() {
            return this.c.getMaximumSize().height * this.nom / this.div;
        }

        @Override
        public int getValue() {
            return this.c.getHeight() * this.nom / this.div;
        }

        @Override
        public void setValue(int n) {
        }
    }

    public static class RatioSpring
    extends Spring {
        final Spring s;
        final int nom;
        final int div;

        public RatioSpring(Spring spring, int n, int n2) {
            this.s = spring;
            this.nom = n;
            this.div = n2;
        }

        @Override
        public int getMinimumValue() {
            return this.s.getMinimumValue() * this.nom / this.div;
        }

        @Override
        public int getPreferredValue() {
            return this.s.getPreferredValue() * this.nom / this.div;
        }

        @Override
        public int getMaximumValue() {
            return this.s.getMaximumValue() * this.nom / this.div;
        }

        @Override
        public int getValue() {
            return this.s.getValue() * this.nom / this.div;
        }

        @Override
        public void setValue(int n) {
            this.s.setValue(n * this.div / this.nom);
        }
    }
}

