/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import de.sciss.io.InterleavedStreamFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AudioFileCacheInfo {
    private static final int VERSION = 1;
    private final int model;
    private final int numChannels;
    private final long lastModified;
    private final long numFrames;
    private final String name;

    private AudioFileCacheInfo(String string, long l, int n, int n2, long l2) {
        this.name = string;
        this.lastModified = l;
        this.model = n;
        this.numChannels = n2;
        this.numFrames = l2;
    }

    public AudioFileCacheInfo(InterleavedStreamFile interleavedStreamFile, int n, long l) throws IOException {
        this(interleavedStreamFile.getFile().getName(), interleavedStreamFile.getFile().lastModified(), n, interleavedStreamFile.getChannelNum(), l);
    }

    public static AudioFileCacheInfo decode(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            if (dataInputStream.readInt() != 1) {
                return null;
            }
            String string = dataInputStream.readUTF();
            long l = dataInputStream.readLong();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            long l2 = dataInputStream.readLong();
            return new AudioFileCacheInfo(string, l, n, n2, l2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getNumFrames() {
        return this.numFrames;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public boolean equals(Object object) {
        if (object instanceof AudioFileCacheInfo) {
            AudioFileCacheInfo audioFileCacheInfo = (AudioFileCacheInfo)object;
            return this.name.equals(audioFileCacheInfo.name) && this.lastModified == audioFileCacheInfo.lastModified && this.numChannels == audioFileCacheInfo.numChannels && this.numFrames == audioFileCacheInfo.numFrames && this.model == audioFileCacheInfo.model;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.model ^ -this.numChannels ^ (int)this.lastModified ^ (int)this.numFrames;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeInt(this.model);
        dataOutputStream.writeInt(this.numChannels);
        dataOutputStream.writeLong(this.numFrames);
        while ((dataOutputStream.size() & 3) != 0) {
            dataOutputStream.write(0);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

