/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import de.sciss.app.PreferenceNodeSync;
import de.sciss.gui.ComboBoxEditorBorder;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.PathField;
import de.sciss.gui.PrefCheckBox;
import de.sciss.gui.PrefComboBox;
import de.sciss.gui.PrefParamField;
import de.sciss.gui.SpringPanel;
import de.sciss.gui.StringItem;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.util.Param;
import de.sciss.util.ParamSpace;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class AudioFileFormatPane
extends SpringPanel
implements ItemListener,
PreferenceNodeSync {
    public static final int FORMAT = 1;
    public static final int ENCODING = 2;
    public static final int RATE = 4;
    public static final int GAIN = 16;
    public static final int NORMALIZE = 32;
    public static final int CHANNELS = 64;
    public static final int FORMAT_ENCODING_RATE = 7;
    public static final int NEW_FILE_FLAGS = 71;
    public static final int GAIN_NORMALIZE = 48;
    private static final int[] BITSPERSMP = new int[]{16, 24, 32, 32};
    private static final int[] ENCODINGS = new int[]{0, 0, 0, 1};
    private static final StringItem[] ENCODING_ITEMS = new StringItem[]{new StringItem("int16", "16-bit int"), new StringItem("int24", "24-bit int"), new StringItem("int32", "32-bit int"), new StringItem("float32", "32-bit float")};
    private static final StringItem[] RATE_ITEMS = new StringItem[]{new StringItem(new Param(32000.0, 83).toString(), "32 kHz"), new StringItem(new Param(44100.0, 83).toString(), "44.1 kHz"), new StringItem(new Param(48000.0, 83).toString(), "48 kHz"), new StringItem(new Param(88200.0, 83).toString(), "88.2 kHz"), new StringItem(new Param(96000.0, 83).toString(), "96 kHz")};
    private static final int DEFAULT_ENCODING = 1;
    private static final int DEFAULT_RATE = 1;
    private static final Param DEFAULT_GAIN = new Param(0.0, 8449);
    private static final boolean DEFAULT_NORMALIZE = true;
    private static final String KEY_FORMAT = "format";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_RATE = "rate";
    private static final String KEY_GAIN = "gain";
    private static final String KEY_NORMALIZE = "normalize";
    private static final String KEY_CHANNELS = "channels";
    private JLabel lbGainType;
    private PrefCheckBox ggNormalize = null;
    private PrefComboBox ggFormat = null;
    private PrefComboBox ggEncoding = null;
    private PrefParamField ggRate = null;
    private JComboBox ggRateCombo = null;
    private PrefParamField ggGain = null;
    private JToolBar pChan = null;
    private ButtonGroup chanGroup = null;
    private JToggleButton ggMono = null;
    private JToggleButton ggStereo = null;
    private JToggleButton ggMulti = null;
    private PrefParamField ggChanNum = null;
    private List ggPaths = null;
    private int flags = 0;
    private int gainTypeWidth = 0;
    private SpringPanel pEnc = null;
    private SpringPanel pGain = null;
    private Preferences prefs = null;

    public AudioFileFormatPane() {
    }

    public AudioFileFormatPane(int n) {
        this();
        this.setFlags(n);
    }

    public void setFlags(int n) {
        int n2;
        int n3 = n & ~this.flags;
        int n4 = this.flags & ~n;
        if ((n4 & 7) != 0) {
            if ((n4 & 1) != 0) {
                this.ggFormat.removeItemListener(this);
                if (this.prefs != null) {
                    this.ggFormat.setPreferences(null, null);
                }
                this.pEnc.remove(this.ggFormat);
                this.ggFormat = null;
            }
            if ((n4 & 2) != 0) {
                if (this.prefs != null) {
                    this.ggEncoding.setPreferences(null, null);
                }
                this.pEnc.remove(this.ggEncoding);
                this.ggEncoding = null;
            }
            if ((n4 & 4) != 0) {
                if (this.prefs != null) {
                    this.ggRate.setPreferences(null, null);
                }
                this.pEnc.remove(this.ggRateCombo);
                this.ggRateCombo = null;
                this.ggRate = null;
            }
            if (this.pEnc.getComponentCount() == 0) {
                this.remove(this.pEnc);
                this.pEnc = null;
            }
        }
        if ((n4 & 0x40) != 0) {
            this.ggMulti.removeItemListener(this);
            if (this.prefs != null) {
                this.ggChanNum.setPreferences(null, null);
            }
            this.remove(this.pChan);
            this.pChan.remove(this.ggMono);
            this.pChan.remove(this.ggStereo);
            this.pChan.remove(this.ggMulti);
            this.pChan.remove(this.ggChanNum);
            this.chanGroup.remove(this.ggMono);
            this.chanGroup.remove(this.ggStereo);
            this.chanGroup.remove(this.ggMulti);
            this.ggMono = null;
            this.ggStereo = null;
            this.ggMulti = null;
            this.ggChanNum = null;
            this.pChan = null;
            this.chanGroup = null;
        }
        if ((n4 & 0x30) != 0) {
            if ((n4 & 0x10) != 0) {
                if (this.prefs != null) {
                    this.ggGain.setPreferences(null, null);
                }
                this.pGain.remove(this.ggGain);
                this.ggGain = null;
            }
            if ((n4 & 0x20) != 0) {
                this.ggNormalize.removeItemListener(this);
                if (this.prefs != null) {
                    this.ggNormalize.setPreferences(null, null);
                }
                this.pGain.remove(this.ggNormalize);
                this.ggNormalize = null;
            }
            if (this.pGain.getComponentCount() == 0) {
                this.remove(this.pGain);
                this.pGain = null;
            }
        }
        if ((n3 & 7) != 0) {
            StringItem[] stringItemArray;
            if (this.pEnc == null) {
                this.pEnc = new SpringPanel(4, 2, 4, 2);
                this.gridAdd(this.pEnc, 0, 0, -1, 1);
            }
            if ((n3 & 1) != 0) {
                this.ggFormat = new PrefComboBox();
                stringItemArray = AudioFileDescr.getFormatItems();
                for (n2 = 0; n2 < stringItemArray.length; ++n2) {
                    this.ggFormat.addItem(stringItemArray[n2]);
                }
                this.ggFormat.setSelectedIndex(0);
                if (this.prefs != null) {
                    this.ggFormat.setPreferences(this.prefs, KEY_FORMAT);
                }
                this.ggFormat.addItemListener(this);
                this.pEnc.gridAdd(this.ggFormat, 0, 0);
            }
            if ((n3 & 2) != 0) {
                this.ggEncoding = new PrefComboBox();
                stringItemArray = ENCODING_ITEMS;
                for (n2 = 0; n2 < stringItemArray.length; ++n2) {
                    this.ggEncoding.addItem(stringItemArray[n2]);
                }
                this.ggEncoding.setSelectedIndex(1);
                if (this.prefs != null) {
                    this.ggEncoding.setPreferences(this.prefs, KEY_ENCODING);
                }
                this.pEnc.gridAdd(this.ggEncoding, 1, 0);
            }
            if ((n3 & 4) != 0) {
                this.ggRateCombo = new JComboBox();
                this.ggRate = new PrefParamField();
                this.ggRate.addSpace(ParamSpace.spcFreqHertz);
                stringItemArray = RATE_ITEMS;
                for (n2 = 0; n2 < stringItemArray.length; ++n2) {
                    this.ggRateCombo.addItem(stringItemArray[n2]);
                }
                this.ggRate.setBorder(new ComboBoxEditorBorder());
                this.ggRateCombo.setEditor(this.ggRate);
                this.ggRateCombo.setEditable(true);
                this.ggRateCombo.setSelectedIndex(1);
                if (this.prefs != null) {
                    this.ggRate.setPreferences(this.prefs, KEY_RATE);
                }
                this.pEnc.gridAdd(this.ggRateCombo, 2, 0);
            }
            this.pEnc.makeCompactGrid();
        }
        if ((n3 & 0x40) != 0) {
            this.pChan = new JToolBar();
            this.pChan.setFloatable(false);
            this.chanGroup = new ButtonGroup();
            this.ggMono = new JToggleButton(this.getResourceString("buttonMono"));
            this.ggMono.setSelected(true);
            this.chanGroup.add(this.ggMono);
            this.pChan.add(this.ggMono);
            this.ggStereo = new JToggleButton(this.getResourceString("buttonStereo"));
            this.chanGroup.add(this.ggStereo);
            this.pChan.add(this.ggStereo);
            this.ggChanNum = new PrefParamField();
            this.ggChanNum.addSpace(new ParamSpace(0.0, 65535.0, 1.0, 0, 0, 4.0, 0));
            this.ggChanNum.setEnabled(false);
            this.ggMulti = new JToggleButton(this.getResourceString("buttonMultichannel"));
            if (this.prefs != null) {
                this.ggChanNum.setPreferences(this.prefs, KEY_CHANNELS);
            }
            this.ggMulti.addItemListener(this);
            this.chanGroup.add(this.ggMulti);
            this.pChan.add(this.ggMulti);
            this.pChan.add(this.ggChanNum);
            this.gridAdd(this.pChan, 0, 1, -1, 1);
        }
        if ((n3 & 0x30) != 0) {
            if (this.pGain == null) {
                this.pGain = new SpringPanel(4, 2, 4, 2);
                this.gridAdd(this.pGain, 0, 2, -1, 1);
            }
            if ((n3 & 0x10) != 0) {
                this.ggGain = new PrefParamField();
                this.ggGain.addSpace(ParamSpace.spcAmpDecibels);
                this.ggGain.addSpace(ParamSpace.spcAmpPercentF);
                this.ggGain.setValue(DEFAULT_GAIN);
                this.pGain.gridAdd(this.ggGain, 0, 0);
                this.lbGainType = new JLabel();
                this.setGainLabel(true);
                n2 = this.lbGainType.getPreferredSize().width;
                this.setGainLabel(false);
                int n5 = this.lbGainType.getPreferredSize().width;
                this.gainTypeWidth = Math.max(n2, n5);
                GUIUtil.constrainWidth(this.lbGainType, this.gainTypeWidth);
                this.pGain.gridAdd(this.lbGainType, 1, 0);
            }
            if ((n3 & 0x20) != 0) {
                this.ggNormalize = new PrefCheckBox(this.getResourceString("labelNormalize"));
                this.ggNormalize.setSelected(true);
                this.ggNormalize.addItemListener(this);
                this.pGain.gridAdd(this.ggNormalize, 2, 0);
                if (this.ggGain != null) {
                    this.setGainLabel();
                }
            }
            this.pGain.makeCompactGrid();
        }
        if (n != this.flags) {
            this.flags = n;
            this.makeCompactGrid();
        }
    }

    public int getFlags() {
        return this.flags;
    }

    private String getResourceString(String string) {
        return IOUtil.getResourceString(string);
    }

    public void toDescr(AudioFileDescr audioFileDescr) {
        if (this.ggFormat != null) {
            audioFileDescr.type = this.ggFormat.getSelectedIndex();
        }
        if (this.ggEncoding != null) {
            audioFileDescr.bitsPerSample = BITSPERSMP[this.ggEncoding.getSelectedIndex()];
            audioFileDescr.sampleFormat = ENCODINGS[this.ggEncoding.getSelectedIndex()];
        }
        if (this.ggRate != null) {
            audioFileDescr.rate = this.ggRate.getValue().val;
        }
        if (this.chanGroup != null) {
            audioFileDescr.channels = this.ggMono.isSelected() ? 1 : (this.ggStereo.isSelected() ? 2 : (int)this.ggChanNum.getValue().val);
        }
    }

    public double getGain() {
        if (this.ggGain != null) {
            return this.ggGain.getTranslator().translate((Param)this.ggGain.getValue(), (ParamSpace)ParamSpace.spcAmpDecibels).val;
        }
        return 0.0;
    }

    public String getEncodingString() {
        return ((StringItem)this.ggEncoding.getSelectedItem()).getKey();
    }

    public String getFormatString() {
        return ((StringItem)this.ggFormat.getSelectedItem()).getKey();
    }

    public boolean getNormalized() {
        if (this.ggNormalize != null) {
            return this.ggNormalize.isSelected();
        }
        return false;
    }

    public void automaticFileSuffix(PathField pathField) {
        if (this.ggPaths == null) {
            this.ggPaths = new ArrayList();
        }
        this.ggPaths.add(pathField);
        this.updateFileSuffix();
    }

    public void fromDescr(AudioFileDescr audioFileDescr) {
        if (this.ggFormat != null) {
            this.ggFormat.setSelectedIndex(audioFileDescr.type);
        }
        if (this.ggEncoding != null) {
            for (int i = 0; i < ENCODINGS.length; ++i) {
                if (BITSPERSMP[i] != audioFileDescr.bitsPerSample || ENCODINGS[i] != audioFileDescr.sampleFormat) continue;
                this.ggEncoding.setSelectedIndex(i);
                break;
            }
        }
        if (this.ggRate != null) {
            this.ggRate.setValue(new Param(audioFileDescr.rate, ParamSpace.spcFreqHertz.unit));
        }
        if (this.chanGroup != null) {
            switch (audioFileDescr.channels) {
                case 1: {
                    this.chanGroup.setSelected(this.ggMono.getModel(), true);
                    this.ggChanNum.setEnabled(false);
                    break;
                }
                case 2: {
                    this.chanGroup.setSelected(this.ggStereo.getModel(), true);
                    this.ggChanNum.setEnabled(false);
                    break;
                }
                default: {
                    this.chanGroup.setSelected(this.ggMulti.getModel(), true);
                    this.ggChanNum.setEnabled(true);
                }
            }
        }
    }

    private void setGainLabel() {
        this.setGainLabel(this.ggNormalize != null && this.ggNormalize.isSelected());
        GUIUtil.constrainWidth(this.lbGainType, this.gainTypeWidth);
    }

    private void setGainLabel(boolean bl) {
        this.lbGainType.setText(this.getResourceString(bl ? "labelPeak" : "labelGain"));
    }

    private void updateFileSuffix() {
        if (this.ggFormat == null) {
            return;
        }
        String string = AudioFileDescr.getFormatSuffix(this.ggFormat.getSelectedIndex());
        if (this.ggPaths != null) {
            for (int i = 0; i < this.ggPaths.size(); ++i) {
                PathField pathField = (PathField)this.ggPaths.get(i);
                File file = pathField.getPath();
                File file2 = IOUtil.setFileSuffix(file, string);
                if (file2 == file) continue;
                pathField.setPath(file2);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.ggNormalize) {
            this.setGainLabel();
        } else if (itemEvent.getSource() == this.ggFormat) {
            this.updateFileSuffix();
        } else if (itemEvent.getSource() == this.ggMulti) {
            boolean bl = this.ggMulti.isSelected();
            this.ggChanNum.setEnabled(bl);
            if (bl) {
                this.ggChanNum.requestFocusInWindow();
            }
        }
    }

    @Override
    public void setPreferences(Preferences preferences) {
        if (this.ggFormat != null) {
            this.ggFormat.setPreferences(preferences, KEY_FORMAT);
        }
        if (this.ggEncoding != null) {
            this.ggEncoding.setPreferences(preferences, KEY_ENCODING);
        }
        if (this.ggRate != null) {
            this.ggRate.setPreferences(preferences, KEY_RATE);
        }
        if (this.ggGain != null) {
            this.ggGain.setPreferences(preferences, KEY_GAIN);
        }
        if (this.ggNormalize != null) {
            this.ggNormalize.setPreferences(preferences, KEY_NORMALIZE);
        }
        if (this.ggChanNum != null) {
            this.ggChanNum.setPreferences(preferences, KEY_CHANNELS);
            if (preferences != null) {
                int n = preferences.getInt(KEY_CHANNELS, 1);
                switch (n) {
                    case 1: {
                        this.chanGroup.setSelected(this.ggMono.getModel(), true);
                        this.ggChanNum.setEnabled(false);
                        break;
                    }
                    case 2: {
                        this.chanGroup.setSelected(this.ggStereo.getModel(), true);
                        this.ggChanNum.setEnabled(false);
                        break;
                    }
                    default: {
                        this.chanGroup.setSelected(this.ggMulti.getModel(), true);
                        this.ggChanNum.setEnabled(true);
                    }
                }
            }
        }
    }
}

