/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

public class IOUtil {
    public static final String KEY_TEMPDIR = "tmpdir";
    private static final double VERSION = 0.32;
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("IOUtilStrings");
    private static final Preferences prefs = Preferences.userNodeForPackage(IOUtil.class);

    private IOUtil() {
    }

    public static final Preferences getUserPrefs() {
        return prefs;
    }

    public static final double getVersion() {
        return 0.32;
    }

    public static final String getResourceString(String string) {
        try {
            return resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[Missing Resource: " + string + "]";
        }
    }

    public static IOException map(Exception exception) {
        return new IOException(exception.getClass().getName() + " : " + exception.getLocalizedMessage());
    }

    public static String abbreviate(String string, int n) {
        String string2;
        if (string.length() <= n) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (File file = new File(string); file != null && (string2 = file.getName()) != null; file = file.getParentFile()) {
            arrayList.add(0, string2);
        }
        if (arrayList.isEmpty()) {
            return string;
        }
        int n2 = arrayList.size() << 1;
        string2 = (String)arrayList.remove(arrayList.size() - 1);
        stringBuffer2.insert(0, string2);
        n2 += string2.length();
        if (!arrayList.isEmpty()) {
            string2 = (String)arrayList.remove(0);
            stringBuffer.append(string2);
            stringBuffer.append(File.separator);
            n2 += string2.length() - 1;
        }
        if (!arrayList.isEmpty()) {
            string2 = (String)arrayList.remove(0);
            if (string2.equals("Volumes")) {
                stringBuffer.append('\u2026');
                stringBuffer.append(File.separator);
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(File.separator);
                n2 += string2.length() - 1;
            }
        }
        boolean bl = true;
        while (!arrayList.isEmpty() && n2 <= n) {
            if (bl) {
                string2 = (String)arrayList.remove(arrayList.size() - 1);
                stringBuffer2.insert(0, File.separator);
                stringBuffer2.insert(0, string2);
            } else {
                string2 = (String)arrayList.remove(0);
                stringBuffer.append(string2);
                stringBuffer.append(File.separator);
            }
            n2 += string2.length() - 1;
            bl = !bl;
        }
        while (!arrayList.isEmpty()) {
            arrayList.remove(0);
            stringBuffer.append('\u2026');
            stringBuffer.append(File.separator);
        }
        return stringBuffer.append(stringBuffer2).toString();
    }

    public static void createEmptyDirectory(File file) throws IOException {
        IOUtil.deleteAll(file);
        if (!file.mkdirs()) {
            throw new IOException(file.getAbsolutePath() + " : " + IOUtil.getResourceString("errMakeDir"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEmptyFile(File file) throws IOException {
        file.delete();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            randomAccessFile.setLength(0L);
        }
        finally {
            randomAccessFile.close();
        }
    }

    public static File createTempFile() throws IOException {
        return IOUtil.createTempFile("sciss", null);
    }

    public static File createTempFile(String string, String string2) throws IOException {
        String string3 = IOUtil.getUserPrefs().get(KEY_TEMPDIR, null);
        File file = File.createTempFile(string, string2, string3 == null ? null : new File(string3));
        file.deleteOnExit();
        return file;
    }

    public static void deleteAll(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                IOUtil.deleteAll(fileArray[i]);
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException(file.getAbsolutePath() + " : " + IOUtil.getResourceString("errDeleteFile"));
        }
    }

    public static File setFileSuffix(File file, String string) {
        if (file == null) {
            return null;
        }
        String string2 = file.getName();
        File file2 = file.getParentFile();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            if (string == null) {
                return file;
            }
            return new File(file2, string2 + (string.startsWith(".") ? string : '.' + string));
        }
        if (string == null) {
            return new File(file2, string2.substring(0, n));
        }
        return new File(file2, string2.substring(0, string.startsWith(".") ? n : n + 1) + string);
    }

    public static File nonExistentFileVariant(File file, int n, String string, String string2) {
        File file2;
        if (!file.exists()) {
            return file;
        }
        File file3 = file.getParentFile();
        String string3 = file.getName();
        int n2 = 1;
        if (n == -1 && (n = string3.lastIndexOf(46)) == -1) {
            n = string3.length();
        }
        StringBuffer stringBuffer = new StringBuffer(string3.substring(0, n));
        do {
            stringBuffer.delete(n, stringBuffer.length());
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(n2++);
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string3.substring(n));
        } while ((file2 = new File(file3, stringBuffer.toString())).exists());
        return file2;
    }
}

