/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

public class NumberSpace {
    public final double min;
    public final double max;
    public final double quant;
    public final double reset;
    public final int minFracDigits;
    public final int maxFracDigits;
    public static NumberSpace genericDoubleSpace = new NumberSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
    public static NumberSpace genericIntSpace = new NumberSpace(-2.147483648E9, 2.147483647E9, 1.0);
    private final boolean isInteger;

    public NumberSpace(double d, double d2, double d3, int n, int n2, double d4) {
        this.min = d;
        this.max = d2;
        this.quant = d3;
        this.reset = d4;
        this.minFracDigits = n;
        this.maxFracDigits = n2;
        this.isInteger = d3 > 0.0 && d3 % 1.0 == 0.0;
    }

    public NumberSpace(double d, double d2, double d3, int n, int n2) {
        this(d, d2, d3, n, n2, NumberSpace.fitValue(0.0, d, d2, d3));
    }

    public NumberSpace(double d, double d2, double d3) {
        this(d, d2, d3, Math.max(1, NumberSpace.fracDigitsFromQuant(d3)), Math.min(2, NumberSpace.fracDigitsFromQuant(d3)));
    }

    public static int fracDigitsFromQuant(double d) {
        if (d > 0.0) {
            int n = 0;
            while (d % 1.0 != 0.0) {
                ++n;
                d *= 10.0;
            }
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public static NumberSpace createIntSpace(int n, int n2) {
        return new NumberSpace(n, n2, 1.0);
    }

    public double fitValue(double d) {
        if (this.quant > 0.0) {
            d = (double)Math.round(d / this.quant) * this.quant;
        }
        return Math.min(this.max, Math.max(this.min, d));
    }

    public static double fitValue(double d, double d2, double d3, double d4) {
        if (d4 > 0.0) {
            d = (double)Math.round(d / d4) * d4;
        }
        return Math.min(d3, Math.max(d2, d));
    }
}

