/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

import de.sciss.util.NumberSpace;
import de.sciss.util.Param;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ParamSpace
extends NumberSpace {
    public static final int NONE = 0;
    public static final int AMP = 1;
    public static final int TIME = 2;
    public static final int FREQ = 3;
    public static final int PHASE = 4;
    public static final int SPACE = 5;
    private static final int DIM_SHIFT = 0;
    public static final int DIM_MASK = 15;
    private static final String[] DIM_NAMES = new String[]{"none", "amp", "time", "freq", "phase", "space"};
    public static final int VOLTS = 16;
    public static final int SECS = 32;
    public static final int SMPS = 48;
    public static final int BEATS = 64;
    public static final int HERTZ = 80;
    public static final int PITCH = 96;
    public static final int DEGREES = 112;
    public static final int METERS = 128;
    public static final int PIXELS = 144;
    private static final int UNIT_SHIFT = 4;
    public static final int UNIT_MASK = 240;
    private static final String[] UNIT_NAMES = new String[]{"none", "volts", "secs", "smps", "beats", "hertz", "pitch", "degrees", "meters", "pixels"};
    public static final int ABS = 0;
    public static final int REL = 256;
    public static final int OFF = 512;
    private static final int REL_SHIFT = 8;
    public static final int REL_MASK = 3840;
    private static final String[] REL_NAMES = new String[]{"abs", "rel", "off"};
    public static final int PERCENT = 4096;
    public static final int DECIBEL = 8192;
    public static final int MILLI = 12288;
    public static final int CENTI = 16384;
    public static final int KILO = 20480;
    private static final int SCALE_SHIFT = 12;
    public static final int SCALE_MASK = 61440;
    private static final String[] SCALE_NAMES = new String[]{"none", "percent", "decibel", "milli", "centi", "kilo"};
    public static final int CRUCIAL_MASK = 65535;
    public static final int BARSBEATS = 65536;
    public static final int HHMMSS = 131072;
    public static final int MIDINOTE = 196608;
    private static final int SPECIAL_SHIFT = 16;
    public static final int SPECIAL_MASK = 983040;
    private static final String[] SPECIAL_NAMES = new String[]{"none", "barsbeats", "hhmmss", "midinote"};
    public static final int[] DEFAULT_UNIT = new int[]{0, 16, 32, 80, 112, 128};
    public final double inc;
    public final Object warp;
    public final int unit;
    public static final ParamSpace spcTimeHHMMSS = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 0.0, 1, 3, 0.0, 131106);
    public static final ParamSpace spcTimeSmps = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 1.0, 0, 0, 0.0, 50);
    public static final ParamSpace spcTimeSmpsD = new ParamSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, 0, 0, 0.0, 562);
    public static final ParamSpace spcTimeMillis = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 0.0, 0, 2, 0.0, 12322);
    public static final ParamSpace spcTimeMillisD = new ParamSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0, 2, 0.0, 12834);
    public static final ParamSpace spcTimePercentF = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 0.0, 0, 3, 100.0, 4354, 0.1);
    public static final ParamSpace spcTimePercentR = new ParamSpace(0.0, 100.0, 0.0, 0, 3, 100.0, 4354, 0.1);
    public static final ParamSpace spcTimePercentD = new ParamSpace(-100.0, Double.POSITIVE_INFINITY, 0.0, 0, 3, 0.0, 4610, 0.1);
    public static final ParamSpace spcFreqHertz = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 0.0, 0, 3, 0.0, 83);
    public static final ParamSpace spcAmpRel = new ParamSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0, 2, 1.0, 257);
    public static final ParamSpace spcAmpDecibels = new ParamSpace(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0, 2, 0.0, 8449, 0.1);
    public static final ParamSpace spcAmpPercentF = new ParamSpace(0.0, Double.POSITIVE_INFINITY, 0.0, 0, 3, 100.0, 4353, 0.1);

    public ParamSpace(double d, double d2, double d3, int n, int n2, double d4, int n3, double d5, Object object) {
        super(d, d2, d3, Math.max(n, NumberSpace.fracDigitsFromQuant(d5)), n2, d4);
        this.inc = d5;
        this.warp = object;
        this.unit = n3;
    }

    public ParamSpace(double d, double d2, double d3, int n, int n2, double d4, int n3, double d5) {
        this(d, d2, d3, n, n2, d4, n3, d5, null);
    }

    public ParamSpace(double d, double d2, double d3, int n, int n2, double d4, int n3) {
        this(d, d2, d3, n, n2, d4, n3, Math.max(Math.pow(10.0, -n), d3));
    }

    public ParamSpace(double d, double d2, double d3, int n, int n2, double d4) {
        this(d, d2, d3, n, n2, d4, 0);
    }

    public ParamSpace reshape(double d, double d2, double d3) {
        return new ParamSpace(d, d2, this.quant, this.minFracDigits, this.maxFracDigits, d3, this.unit, this.inc);
    }

    public static String unitToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = (n & 0xF) >> 0;
            stringBuffer.append(DIM_NAMES[n2]);
            n2 = (n & 0xF0) >> 4;
            stringBuffer.append('_');
            stringBuffer.append(UNIT_NAMES[n2]);
            n2 = (n & 0xF00) >> 8;
            stringBuffer.append('_');
            stringBuffer.append(REL_NAMES[n2]);
            n2 = (n & 0xF000) >> 12;
            int n3 = (n & 0xF0000) >> 16;
            if (n2 > 0 || n3 > 0) {
                stringBuffer.append('_');
                stringBuffer.append(SCALE_NAMES[n2]);
                if (n3 > 0) {
                    stringBuffer.append('_');
                    stringBuffer.append(SPECIAL_NAMES[n3]);
                }
            }
            return stringBuffer.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public static int stringToUnit(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        int n = 0;
        try {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < DIM_NAMES.length; ++i) {
                if (!DIM_NAMES[i].equals(string2)) continue;
                n |= i << 0;
                string2 = stringTokenizer.nextToken();
                for (int j = 0; j < UNIT_NAMES.length; ++j) {
                    if (!UNIT_NAMES[j].equals(string2)) continue;
                    n |= j << 4;
                    string2 = stringTokenizer.nextToken();
                    for (int k = 0; k < REL_NAMES.length; ++k) {
                        if (!REL_NAMES[k].equals(string2)) continue;
                        n |= k << 8;
                        if (!stringTokenizer.hasMoreTokens()) {
                            return n;
                        }
                        string2 = stringTokenizer.nextToken();
                        for (int i2 = 0; i2 < SCALE_NAMES.length; ++i2) {
                            if (!SCALE_NAMES[i2].equals(string2)) continue;
                            n |= i2 << 12;
                            if (!stringTokenizer.hasMoreTokens()) {
                                return n;
                            }
                            string2 = stringTokenizer.nextToken();
                            for (int i3 = 0; i3 < SPECIAL_NAMES.length; ++i3) {
                                if (!SPECIAL_NAMES[i3].equals(string2)) continue;
                                return n |= i3 << 16;
                            }
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        throw new NumberFormatException(string);
    }

    public static interface Translator {
        public Param translate(Param var1, ParamSpace var2);

        public void setCoefficient(int var1, int var2, double var3);
    }
}

