# Dr Murke

<BLOCKQUOTE>Collects chunks of  an input file according to a weighting function provided by another (control) file. When then control file is some kind of amplitude or loudness measurement of the input file, this can be used to keep only the loud or only the silent parts of a sound.
</BLOCKQUOTE>

Input and control file do not need to have the same length. In that case, indices in the control file are translated to indices in the input file by applying a constant (stretch) factor. Typically the control file is an output from the _Serial Killer_ module.

The module distinguishes between an up-track and a down-track, that is a stream of sound where the corresponding control signal stays above a given threshold or below a given threshold. The "Mode" setting determines whether the up-track or the low-track is written. If the control-file is an amplitude measurement, keeping the down chunks means keeping the more silent parts of the input sound, and keeping the up chunks means keeping the rather loud parts.

The module initially starts at the "off" track, that is the track that is not written. For instance, if the up-chunks are kept (the loud parts), the parameters are initiated at a down-chunk position: For a loud part to be detected, the control signal must for a minimum period given by the "Min. Up Duration" stay above the "Up Thresh" threshold. When this happens, the input signal is faded in using the "Attack" fade-time. The module is then on the up-track and stays there until for at least the duration given by "Min. Down Duration" the control signal stays below "Down Thresh". In that case, a fade-out is applied using the time parameter "Release". The spacing between "Up Thresh" and "Down Thresh" form a kind of hysteresis. (You can also think of the module as a kind of Noise-Gate).

The "write-head" of the output file is stopped at the moment a fade-out (release) begins, and restarted at the moment a fade-in (attack) occurs. Note that the attack phase is occurs <EM>before</EM> the position at which the control-signal crosses from off-track to on-track. For example, if the last fade-out would finish at 3 seconds in the output file and an on-track attack is detected at input position 6 seconds, assuming a attack time of 100 ms, this means that the write-head resumes at 2.9 seconds plus spacing (see below) and begins to copy the input signal from 5.9 seconds into the input file. This is so that when a loud part is detected, the actual attack is not lost or blurred.

For each attach the write-head between successive fade-out starting positions and fade-in ending positions is advanced by a given spacing function. This can be either a constant ("Fixed Spacing") or the special setting "Original Spacing". In the latter mode, all chunks from the input file are written exactly so that write-head and read-head match, so you end up with a file that has the same duration as the input file, and all kept sounds occur exactly at their original positions, with off-track chunks being "wiped out".
