/*
 * Decompiled with CFR 0.152.
 */
package com.petersalomonsen.jjack.javasound;

public class BlockingByteFIFO {
    byte[] buffer;
    long bufferPosWrite = 0L;
    long bufferPosRead = 0L;
    boolean blocking = false;

    public BlockingByteFIFO(int size) {
        this.buffer = new byte[size];
    }

    private synchronized void unblock() {
        this.notify();
        this.blocking = false;
    }

    private synchronized void block() {
        if (!this.blocking) {
            this.blocking = true;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int availableRead() {
        return (int)(this.bufferPosWrite - this.bufferPosRead);
    }

    public int availableWrite() {
        return this.buffer.length - this.availableRead();
    }

    private int readLenOrAvailable(byte[] b, int off, int len) {
        int availableRead = this.availableRead();
        if (availableRead < len) {
            len = availableRead;
        }
        if (len > 0) {
            int localBufferPos = (int)(this.bufferPosRead % (long)this.buffer.length);
            if (localBufferPos + len > this.buffer.length) {
                System.arraycopy(this.buffer, localBufferPos, b, off, this.buffer.length - localBufferPos);
                System.arraycopy(this.buffer, 0, b, off + (this.buffer.length - localBufferPos), len - (this.buffer.length - localBufferPos));
            } else {
                System.arraycopy(this.buffer, localBufferPos, b, off, len);
            }
            this.bufferPosRead += (long)len;
            this.unblock();
        }
        return len;
    }

    private int writeLenOrAvailable(byte[] b, int off, int len) {
        int availableWrite = this.availableWrite();
        if (availableWrite < len) {
            len = availableWrite;
        }
        if (len > 0) {
            int localBufferPos = (int)(this.bufferPosWrite % (long)this.buffer.length);
            if (localBufferPos + len > this.buffer.length) {
                System.arraycopy(b, off, this.buffer, localBufferPos, this.buffer.length - localBufferPos);
                System.arraycopy(b, off + (this.buffer.length - localBufferPos), this.buffer, 0, len - (this.buffer.length - localBufferPos));
            } else {
                System.arraycopy(b, off, this.buffer, localBufferPos, len);
            }
            this.bufferPosWrite += (long)len;
            this.unblock();
        }
        return len;
    }

    public int read(byte[] b, int off, int len) {
        int readCount = 0;
        while (readCount < len) {
            if ((readCount += this.readLenOrAvailable(b, off + readCount, len - readCount)) >= len) continue;
            this.block();
        }
        return len;
    }

    public int write(byte[] b, int off, int len) {
        int writeCount = 0;
        while (writeCount < len) {
            if ((writeCount += this.writeLenOrAvailable(b, off + writeCount, len - writeCount)) >= len) continue;
            this.block();
        }
        return len;
    }

    public long getBufferPosRead() {
        return this.bufferPosRead;
    }

    public long getBufferPosWrite() {
        return this.bufferPosWrite;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void flush() {
        this.bufferPosRead = this.bufferPosWrite;
    }
}

