/*
 * Decompiled with CFR 0.152.
 */
package com.petersalomonsen.jjack.javasound;

public final class ByteIntConverter {
    final int bytesPerSample;
    final boolean bigEndian;
    final boolean signed;
    final int msbIndex;

    public ByteIntConverter(int bytesPerSample, boolean bigEndian, boolean signed) {
        this.bytesPerSample = bytesPerSample;
        this.bigEndian = bigEndian;
        this.signed = signed;
        this.msbIndex = bigEndian ? 0 : bytesPerSample - 1;
    }

    public final int readInt(byte[] bytes, int index) {
        int val = 0;
        for (int n = 0; n < this.bytesPerSample; ++n) {
            val |= (bytes[index++] & (n == this.msbIndex && this.signed ? -1 : 255)) << (this.bigEndian ? this.bytesPerSample - 1 - n : n) * 8;
        }
        if (this.signed) {
            return val;
        }
        return val + (1 << this.bytesPerSample * 8 - 1);
    }

    public final void writeInt(byte[] bytes, int index, int value) {
        for (int n = 0; n < this.bytesPerSample; ++n) {
            int shift = (this.bigEndian ? this.bytesPerSample - 1 - n : n) * 8;
            bytes[index++] = (byte)((value & 255 << shift) >> shift);
        }
    }
}

