/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.framework.jjack;

import de.gulden.framework.jjack.JJackAudioConsumer;
import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessListener;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackAudioProcessorMonitorable;
import de.gulden.framework.jjack.JJackAudioProducer;
import de.gulden.framework.jjack.JJackConstants;
import de.gulden.framework.jjack.JJackSystem;
import java.awt.BorderLayout;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class JJackMonitor
extends JPanel
implements JJackAudioProcessorMonitorable,
JJackAudioConsumer,
JJackAudioProcessListener,
JJackConstants {
    protected String name;
    protected JComponent gui;
    protected boolean active;
    protected JJackAudioProducer chained = null;
    protected ArrayList monitors = new ArrayList();
    protected ArrayList listeners = new ArrayList();

    public JJackMonitor() {
        this(false);
    }

    public JJackMonitor(String name) {
        this(name, false);
    }

    public JJackMonitor(boolean active) {
        this((String)null, active);
    }

    public JJackMonitor(String name, boolean active) {
        int p;
        this.active = active;
        if (name == null && (p = (name = this.getClass().getName()).lastIndexOf(46)) != -1) {
            name = name.substring(p + 1);
        }
        this.setName(name);
        this.initUI();
        this.addAudioProcessListener(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSampleRate() {
        return JJackSystem.getSampleRate();
    }

    public void setChained(JJackAudioProducer p) {
        this.chained = p;
    }

    public void removeChained(JJackAudioProducer p) {
        if (p == this.getChained()) {
            this.setChained(null);
        }
    }

    public JJackAudioProducer getChained() {
        return this.chained;
    }

    public void addMonitor(JJackAudioConsumer p) {
        if (!this.monitors.contains(p)) {
            this.monitors.add(p);
        }
    }

    public void removeMonitor(JJackAudioConsumer p) {
        this.monitors.remove(p);
    }

    public Collection getMonitors() {
        return Collections.unmodifiableCollection(this.monitors);
    }

    public void addAudioProcessListener(JJackAudioProcessListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeAudioProcessListener(JJackAudioProcessListener l) {
        this.listeners.remove(l);
    }

    public Collection getAudioProcessListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public void beforeProcess(JJackAudioEvent e) {
        Collection monitors = this.getMonitors();
        JJackAudioProducer chained = this.getChained();
        if (chained != null && this.active) {
            FloatBuffer[] outs = e.getOutputs();
            FloatBuffer[] outsBack = new FloatBuffer[outs.length];
            for (int i = 0; i < outs.length; ++i) {
                outsBack[i] = outs[i];
                outs[i] = FloatBuffer.allocate(outs[i].capacity());
            }
            e.stack.push(outsBack);
        }
    }

    public void afterProcess(JJackAudioEvent e) {
        FloatBuffer[] outs;
        JJackAudioProducer chained = this.getChained();
        Collection monitors = this.getMonitors();
        if (!monitors.isEmpty()) {
            FloatBuffer[] newIns;
            outs = e.getOutputs();
            if (this.active) {
                newIns = new FloatBuffer[outs.length];
                System.arraycopy(outs, 0, newIns, 0, outs.length);
            } else {
                FloatBuffer[] ins = e.getInputs();
                newIns = new FloatBuffer[ins.length];
                System.arraycopy(ins, 0, newIns, 0, ins.length);
            }
            FloatBuffer[] newOuts = new FloatBuffer[outs.length];
            int cap = outs[0].capacity();
            for (int i = 0; i < newOuts.length; ++i) {
                newOuts[i] = FloatBuffer.allocate(cap);
            }
            Iterator it = monitors.iterator();
            while (it.hasNext()) {
                int i;
                JJackAudioProcessor p = (JJackAudioProcessor)it.next();
                for (i = 0; i < newIns.length; ++i) {
                    newIns[i].rewind();
                }
                for (i = 0; i < newOuts.length; ++i) {
                    newOuts[i].rewind();
                }
                JJackAudioEvent me = new JJackAudioEvent(e.getTimestamp(), this, newIns, newOuts);
                JJackSystem.process(p, me);
            }
        }
        if (chained != null) {
            if (this.active) {
                FloatBuffer[] ins = e.getInputs();
                outs = e.getOutputs();
                FloatBuffer[] outsBack = (FloatBuffer[])e.stack.pop();
                int ports = e.countChannels();
                System.arraycopy(outs, 0, ins, 0, ports);
                System.arraycopy(outsBack, 0, outs, 0, ports);
            }
            JJackSystem.process(chained, e);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.gui != null) {
            this.gui.updateUI();
            this.gui.validate();
        }
    }

    public String getInfo() {
        return null;
    }

    public abstract void process(JJackAudioEvent var1);

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.gui = this.createUI();
        if (this.gui != null) {
            this.add(this.gui);
        } else {
            this.add(new JLabel(this.getName()));
        }
    }

    protected JComponent createUI() {
        return null;
    }

    static void exc(Exception e) {
        System.out.println(e.getClass().getName() + ": " + e.getMessage());
    }
}

