/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.framework.jjack;

import [Ljava.lang.String;;
import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessListener;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackAudioProcessorMonitorable;
import de.gulden.framework.jjack.JJackConstants;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackMonitor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Iterator;

public class JJackSystem
implements JJackConstants {
    public static final String VERSION = "0.2";
    public static final boolean DEBUG = false;
    private static final String PROPERTY_CLIENT_NAME = "jjack.client.name";
    private static final String DEFAULT_CLIENT_NAME = "JJack";
    private static final String PROPERTY_VERBOSE = "jjack.verbose";
    private static final String DEFAULT_VERBOSE = "false";
    private static final String PROPERTY_PORTS = "jjack.ports";
    private static final String SUFFIX_INPUT = ".in";
    private static final String SUFFIX_OUTPUT = ".out";
    private static final String DEFAULT_PORTS = "2";
    private static final String SUFFIX_AUTOCONNECT = ".autoconnect";
    private static final String DEFAULT_AUTOCONNECT = "false";
    private static String clientName;
    private static int portsInput;
    private static int portsOutput;
    private static boolean portsInputAutoconnect;
    private static boolean portsOutputAutoconnect;
    private static JJackAudioProcessor client;
    private static JJackException initError;
    private static boolean initialized;
    private static boolean running;
    private static boolean verbose;
    private static Object lock;
    private static long infPointer;

    private JJackSystem() {
    }

    public static native int getSampleRate();

    public static void setProcessor(JJackAudioProcessor cl) {
        client = cl;
    }

    public static JJackAudioProcessor getProcessor() {
        return client;
    }

    public static void main(String[] args) throws Throwable {
        String cn;
        if (initError != null) {
            System.out.println("Error initializing JJack client:");
            throw initError;
        }
        if (args.length == 0) {
            JJackSystem.usage();
        }
        if ((cn = args[0]).equalsIgnoreCase("-help") || cn.equalsIgnoreCase("--help") || cn.equals("/?") || cn.equals("-?")) {
            JJackSystem.usage();
        }
        Class<?> cl = null;
        try {
            cl = Class.forName(cn);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Error loading class '" + cn + "': " + cnfe.getMessage());
            JJackSystem.usage();
        }
        Method method = null;
        try {
            method = cl.getMethod("main", String;.class);
        }
        catch (Exception e) {
            System.out.println("Error: '" + cn + "' has no main()-method: " + e.getMessage());
            System.exit(1);
        }
        String[] wrappedArgs = new String[args.length - 1];
        for (int i = 0; i < wrappedArgs.length; ++i) {
            wrappedArgs[i] = args[i + 1];
        }
        try {
            method.invoke(null, new Object[]{wrappedArgs});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        catch (Exception ex) {
            System.out.println("Error running main() method of '" + cn + "': " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void shutdown() throws JJackException {
        JJackSystem.stop();
    }

    public static String getJackClientName() {
        return clientName;
    }

    public static int countPorts(int inout) {
        switch (inout) {
            case 0: {
                return portsInput;
            }
            case 1: {
                return portsOutput;
            }
        }
        return 0;
    }

    public static boolean verbose() {
        return verbose;
    }

    public static void log(Object src, String msg) {
        if (JJackSystem.verbose()) {
            String s = src instanceof JJackMonitor ? ((JJackMonitor)src).getName() + " [" + src.getClass().getName() + "]" : src.getClass().getName();
            System.out.println(s + ": " + msg);
        }
    }

    public static int calculateSampleCount(int milliseconds) {
        int sr = JJackSystem.getSampleRate();
        int count = sr * milliseconds / 1000;
        return count;
    }

    public static void process(JJackAudioProcessor p, JJackAudioEvent e) {
        JJackAudioProcessListener l;
        Iterator it;
        boolean monitorable = p instanceof JJackAudioProcessorMonitorable;
        if (monitorable) {
            it = ((JJackAudioProcessorMonitorable)((Object)p)).getAudioProcessListeners().iterator();
            while (it.hasNext()) {
                l = (JJackAudioProcessListener)it.next();
                l.beforeProcess(e);
            }
        }
        p.process(e);
        if (monitorable) {
            it = ((JJackAudioProcessorMonitorable)((Object)p)).getAudioProcessListeners().iterator();
            while (it.hasNext()) {
                l = (JJackAudioProcessListener)it.next();
                l.afterProcess(e);
            }
        }
    }

    public static String getInfo() {
        return "JJack version 0.2\n\nClient name: " + JJackSystem.getJackClientName() + "\n" + "Sample rate: " + JJackSystem.getSampleRate() + "\n" + "# Input ports: " + JJackSystem.countPorts(0) + "\n" + "# Output ports: " + JJackSystem.countPorts(1) + "\n" + "";
    }

    private static void usage() {
        System.out.println("usage: java ... (-Djjack.client.name=Name) JJack <wrapped-class-with-main-method> <arg0 of wrapped-class> <arg1 of wrapped-class> ...");
        System.exit(1);
    }

    private static native void nativeInit() throws JJackException;

    private static native void nativeStart() throws JJackException;

    private static native void nativeDestroy() throws JJackException;

    private static void init() throws JJackException {
        JJackSystem.nativeInit();
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() throws JJackException {
        boolean wasRunning;
        if (!initialized) {
            JJackSystem.init();
        }
        Object object = lock;
        synchronized (object) {
            wasRunning = running;
            running = true;
        }
        if (!wasRunning) {
            JJackSystem.nativeStart();
        }
    }

    private static void stop() {
    }

    private static void processBytes(ByteBuffer[] in, ByteBuffer[] out) {
        JJackAudioProcessor cl = client;
        if (cl != null) {
            FloatBuffer[] inAsFloat = new FloatBuffer[in.length];
            for (int i = 0; i < in.length; ++i) {
                inAsFloat[i] = in[i].order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            }
            FloatBuffer[] outAsFloat = new FloatBuffer[out.length];
            for (int i = 0; i < out.length; ++i) {
                outAsFloat[i] = out[i].order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            }
            JJackAudioEvent e = new JJackAudioEvent(System.currentTimeMillis(), cl, inAsFloat, outAsFloat);
            JJackSystem.process(cl, e);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        client = null;
        initError = null;
        lock = new Object();
        try {
            System.loadLibrary("jjack");
        }
        catch (Throwable e) {
            File file = new File("lib/" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/libjjack.so");
            String libJJackFileName = file.getAbsolutePath();
            System.load(libJJackFileName);
        }
        clientName = System.getProperty(PROPERTY_CLIENT_NAME, DEFAULT_CLIENT_NAME);
        String s = System.getProperty(PROPERTY_VERBOSE, "false");
        verbose = Boolean.valueOf(s);
        s = System.getProperty("jjack.ports.in", System.getProperty(PROPERTY_PORTS, DEFAULT_PORTS));
        portsInput = Integer.valueOf(s);
        s = System.getProperty("jjack.ports.out", System.getProperty(PROPERTY_PORTS, DEFAULT_PORTS));
        portsOutput = Integer.valueOf(s);
        s = System.getProperty("jjack.ports.in.autoconnect", System.getProperty("jjack.ports.autoconnect", "false"));
        portsInputAutoconnect = Boolean.valueOf(s);
        s = System.getProperty("jjack.ports.out.autoconnect", System.getProperty("jjack.ports.autoconnect", "false"));
        portsOutputAutoconnect = Boolean.valueOf(s);
        initialized = false;
        running = false;
        try {
            JJackSystem.init();
            JJackSystem.start();
        }
        catch (JJackException jje) {
            initError = jje;
        }
    }
}

