/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;

public class JARSoundbankReader
extends SoundbankReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZIP(URL uRL) {
        boolean bl = false;
        try {
            InputStream inputStream = uRL.openStream();
            try {
                byte[] byArray = new byte[4];
                boolean bl2 = bl = inputStream.read(byArray) == 4;
                if (bl) {
                    bl = byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        Object object;
        if (!this.isZIP(uRL)) {
            return null;
        }
        ArrayList<Soundbank> arrayList = new ArrayList<Soundbank>();
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{uRL});
        InputStream inputStream = uRLClassLoader.getResourceAsStream("META-INF/services/javax.sound.midi.Soundbank");
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.startsWith("#")) {
                try {
                    object = Class.forName(string.trim(), true, uRLClassLoader);
                    Object obj = ((Class)object).newInstance();
                    if (obj instanceof Soundbank) {
                        arrayList.add((Soundbank)obj);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string = bufferedReader.readLine();
        }
        inputStream.close();
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Soundbank)arrayList.get(0);
        }
        object = new SimpleSoundbank();
        for (Soundbank soundbank : arrayList) {
            ((SimpleSoundbank)object).addAllInstruments(soundbank);
        }
        return object;
    }

    public Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return null;
    }

    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return this.getSoundbank(file.toURI().toURL());
    }
}

