/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelInstrumentComparator;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.RIFFInvalidDataException;
import com.sun.media.sound.RIFFInvalidFormatException;
import com.sun.media.sound.RIFFReader;
import com.sun.media.sound.RIFFWriter;
import com.sun.media.sound.SF2GlobalRegion;
import com.sun.media.sound.SF2Instrument;
import com.sun.media.sound.SF2InstrumentRegion;
import com.sun.media.sound.SF2Layer;
import com.sun.media.sound.SF2LayerRegion;
import com.sun.media.sound.SF2Modulator;
import com.sun.media.sound.SF2Region;
import com.sun.media.sound.SF2Sample;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SF2Soundbank
implements Soundbank {
    protected int major = 2;
    protected int minor = 1;
    protected String targetEngine = "EMU8000";
    protected String name = "untitled";
    protected String romName = null;
    protected int romVersionMajor = -1;
    protected int romVersionMinor = -1;
    protected String creationDate = null;
    protected String engineers = null;
    protected String product = null;
    protected String copyright = null;
    protected String comments = null;
    protected String tools = null;
    private ModelByteBuffer sampleData = null;
    private ModelByteBuffer sampleData24 = null;
    private File sampleFile = null;
    private boolean largeFormat = false;
    private List<SF2Instrument> instruments = new ArrayList<SF2Instrument>();
    private List<SF2Layer> layers = new ArrayList<SF2Layer>();
    private List<SF2Sample> samples = new ArrayList<SF2Sample>();

    public SF2Soundbank() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SF2Soundbank(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            this.readSoundbank(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SF2Soundbank(File file) throws IOException {
        this.largeFormat = true;
        this.sampleFile = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.readSoundbank(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public SF2Soundbank(InputStream inputStream) throws IOException {
        this.readSoundbank(inputStream);
    }

    private void readSoundbank(InputStream inputStream) throws IOException {
        RIFFReader rIFFReader = new RIFFReader(inputStream);
        if (!rIFFReader.getFormat().equals("RIFF")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid RIFF stream!");
        }
        if (!rIFFReader.getType().equals("sfbk")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid SoundFont!");
        }
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (!rIFFReader2.getFormat().equals("LIST")) continue;
            if (rIFFReader2.getType().equals("INFO")) {
                this.readInfoChunk(rIFFReader2);
            }
            if (rIFFReader2.getType().equals("sdta")) {
                this.readSdtaChunk(rIFFReader2);
            }
            if (!rIFFReader2.getType().equals("pdta")) continue;
            this.readPdtaChunk(rIFFReader2);
        }
    }

    private void readInfoChunk(RIFFReader rIFFReader) throws IOException {
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("ifil")) {
                this.major = rIFFReader2.readUnsignedShort();
                this.minor = rIFFReader2.readUnsignedShort();
                continue;
            }
            if (string.equals("isng")) {
                this.targetEngine = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("INAM")) {
                this.name = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("irom")) {
                this.romName = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("iver")) {
                this.romVersionMajor = rIFFReader2.readUnsignedShort();
                this.romVersionMinor = rIFFReader2.readUnsignedShort();
                continue;
            }
            if (string.equals("ICRD")) {
                this.creationDate = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IENG")) {
                this.engineers = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IPRD")) {
                this.product = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICOP")) {
                this.copyright = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMT")) {
                this.comments = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (!string.equals("ISFT")) continue;
            this.tools = rIFFReader2.readString(rIFFReader2.available());
        }
    }

    private void readSdtaChunk(RIFFReader rIFFReader) throws IOException {
        while (rIFFReader.hasNextChunk()) {
            int n;
            int n2;
            byte[] byArray;
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (rIFFReader2.getFormat().equals("smpl")) {
                if (!this.largeFormat) {
                    byArray = new byte[rIFFReader2.available()];
                    n2 = 0;
                    n = rIFFReader2.available();
                    while (n2 != n) {
                        if (n - n2 > 65536) {
                            rIFFReader2.read(byArray, n2, 65536);
                            n2 += 65536;
                            continue;
                        }
                        rIFFReader2.read(byArray, n2, n - n2);
                        n2 = n;
                    }
                    this.sampleData = new ModelByteBuffer(byArray);
                } else {
                    this.sampleData = new ModelByteBuffer(this.sampleFile, rIFFReader2.getFilePointer(), (long)rIFFReader2.available());
                }
            }
            if (!rIFFReader2.getFormat().equals("sm24")) continue;
            if (!this.largeFormat) {
                byArray = new byte[rIFFReader2.available()];
                n2 = 0;
                n = rIFFReader2.available();
                while (n2 != n) {
                    if (n - n2 > 65536) {
                        rIFFReader2.read(byArray, n2, 65536);
                        n2 += 65536;
                        continue;
                    }
                    rIFFReader2.read(byArray, n2, n - n2);
                    n2 = n;
                }
                this.sampleData24 = new ModelByteBuffer(byArray);
                continue;
            }
            this.sampleData24 = new ModelByteBuffer(this.sampleFile, rIFFReader2.getFilePointer(), (long)rIFFReader2.available());
        }
    }

    private void readPdtaChunk(RIFFReader rIFFReader) throws IOException {
        ArrayList<SF2Instrument> arrayList = new ArrayList<SF2Instrument>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<SF2InstrumentRegion> arrayList3 = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2InstrumentRegion> arrayList4 = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2Layer> arrayList5 = new ArrayList<SF2Layer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<SF2InstrumentRegion> arrayList7 = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2InstrumentRegion> arrayList8 = new ArrayList<SF2InstrumentRegion>();
        while (rIFFReader.hasNextChunk()) {
            SF2Region sF2Region;
            int n;
            int n2;
            int sF2Layer;
            int sF2LayerRegion;
            int sF2Instrument;
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String object = rIFFReader2.getFormat();
            if (object.equals("phdr")) {
                if (rIFFReader2.available() % 38 != 0) {
                    throw new RIFFInvalidDataException();
                }
                sF2Instrument = rIFFReader2.available() / 38;
                for (sF2LayerRegion = 0; sF2LayerRegion < sF2Instrument; ++sF2LayerRegion) {
                    SF2Instrument s = new SF2Instrument(this);
                    s.name = rIFFReader2.readString(20);
                    s.preset = rIFFReader2.readUnsignedShort();
                    s.bank = rIFFReader2.readUnsignedShort();
                    arrayList2.add(rIFFReader2.readUnsignedShort());
                    s.library = rIFFReader2.readUnsignedInt();
                    s.genre = rIFFReader2.readUnsignedInt();
                    s.morphology = rIFFReader2.readUnsignedInt();
                    arrayList.add(s);
                    if (sF2LayerRegion == sF2Instrument - 1) continue;
                    this.instruments.add(s);
                }
                continue;
            }
            if (object.equals("pbag")) {
                int n10;
                if (rIFFReader2.available() % 4 != 0) {
                    throw new RIFFInvalidDataException();
                }
                sF2Instrument = rIFFReader2.available() / 4;
                sF2LayerRegion = rIFFReader2.readUnsignedShort();
                sF2Layer = rIFFReader2.readUnsignedShort();
                while (arrayList3.size() < sF2LayerRegion) {
                    arrayList3.add(null);
                }
                while (arrayList4.size() < sF2Layer) {
                    arrayList4.add(null);
                }
                --sF2Instrument;
                sF2LayerRegion = (Integer)arrayList2.get(0);
                for (sF2Layer = 0; sF2Layer < sF2LayerRegion; ++sF2Layer) {
                    if (sF2Instrument == 0) {
                        throw new RIFFInvalidDataException();
                    }
                    n10 = rIFFReader2.readUnsignedShort();
                    sF2Layer = rIFFReader2.readUnsignedShort();
                    while (arrayList3.size() < n10) {
                        arrayList3.add(null);
                    }
                    while (arrayList4.size() < sF2Layer) {
                        arrayList4.add(null);
                    }
                    --sF2Instrument;
                }
                for (sF2Layer = 0; sF2Layer < arrayList2.size() - 1; ++sF2Layer) {
                    n10 = (Integer)arrayList2.get(sF2Layer + 1) - (Integer)arrayList2.get(sF2Layer);
                    SF2Instrument s = (SF2Instrument)arrayList.get(sF2Layer);
                    for (int i = 0; i < n10; ++i) {
                        if (sF2Instrument == 0) {
                            throw new RIFFInvalidDataException();
                        }
                        n2 = rIFFReader2.readUnsignedShort();
                        n = rIFFReader2.readUnsignedShort();
                        sF2Region = new SF2InstrumentRegion();
                        s.regions.add((SF2InstrumentRegion)sF2Region);
                        while (arrayList3.size() < n2) {
                            arrayList3.add((SF2InstrumentRegion)sF2Region);
                        }
                        while (arrayList4.size() < n) {
                            arrayList4.add((SF2InstrumentRegion)sF2Region);
                        }
                        --sF2Instrument;
                    }
                }
                continue;
            }
            if (object.equals("pmod")) {
                for (sF2Instrument = 0; sF2Instrument < arrayList4.size(); ++sF2Instrument) {
                    SF2Modulator iterator = new SF2Modulator();
                    iterator.sourceOperator = rIFFReader2.readUnsignedShort();
                    iterator.destinationOperator = rIFFReader2.readUnsignedShort();
                    iterator.amount = rIFFReader2.readShort();
                    iterator.amountSourceOperator = rIFFReader2.readUnsignedShort();
                    iterator.transportOperator = rIFFReader2.readUnsignedShort();
                    SF2InstrumentRegion sF2LayerRegion2 = (SF2InstrumentRegion)arrayList4.get(sF2Instrument);
                    if (sF2LayerRegion2 == null) continue;
                    sF2LayerRegion2.modulators.add(iterator);
                }
                continue;
            }
            if (object.equals("pgen")) {
                for (sF2Instrument = 0; sF2Instrument < arrayList3.size(); ++sF2Instrument) {
                    sF2LayerRegion = rIFFReader2.readUnsignedShort();
                    short s = rIFFReader2.readShort();
                    SF2InstrumentRegion sF2LayerRegion2 = (SF2InstrumentRegion)arrayList3.get(sF2Instrument);
                    if (sF2LayerRegion2 == null) continue;
                    sF2LayerRegion2.generators.put(sF2LayerRegion, s);
                }
                continue;
            }
            if (object.equals("inst")) {
                if (rIFFReader2.available() % 22 != 0) {
                    throw new RIFFInvalidDataException();
                }
                sF2Instrument = rIFFReader2.available() / 22;
                for (sF2LayerRegion = 0; sF2LayerRegion < sF2Instrument; ++sF2LayerRegion) {
                    SF2Layer sF2Sample = new SF2Layer(this);
                    sF2Sample.name = rIFFReader2.readString(20);
                    arrayList6.add(rIFFReader2.readUnsignedShort());
                    arrayList5.add(sF2Sample);
                    if (sF2LayerRegion == sF2Instrument - 1) continue;
                    this.layers.add(sF2Sample);
                }
                continue;
            }
            if (object.equals("ibag")) {
                if (rIFFReader2.available() % 4 != 0) {
                    throw new RIFFInvalidDataException();
                }
                sF2Instrument = rIFFReader2.available() / 4;
                sF2LayerRegion = rIFFReader2.readUnsignedShort();
                sF2Layer = rIFFReader2.readUnsignedShort();
                while (arrayList7.size() < sF2LayerRegion) {
                    arrayList7.add(null);
                }
                while (arrayList8.size() < sF2Layer) {
                    arrayList8.add(null);
                }
                --sF2Instrument;
                sF2LayerRegion = (Integer)arrayList6.get(0);
                for (sF2Layer = 0; sF2Layer < sF2LayerRegion; ++sF2Layer) {
                    if (sF2Instrument == 0) {
                        throw new RIFFInvalidDataException();
                    }
                    int l = rIFFReader2.readUnsignedShort();
                    int n3 = rIFFReader2.readUnsignedShort();
                    while (arrayList7.size() < l) {
                        arrayList7.add(null);
                    }
                    while (arrayList8.size() < n3) {
                        arrayList8.add(null);
                    }
                    --sF2Instrument;
                }
                for (sF2Layer = 0; sF2Layer < arrayList6.size() - 1; ++sF2Layer) {
                    int s = (Integer)arrayList6.get(sF2Layer + 1) - (Integer)arrayList6.get(sF2Layer);
                    SF2Layer sF2Layer2 = this.layers.get(sF2Layer);
                    for (int i = 0; i < s; ++i) {
                        if (sF2Instrument == 0) {
                            throw new RIFFInvalidDataException();
                        }
                        n2 = rIFFReader2.readUnsignedShort();
                        n = rIFFReader2.readUnsignedShort();
                        sF2Region = new SF2LayerRegion();
                        sF2Layer2.regions.add((SF2LayerRegion)sF2Region);
                        while (arrayList7.size() < n2) {
                            arrayList7.add((SF2InstrumentRegion)sF2Region);
                        }
                        while (arrayList8.size() < n) {
                            arrayList8.add((SF2InstrumentRegion)sF2Region);
                        }
                        --sF2Instrument;
                    }
                }
                continue;
            }
            if (object.equals("imod")) {
                for (sF2Instrument = 0; sF2Instrument < arrayList8.size(); ++sF2Instrument) {
                    SF2Modulator sF2Modulator = new SF2Modulator();
                    sF2Modulator.sourceOperator = rIFFReader2.readUnsignedShort();
                    sF2Modulator.destinationOperator = rIFFReader2.readUnsignedShort();
                    sF2Modulator.amount = rIFFReader2.readShort();
                    sF2Modulator.amountSourceOperator = rIFFReader2.readUnsignedShort();
                    sF2Modulator.transportOperator = rIFFReader2.readUnsignedShort();
                    SF2LayerRegion sF2Region2 = (SF2LayerRegion)arrayList7.get(sF2Instrument);
                    if (sF2Region2 == null) continue;
                    sF2Region2.modulators.add(sF2Modulator);
                }
                continue;
            }
            if (object.equals("igen")) {
                for (sF2Instrument = 0; sF2Instrument < arrayList7.size(); ++sF2Instrument) {
                    sF2LayerRegion = rIFFReader2.readUnsignedShort();
                    short sF2InstrumentRegion = rIFFReader2.readShort();
                    SF2LayerRegion sF2Region3 = (SF2LayerRegion)arrayList7.get(sF2Instrument);
                    if (sF2Region3 == null) continue;
                    sF2Region3.generators.put(sF2LayerRegion, sF2InstrumentRegion);
                }
                continue;
            }
            if (!object.equals("shdr")) continue;
            if (rIFFReader2.available() % 46 != 0) {
                throw new RIFFInvalidDataException();
            }
            sF2Instrument = rIFFReader2.available() / 46;
            for (sF2LayerRegion = 0; sF2LayerRegion < sF2Instrument; ++sF2LayerRegion) {
                SF2Sample sF2Sample = new SF2Sample(this);
                sF2Sample.name = rIFFReader2.readString(20);
                long l = rIFFReader2.readUnsignedInt();
                long l2 = rIFFReader2.readUnsignedInt();
                sF2Sample.data = this.sampleData.subbuffer(l * 2L, l2 * 2L, true);
                if (this.sampleData24 != null) {
                    sF2Sample.data24 = this.sampleData24.subbuffer(l, l2, true);
                }
                sF2Sample.startLoop = rIFFReader2.readUnsignedInt() - l;
                sF2Sample.endLoop = rIFFReader2.readUnsignedInt() - l;
                if (sF2Sample.startLoop < 0L) {
                    sF2Sample.startLoop = -1L;
                }
                if (sF2Sample.endLoop < 0L) {
                    sF2Sample.endLoop = -1L;
                }
                sF2Sample.sampleRate = rIFFReader2.readUnsignedInt();
                sF2Sample.originalPitch = rIFFReader2.readUnsignedByte();
                sF2Sample.pitchCorrection = rIFFReader2.readByte();
                sF2Sample.sampleLink = rIFFReader2.readUnsignedShort();
                sF2Sample.sampleType = rIFFReader2.readUnsignedShort();
                if (sF2LayerRegion == sF2Instrument - 1) continue;
                this.samples.add(sF2Sample);
            }
        }
        for (SF2Layer sF2Layer : this.layers) {
            SF2Region sF2Region;
            Iterator<SF2LayerRegion> iterator = sF2Layer.regions.iterator();
            SF2LayerRegion sF2LayerRegion = null;
            while (iterator.hasNext()) {
                sF2Region = iterator.next();
                if (sF2Region.generators.get(53) != null) {
                    short s = (Short)sF2Region.generators.get(53);
                    sF2Region.generators.remove(53);
                    sF2Region.sample = this.samples.get(s);
                    continue;
                }
                sF2LayerRegion = sF2Region;
            }
            if (sF2LayerRegion == null) continue;
            sF2Layer.getRegions().remove(sF2LayerRegion);
            sF2Region = new SF2GlobalRegion();
            ((SF2GlobalRegion)sF2Region).generators = sF2LayerRegion.generators;
            ((SF2GlobalRegion)sF2Region).modulators = sF2LayerRegion.modulators;
            sF2Layer.setGlobalZone((SF2GlobalRegion)sF2Region);
        }
        for (SF2Instrument sF2Instrument : this.instruments) {
            SF2Region sF2Region;
            Iterator<SF2InstrumentRegion> iterator = sF2Instrument.regions.iterator();
            SF2InstrumentRegion sF2InstrumentRegion = null;
            while (iterator.hasNext()) {
                sF2Region = iterator.next();
                if (sF2Region.generators.get(41) != null) {
                    short s = (Short)sF2Region.generators.get(41);
                    sF2Region.generators.remove(41);
                    sF2Region.layer = this.layers.get(s);
                    continue;
                }
                sF2InstrumentRegion = sF2Region;
            }
            if (sF2InstrumentRegion == null) continue;
            sF2Instrument.getRegions().remove(sF2InstrumentRegion);
            sF2Region = new SF2GlobalRegion();
            ((SF2GlobalRegion)sF2Region).generators = sF2InstrumentRegion.generators;
            ((SF2GlobalRegion)sF2Region).modulators = sF2InstrumentRegion.modulators;
            sF2Instrument.setGlobalZone((SF2GlobalRegion)sF2Region);
        }
    }

    public void save(String string) throws IOException {
        this.writeSoundbank(new RIFFWriter(string, "sfbk"));
    }

    public void save(File file) throws IOException {
        this.writeSoundbank(new RIFFWriter(file, "sfbk"));
    }

    public void save(OutputStream outputStream) throws IOException {
        this.writeSoundbank(new RIFFWriter(outputStream, "sfbk"));
    }

    private void writeSoundbank(RIFFWriter rIFFWriter) throws IOException {
        this.writeInfo(rIFFWriter.writeList("INFO"));
        this.writeSdtaChunk(rIFFWriter.writeList("sdta"));
        this.writePdtaChunk(rIFFWriter.writeList("pdta"));
        rIFFWriter.close();
    }

    private void writeInfoStringChunk(RIFFWriter rIFFWriter, String string, String string2) throws IOException {
        if (string2 == null) {
            return;
        }
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk(string);
        rIFFWriter2.writeString(string2);
        int n = string2.getBytes("ascii").length;
        rIFFWriter2.write(0);
        if (++n % 2 != 0) {
            rIFFWriter2.write(0);
        }
    }

    private void writeInfo(RIFFWriter rIFFWriter) throws IOException {
        if (this.targetEngine == null) {
            this.targetEngine = "EMU8000";
        }
        if (this.name == null) {
            this.name = "";
        }
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("ifil");
        rIFFWriter2.writeUnsignedShort(this.major);
        rIFFWriter2.writeUnsignedShort(this.minor);
        this.writeInfoStringChunk(rIFFWriter, "isng", this.targetEngine);
        this.writeInfoStringChunk(rIFFWriter, "INAM", this.name);
        this.writeInfoStringChunk(rIFFWriter, "irom", this.romName);
        if (this.romVersionMajor != -1) {
            RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("iver");
            rIFFWriter3.writeUnsignedShort(this.romVersionMajor);
            rIFFWriter3.writeUnsignedShort(this.romVersionMinor);
        }
        this.writeInfoStringChunk(rIFFWriter, "ICRD", this.creationDate);
        this.writeInfoStringChunk(rIFFWriter, "IENG", this.engineers);
        this.writeInfoStringChunk(rIFFWriter, "IPRD", this.product);
        this.writeInfoStringChunk(rIFFWriter, "ICOP", this.copyright);
        this.writeInfoStringChunk(rIFFWriter, "ICMT", this.comments);
        this.writeInfoStringChunk(rIFFWriter, "ISFT", this.tools);
        rIFFWriter.close();
    }

    private void writeSdtaChunk(RIFFWriter rIFFWriter) throws IOException {
        byte[] byArray = new byte[32];
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("smpl");
        for (SF2Sample object2 : this.samples) {
            ModelByteBuffer modelByteBuffer = object2.getDataBuffer();
            modelByteBuffer.writeTo(rIFFWriter2);
            rIFFWriter2.write(byArray);
            rIFFWriter2.write(byArray);
        }
        if (this.major < 2) {
            return;
        }
        if (this.major == 2 && this.minor < 4) {
            return;
        }
        for (SF2Sample sF2Sample : this.samples) {
            ModelByteBuffer modelByteBuffer = sF2Sample.getData24Buffer();
            if (modelByteBuffer != null) continue;
            return;
        }
        RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("sm24");
        for (SF2Sample sF2Sample : this.samples) {
            ModelByteBuffer modelByteBuffer = sF2Sample.getData24Buffer();
            modelByteBuffer.writeTo(rIFFWriter3);
            rIFFWriter2.write(byArray);
        }
    }

    private void writeModulators(RIFFWriter rIFFWriter, List<SF2Modulator> list) throws IOException {
        for (SF2Modulator sF2Modulator : list) {
            rIFFWriter.writeUnsignedShort(sF2Modulator.sourceOperator);
            rIFFWriter.writeUnsignedShort(sF2Modulator.destinationOperator);
            rIFFWriter.writeShort(sF2Modulator.amount);
            rIFFWriter.writeUnsignedShort(sF2Modulator.amountSourceOperator);
            rIFFWriter.writeUnsignedShort(sF2Modulator.transportOperator);
        }
    }

    private void writeGenerators(RIFFWriter rIFFWriter, Map<Integer, Short> map) throws IOException {
        Short s = map.get(43);
        Short s2 = map.get(44);
        if (s != null) {
            rIFFWriter.writeUnsignedShort(43);
            rIFFWriter.writeShort(s);
        }
        if (s2 != null) {
            rIFFWriter.writeUnsignedShort(44);
            rIFFWriter.writeShort(s2);
        }
        for (Map.Entry<Integer, Short> entry : map.entrySet()) {
            if (entry.getKey() == 43 || entry.getKey() == 44) continue;
            rIFFWriter.writeUnsignedShort(entry.getKey());
            rIFFWriter.writeShort(entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePdtaChunk(RIFFWriter rIFFWriter) throws IOException {
        void var12_33;
        void var10_23;
        int n;
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("phdr");
        int n2 = 0;
        for (SF2Instrument sF2Instrument : this.instruments) {
            rIFFWriter2.writeString(sF2Instrument.name, 20);
            rIFFWriter2.writeUnsignedShort(sF2Instrument.preset);
            rIFFWriter2.writeUnsignedShort(sF2Instrument.bank);
            rIFFWriter2.writeUnsignedShort(n2);
            if (sF2Instrument.getGlobalRegion() != null) {
                ++n2;
            }
            n2 += sF2Instrument.getRegions().size();
            rIFFWriter2.writeUnsignedInt(sF2Instrument.library);
            rIFFWriter2.writeUnsignedInt(sF2Instrument.genre);
            rIFFWriter2.writeUnsignedInt(sF2Instrument.morphology);
        }
        rIFFWriter2.writeString("EOP", 20);
        rIFFWriter2.writeUnsignedShort(0);
        rIFFWriter2.writeUnsignedShort(0);
        rIFFWriter2.writeUnsignedShort(n2);
        rIFFWriter2.writeUnsignedInt(0L);
        rIFFWriter2.writeUnsignedInt(0L);
        rIFFWriter2.writeUnsignedInt(0L);
        RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("pbag");
        int n3 = 0;
        int n4 = 0;
        for (SF2Instrument object52 : this.instruments) {
            if (object52.getGlobalRegion() != null) {
                rIFFWriter3.writeUnsignedShort(n3);
                rIFFWriter3.writeUnsignedShort(n4);
                n3 += object52.getGlobalRegion().getGenerators().size();
                n4 += object52.getGlobalRegion().getModulators().size();
            }
            for (SF2InstrumentRegion sF2InstrumentRegion : object52.getRegions()) {
                rIFFWriter3.writeUnsignedShort(n3);
                rIFFWriter3.writeUnsignedShort(n4);
                if (this.layers.indexOf(sF2InstrumentRegion.layer) != -1) {
                    ++n3;
                }
                n3 += sF2InstrumentRegion.getGenerators().size();
                n4 += sF2InstrumentRegion.getModulators().size();
            }
        }
        rIFFWriter3.writeUnsignedShort(n3);
        rIFFWriter3.writeUnsignedShort(n4);
        RIFFWriter rIFFWriter4 = rIFFWriter.writeChunk("pmod");
        for (SF2Instrument sF2Instrument : this.instruments) {
            if (sF2Instrument.getGlobalRegion() != null) {
                this.writeModulators(rIFFWriter4, sF2Instrument.getGlobalRegion().getModulators());
            }
            for (SF2InstrumentRegion sF2InstrumentRegion : sF2Instrument.getRegions()) {
                this.writeModulators(rIFFWriter4, sF2InstrumentRegion.getModulators());
            }
        }
        rIFFWriter4.write(new byte[10]);
        RIFFWriter rIFFWriter5 = rIFFWriter.writeChunk("pgen");
        for (SF2Instrument sF2Instrument : this.instruments) {
            if (sF2Instrument.getGlobalRegion() != null) {
                this.writeGenerators(rIFFWriter5, sF2Instrument.getGlobalRegion().getGenerators());
            }
            for (SF2InstrumentRegion sF2InstrumentRegion : sF2Instrument.getRegions()) {
                this.writeGenerators(rIFFWriter5, sF2InstrumentRegion.getGenerators());
                n = this.layers.indexOf(sF2InstrumentRegion.layer);
                if (n == -1) continue;
                rIFFWriter5.writeUnsignedShort(41);
                rIFFWriter5.writeShort((short)n);
            }
        }
        rIFFWriter5.write(new byte[4]);
        RIFFWriter rIFFWriter6 = rIFFWriter.writeChunk("inst");
        boolean bl = false;
        for (SF2Layer sF2Layer : this.layers) {
            rIFFWriter6.writeString(sF2Layer.name, 20);
            rIFFWriter6.writeUnsignedShort((int)var10_23);
            if (sF2Layer.getGlobalRegion() != null) {
                ++var10_23;
            }
            var10_23 += sF2Layer.getRegions().size();
        }
        rIFFWriter6.writeString("EOI", 20);
        rIFFWriter6.writeUnsignedShort((int)var10_23);
        RIFFWriter rIFFWriter7 = rIFFWriter.writeChunk("ibag");
        boolean bl2 = false;
        n = 0;
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                rIFFWriter7.writeUnsignedShort((int)var12_33);
                rIFFWriter7.writeUnsignedShort(n);
                var12_33 += sF2Layer.getGlobalRegion().getGenerators().size();
                n += sF2Layer.getGlobalRegion().getModulators().size();
            }
            for (SF2LayerRegion sF2LayerRegion : sF2Layer.getRegions()) {
                rIFFWriter7.writeUnsignedShort((int)var12_33);
                rIFFWriter7.writeUnsignedShort(n);
                if (this.samples.indexOf(sF2LayerRegion.sample) != -1) {
                    ++var12_33;
                }
                var12_33 += sF2LayerRegion.getGenerators().size();
                n += sF2LayerRegion.getModulators().size();
            }
        }
        rIFFWriter7.writeUnsignedShort((int)var12_33);
        rIFFWriter7.writeUnsignedShort(n);
        RIFFWriter rIFFWriter8 = rIFFWriter.writeChunk("imod");
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                this.writeModulators(rIFFWriter8, sF2Layer.getGlobalRegion().getModulators());
            }
            for (SF2LayerRegion sF2LayerRegion : sF2Layer.getRegions()) {
                this.writeModulators(rIFFWriter8, sF2LayerRegion.getModulators());
            }
        }
        rIFFWriter8.write(new byte[10]);
        RIFFWriter rIFFWriter9 = rIFFWriter.writeChunk("igen");
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                this.writeGenerators(rIFFWriter9, sF2Layer.getGlobalRegion().getGenerators());
            }
            for (SF2LayerRegion sF2LayerRegion : sF2Layer.getRegions()) {
                this.writeGenerators(rIFFWriter9, sF2LayerRegion.getGenerators());
                int n5 = this.samples.indexOf(sF2LayerRegion.sample);
                if (n5 == -1) continue;
                rIFFWriter9.writeUnsignedShort(53);
                rIFFWriter9.writeShort((short)n5);
            }
        }
        rIFFWriter9.write(new byte[4]);
        RIFFWriter rIFFWriter10 = rIFFWriter.writeChunk("shdr");
        long l = 0L;
        for (SF2Sample sF2Sample : this.samples) {
            rIFFWriter10.writeString(sF2Sample.name, 20);
            long l2 = l;
            long l3 = l += sF2Sample.data.capacity() / 2L;
            long l4 = sF2Sample.startLoop + l2;
            long l5 = sF2Sample.endLoop + l2;
            if (l4 < l2) {
                l4 = l2;
            }
            if (l5 > l3) {
                l5 = l3;
            }
            rIFFWriter10.writeUnsignedInt(l2);
            rIFFWriter10.writeUnsignedInt(l3);
            rIFFWriter10.writeUnsignedInt(l4);
            rIFFWriter10.writeUnsignedInt(l5);
            rIFFWriter10.writeUnsignedInt(sF2Sample.sampleRate);
            rIFFWriter10.writeUnsignedByte(sF2Sample.originalPitch);
            rIFFWriter10.writeByte(sF2Sample.pitchCorrection);
            rIFFWriter10.writeUnsignedShort(sF2Sample.sampleLink);
            rIFFWriter10.writeUnsignedShort(sF2Sample.sampleType);
            l += 32L;
        }
        rIFFWriter10.writeString("EOS", 20);
        rIFFWriter10.write(new byte[26]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.major + "." + this.minor;
    }

    @Override
    public String getVendor() {
        return this.engineers;
    }

    @Override
    public String getDescription() {
        return this.comments;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setVendor(String string) {
        this.engineers = string;
    }

    public void setDescription(String string) {
        this.comments = string;
    }

    @Override
    public SoundbankResource[] getResources() {
        int n;
        SoundbankResource[] soundbankResourceArray = new SoundbankResource[this.layers.size() + this.samples.size()];
        int n2 = 0;
        for (n = 0; n < this.layers.size(); ++n) {
            soundbankResourceArray[n2++] = this.layers.get(n);
        }
        for (n = 0; n < this.samples.size(); ++n) {
            soundbankResourceArray[n2++] = this.samples.get(n);
        }
        return soundbankResourceArray;
    }

    public SF2Instrument[] getInstruments() {
        SF2Instrument[] sF2InstrumentArray = this.instruments.toArray(new SF2Instrument[this.instruments.size()]);
        Arrays.sort(sF2InstrumentArray, new ModelInstrumentComparator());
        return sF2InstrumentArray;
    }

    public SF2Layer[] getLayers() {
        return this.layers.toArray(new SF2Layer[this.layers.size()]);
    }

    public SF2Sample[] getSamples() {
        return this.samples.toArray(new SF2Sample[this.samples.size()]);
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int n = patch.getProgram();
        int n2 = patch.getBank();
        boolean bl = false;
        if (patch instanceof ModelPatch) {
            bl = ((ModelPatch)patch).isPercussion();
        }
        for (SF2Instrument sF2Instrument : this.instruments) {
            Patch patch2 = ((Instrument)sF2Instrument).getPatch();
            int n3 = patch2.getProgram();
            int n4 = patch2.getBank();
            if (n != n3 || n2 != n4) continue;
            boolean bl2 = false;
            if (patch2 instanceof ModelPatch) {
                bl2 = ((ModelPatch)patch2).isPercussion();
            }
            if (bl != bl2) continue;
            return sF2Instrument;
        }
        return null;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String string) {
        this.creationDate = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getRomName() {
        return this.romName;
    }

    public void setRomName(String string) {
        this.romName = string;
    }

    public int getRomVersionMajor() {
        return this.romVersionMajor;
    }

    public void setRomVersionMajor(int n) {
        this.romVersionMajor = n;
    }

    public int getRomVersionMinor() {
        return this.romVersionMinor;
    }

    public void setRomVersionMinor(int n) {
        this.romVersionMinor = n;
    }

    public String getTargetEngine() {
        return this.targetEngine;
    }

    public void setTargetEngine(String string) {
        this.targetEngine = string;
    }

    public String getTools() {
        return this.tools;
    }

    public void setTools(String string) {
        this.tools = string;
    }

    public void addResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof SF2Instrument) {
            this.instruments.add((SF2Instrument)soundbankResource);
        }
        if (soundbankResource instanceof SF2Layer) {
            this.layers.add((SF2Layer)soundbankResource);
        }
        if (soundbankResource instanceof SF2Sample) {
            this.samples.add((SF2Sample)soundbankResource);
        }
    }

    public void removeResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof SF2Instrument) {
            this.instruments.remove((SF2Instrument)soundbankResource);
        }
        if (soundbankResource instanceof SF2Layer) {
            this.layers.remove((SF2Layer)soundbankResource);
        }
        if (soundbankResource instanceof SF2Sample) {
            this.samples.remove((SF2Sample)soundbankResource);
        }
    }

    public void addInstrument(SF2Instrument sF2Instrument) {
        this.instruments.add(sF2Instrument);
    }

    public void removeInstrument(SF2Instrument sF2Instrument) {
        this.instruments.remove(sF2Instrument);
    }
}

