/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Patch;

public class SimpleInstrument
extends ModelInstrument {
    protected int preset = 0;
    protected int bank = 0;
    protected boolean percussion = false;
    protected String name = "";
    protected List<SimpleInstrumentPart> parts = new ArrayList<SimpleInstrumentPart>();

    public SimpleInstrument() {
        super(null, null, null, null);
    }

    public void clear() {
        this.parts.clear();
    }

    public void add(ModelPerformer[] modelPerformerArray, int n, int n2, int n3, int n4, int n5) {
        SimpleInstrumentPart simpleInstrumentPart = new SimpleInstrumentPart();
        simpleInstrumentPart.performers = modelPerformerArray;
        simpleInstrumentPart.keyFrom = n;
        simpleInstrumentPart.keyTo = n2;
        simpleInstrumentPart.velFrom = n3;
        simpleInstrumentPart.velTo = n4;
        simpleInstrumentPart.exclusiveClass = n5;
        this.parts.add(simpleInstrumentPart);
    }

    public void add(ModelPerformer[] modelPerformerArray, int n, int n2, int n3, int n4) {
        this.add(modelPerformerArray, n, n2, n3, n4, -1);
    }

    public void add(ModelPerformer[] modelPerformerArray, int n, int n2) {
        this.add(modelPerformerArray, n, n2, 0, 127, -1);
    }

    public void add(ModelPerformer[] modelPerformerArray) {
        this.add(modelPerformerArray, 0, 127, 0, 127, -1);
    }

    public void add(ModelPerformer modelPerformer, int n, int n2, int n3, int n4, int n5) {
        this.add(new ModelPerformer[]{modelPerformer}, n, n2, n3, n4, n5);
    }

    public void add(ModelPerformer modelPerformer, int n, int n2, int n3, int n4) {
        this.add(new ModelPerformer[]{modelPerformer}, n, n2, n3, n4);
    }

    public void add(ModelPerformer modelPerformer, int n, int n2) {
        this.add(new ModelPerformer[]{modelPerformer}, n, n2);
    }

    public void add(ModelPerformer modelPerformer) {
        this.add(new ModelPerformer[]{modelPerformer});
    }

    public void add(ModelInstrument modelInstrument, int n, int n2, int n3, int n4, int n5) {
        this.add(modelInstrument.getPerformers(), n, n2, n3, n4, n5);
    }

    public void add(ModelInstrument modelInstrument, int n, int n2, int n3, int n4) {
        this.add(modelInstrument.getPerformers(), n, n2, n3, n4);
    }

    public void add(ModelInstrument modelInstrument, int n, int n2) {
        this.add(modelInstrument.getPerformers(), n, n2);
    }

    public void add(ModelInstrument modelInstrument) {
        this.add(modelInstrument.getPerformers());
    }

    public ModelPerformer[] getPerformers() {
        int n = 0;
        for (SimpleInstrumentPart simpleInstrumentPart : this.parts) {
            if (simpleInstrumentPart.performers == null) continue;
            n += simpleInstrumentPart.performers.length;
        }
        ModelPerformer[] modelPerformerArray = new ModelPerformer[n];
        int n2 = 0;
        for (SimpleInstrumentPart simpleInstrumentPart : this.parts) {
            if (simpleInstrumentPart.performers == null) continue;
            for (ModelPerformer modelPerformer : simpleInstrumentPart.performers) {
                ModelPerformer modelPerformer2 = new ModelPerformer();
                modelPerformer2.setName(this.getName());
                modelPerformerArray[n2++] = modelPerformer2;
                modelPerformer2.setDefaultConnectionsEnabled(modelPerformer.isDefaultConnectionsEnabled());
                modelPerformer2.setKeyFrom(modelPerformer.getKeyFrom());
                modelPerformer2.setKeyTo(modelPerformer.getKeyTo());
                modelPerformer2.setVelFrom(modelPerformer.getVelFrom());
                modelPerformer2.setVelTo(modelPerformer.getVelTo());
                modelPerformer2.setExclusiveClass(modelPerformer.getExclusiveClass());
                modelPerformer2.setSelfNonExclusive(modelPerformer.isSelfNonExclusive());
                modelPerformer2.setReleaseTriggered(modelPerformer.isReleaseTriggered());
                if (simpleInstrumentPart.exclusiveClass != -1) {
                    modelPerformer2.setExclusiveClass(simpleInstrumentPart.exclusiveClass);
                }
                if (simpleInstrumentPart.keyFrom > modelPerformer2.getKeyFrom()) {
                    modelPerformer2.setKeyFrom(simpleInstrumentPart.keyFrom);
                }
                if (simpleInstrumentPart.keyTo < modelPerformer2.getKeyTo()) {
                    modelPerformer2.setKeyTo(simpleInstrumentPart.keyTo);
                }
                if (simpleInstrumentPart.velFrom > modelPerformer2.getVelFrom()) {
                    modelPerformer2.setVelFrom(simpleInstrumentPart.velFrom);
                }
                if (simpleInstrumentPart.velTo < modelPerformer2.getVelTo()) {
                    modelPerformer2.setVelTo(simpleInstrumentPart.velTo);
                }
                modelPerformer2.getOscillators().addAll(modelPerformer.getOscillators());
                modelPerformer2.getConnectionBlocks().addAll(modelPerformer.getConnectionBlocks());
            }
        }
        return modelPerformerArray;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ModelPatch getPatch() {
        return new ModelPatch(this.bank, this.preset, this.percussion);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.percussion = true;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        } else {
            this.percussion = false;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        }
    }

    private class SimpleInstrumentPart {
        ModelPerformer[] performers;
        int keyFrom;
        int keyTo;
        int velFrom;
        int velTo;
        int exclusiveClass;

        private SimpleInstrumentPart() {
        }
    }
}

