/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.SoftPerformer;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;

public class SoftInstrument
extends Instrument {
    private SoftPerformer[] performers;
    private ModelPerformer[] modelperformers;
    private Object data;
    private ModelInstrument ins;

    public SoftInstrument(ModelInstrument modelInstrument) {
        super(modelInstrument.getSoundbank(), modelInstrument.getPatch(), modelInstrument.getName(), modelInstrument.getDataClass());
        if (!(modelInstrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Instrument doesn't implement ModelInstrument interface!");
        }
        this.data = modelInstrument.getData();
        this.ins = modelInstrument;
        this.initPerformers(modelInstrument.getPerformers());
    }

    public SoftInstrument(ModelInstrument modelInstrument, ModelPerformer[] modelPerformerArray) {
        super(modelInstrument.getSoundbank(), modelInstrument.getPatch(), modelInstrument.getName(), modelInstrument.getDataClass());
        if (!(modelInstrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Instrument doesn't implement ModelInstrument interface!");
        }
        this.data = modelInstrument.getData();
        this.ins = modelInstrument;
        this.initPerformers(modelPerformerArray);
    }

    private void initPerformers(ModelPerformer[] modelPerformerArray) {
        this.modelperformers = modelPerformerArray;
        this.performers = new SoftPerformer[modelPerformerArray.length];
        for (int i = 0; i < modelPerformerArray.length; ++i) {
            this.performers[i] = new SoftPerformer(modelPerformerArray[i]);
        }
    }

    public ModelDirector getDirector(MidiChannel midiChannel, ModelDirectedPlayer modelDirectedPlayer) {
        return this.ins.getDirector(this.modelperformers, midiChannel, modelDirectedPlayer);
    }

    public ModelInstrument getSourceInstrument() {
        return this.ins;
    }

    public Object getData() {
        return this.data;
    }

    public SoftPerformer[] getPerformers() {
        return this.performers;
    }
}

