/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import com.sun.media.sound.SoftSynthesizer;
import java.util.Arrays;

public class SoftReverb
implements SoftAudioProcessor {
    private float roomsize;
    private float damp;
    private float gain = 1.0f;
    private Delay delay;
    private Comb[] combL;
    private Comb[] combR;
    private AllPass[] allpassL;
    private AllPass[] allpassR;
    private float[] input;
    private float[] outR;
    private float[] outL;
    private boolean mix = true;
    private SoftAudioBuffer inputA;
    private SoftAudioBuffer left;
    private SoftAudioBuffer right;
    private SoftSynthesizer synth;
    private boolean dirty = true;
    private float dirty_roomsize;
    private float dirty_damp;
    private float dirty_predelay;
    private float dirty_gain;
    private double silentcounter = 1000.0;

    public void init(SoftSynthesizer softSynthesizer) {
        this.synth = softSynthesizer;
        double d = softSynthesizer.getFormat().getSampleRate();
        double d2 = d / 44100.0;
        int n = 23;
        this.delay = new Delay();
        this.combL = new Comb[8];
        this.combR = new Comb[8];
        this.combL[0] = new Comb((int)(d2 * 1116.0));
        this.combR[0] = new Comb((int)(d2 * (double)(1116 + n)));
        this.combL[1] = new Comb((int)(d2 * 1188.0));
        this.combR[1] = new Comb((int)(d2 * (double)(1188 + n)));
        this.combL[2] = new Comb((int)(d2 * 1277.0));
        this.combR[2] = new Comb((int)(d2 * (double)(1277 + n)));
        this.combL[3] = new Comb((int)(d2 * 1356.0));
        this.combR[3] = new Comb((int)(d2 * (double)(1356 + n)));
        this.combL[4] = new Comb((int)(d2 * 1422.0));
        this.combR[4] = new Comb((int)(d2 * (double)(1422 + n)));
        this.combL[5] = new Comb((int)(d2 * 1491.0));
        this.combR[5] = new Comb((int)(d2 * (double)(1491 + n)));
        this.combL[6] = new Comb((int)(d2 * 1557.0));
        this.combR[6] = new Comb((int)(d2 * (double)(1557 + n)));
        this.combL[7] = new Comb((int)(d2 * 1617.0));
        this.combR[7] = new Comb((int)(d2 * (double)(1617 + n)));
        this.allpassL = new AllPass[4];
        this.allpassR = new AllPass[4];
        this.allpassL[0] = new AllPass((int)(d2 * 556.0));
        this.allpassR[0] = new AllPass((int)(d2 * (double)(556 + n)));
        this.allpassL[1] = new AllPass((int)(d2 * 441.0));
        this.allpassR[1] = new AllPass((int)(d2 * (double)(441 + n)));
        this.allpassL[2] = new AllPass((int)(d2 * 341.0));
        this.allpassR[2] = new AllPass((int)(d2 * (double)(341 + n)));
        this.allpassL[3] = new AllPass((int)(d2 * 225.0));
        this.allpassR[3] = new AllPass((int)(d2 * (double)(225 + n)));
        for (int i = 0; i < this.allpassL.length; ++i) {
            this.allpassL[i].setFeedBack(0.5f);
            this.allpassR[i].setFeedBack(0.5f);
        }
        this.globalParameterControlChange(new int[]{129}, 0L, 4L);
    }

    public void setInput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.inputA = softAudioBuffer;
        }
    }

    public void setOutput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.left = softAudioBuffer;
        }
        if (n == 1) {
            this.right = softAudioBuffer;
        }
    }

    public void setMixMode(boolean bl) {
        this.mix = bl;
    }

    public void processAudio() {
        int n;
        if (this.inputA.isSilent()) {
            this.silentcounter += (double)(1.0f / this.synth.getControlRate());
            if (this.silentcounter > 60.0) {
                if (!this.mix) {
                    this.left.clear();
                    this.right.clear();
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] fArray = this.inputA.array();
        float[] fArray2 = this.left.array();
        float[] fArray3 = this.right == null ? null : this.right.array();
        int n2 = fArray.length;
        if (this.input == null || this.input.length < n2) {
            this.input = new float[n2];
        }
        float f = this.gain * 0.018f / 2.0f;
        for (n = 0; n < n2; ++n) {
            this.input[n] = fArray[n] * f;
        }
        this.delay.processReplace(this.input, this.input);
        if (fArray3 != null) {
            if (this.outR == null || this.outR.length < n2) {
                this.outR = new float[n2];
            }
            Arrays.fill(this.outR, 0.0f);
            for (n = 0; n < this.combR.length; ++n) {
                this.combR[n].processMix(this.input, this.outR);
            }
            for (n = 0; n < this.allpassL.length; ++n) {
                this.allpassR[n].processReplace(this.outR, this.outR);
            }
            if (this.mix) {
                for (n = 0; n < n2; ++n) {
                    int n3 = n;
                    fArray3[n3] = fArray3[n3] + this.outR[n];
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    fArray3[n] = this.outR[n];
                }
            }
        }
        if (this.outL == null || this.outL.length < n2) {
            this.outL = new float[n2];
        }
        Arrays.fill(this.outL, 0.0f);
        for (n = 0; n < this.combL.length; ++n) {
            this.combL[n].processMix(this.input, this.outL);
        }
        for (n = 0; n < this.allpassL.length; ++n) {
            this.allpassL[n].processReplace(this.outL, this.outL);
        }
        if (this.mix) {
            for (n = 0; n < n2; ++n) {
                int n4 = n;
                fArray2[n4] = fArray2[n4] + this.outL[n];
            }
        } else {
            for (n = 0; n < n2; ++n) {
                fArray2[n] = this.outL[n];
            }
        }
    }

    public void globalParameterControlChange(int[] nArray, long l, long l2) {
        if (nArray.length == 1 && nArray[0] == 129) {
            if (l == 0L) {
                if (l2 == 0L) {
                    this.dirty_roomsize = 1.1f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 4.0f;
                    this.dirty = true;
                }
                if (l2 == 1L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 3.0f;
                    this.dirty = true;
                }
                if (l2 == 2L) {
                    this.dirty_roomsize = 1.5f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 2.0f;
                    this.dirty = true;
                }
                if (l2 == 3L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.02f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (l2 == 4L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.03f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (l2 == 8L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 2500.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 6.0f;
                    this.dirty = true;
                }
            } else if (l == 1L) {
                this.dirty_roomsize = (float)Math.exp((double)(l2 - 40L) * 0.025);
                this.dirty = true;
            }
        }
    }

    public void processControlLogic() {
        if (this.dirty) {
            this.dirty = false;
            this.setRoomSize(this.dirty_roomsize);
            this.setDamp(this.dirty_damp);
            this.setPreDelay(this.dirty_predelay);
            this.setGain(this.dirty_gain);
        }
    }

    public void setRoomSize(float f) {
        this.roomsize = 1.0f - 0.17f / f;
        for (int i = 0; i < 8; ++i) {
            this.combL[i].feedback = this.roomsize;
            this.combR[i].feedback = this.roomsize;
        }
    }

    public void setPreDelay(float f) {
        this.delay.setDelay((int)(f * this.synth.getFormat().getSampleRate()));
    }

    public void setGain(float f) {
        this.gain = f;
    }

    public void setDamp(float f) {
        double d = (double)(f / this.synth.getFormat().getSampleRate()) * (Math.PI * 2);
        double d2 = 2.0 - Math.cos(d);
        this.damp = (float)(d2 - Math.sqrt(d2 * d2 - 1.0));
        if (this.damp > 1.0f) {
            this.damp = 1.0f;
        }
        if (this.damp < 0.0f) {
            this.damp = 0.0f;
        }
        for (int i = 0; i < 8; ++i) {
            this.combL[i].setDamp(this.damp);
            this.combR[i].setDamp(this.damp);
        }
    }

    private class Comb {
        private float[] delaybuffer;
        private int delaybuffersize;
        private int rovepos = 0;
        private float feedback;
        private float filtertemp = 0.0f;
        private float filtercoeff1 = 0.0f;
        private float filtercoeff2 = 1.0f;
        int ucount = 0;

        public Comb(int n) {
            this.delaybuffer = new float[n];
            this.delaybuffersize = n;
        }

        public void setFeedBack(float f) {
            this.feedback = f;
        }

        public void processMix(float[] fArray, float[] fArray2) {
            int n;
            int n2 = fArray.length;
            float f = this.filtercoeff2 * this.feedback;
            for (n = 0; n < n2; ++n) {
                float f2 = this.delaybuffer[this.rovepos];
                this.filtertemp = f2 * f + this.filtertemp * this.filtercoeff1;
                int n3 = n;
                fArray2[n3] = fArray2[n3] + f2;
                this.delaybuffer[this.rovepos] = fArray[n] + this.filtertemp;
                if (++this.rovepos != this.delaybuffersize) continue;
                this.rovepos = 0;
            }
            ++this.ucount;
            if (this.ucount == 10) {
                this.ucount = 0;
                if ((double)this.filtertemp > 0.0 && (double)this.filtertemp < 1.0E-10 || (double)this.filtertemp < 0.0 && (double)this.filtertemp > -1.0E-10) {
                    this.filtertemp = 0.0f;
                }
                for (n = 0; n < this.delaybuffer.length; ++n) {
                    double d = this.delaybuffer[n];
                    if (!(d > 0.0 && d < 1.0E-10) && (!(d < 0.0) || !(d > -1.0E-10))) continue;
                    this.delaybuffer[n] = 0.0f;
                }
            }
        }

        public void setDamp(float f) {
            this.filtercoeff1 = f;
            this.filtercoeff2 = 1.0f - this.filtercoeff1;
        }
    }

    private class AllPass {
        private float[] delaybuffer;
        private int delaybuffersize;
        private int rovepos = 0;
        private float feedback;
        int ucount = 0;

        public AllPass(int n) {
            this.delaybuffer = new float[n];
            this.delaybuffersize = n;
        }

        public void setFeedBack(float f) {
            this.feedback = f;
        }

        public void processReplace(float[] fArray, float[] fArray2) {
            int n;
            int n2 = fArray.length;
            for (n = 0; n < n2; ++n) {
                float f = this.delaybuffer[this.rovepos];
                float f2 = fArray[n];
                fArray2[n] = -f2 + f;
                this.delaybuffer[this.rovepos] = f2 + f * this.feedback;
                if (++this.rovepos != this.delaybuffersize) continue;
                this.rovepos = 0;
            }
            ++this.ucount;
            if (this.ucount == 10) {
                this.ucount = 0;
                for (n = 0; n < this.delaybuffer.length; ++n) {
                    double d = this.delaybuffer[n];
                    if (!(d > 0.0 && d < 1.0E-10) && (!(d < 0.0) || !(d > -1.0E-10))) continue;
                    this.delaybuffer[n] = 0.0f;
                }
            }
        }
    }

    private class Delay {
        private float[] delaybuffer = null;
        private int rovepos = 0;

        public void setDelay(int n) {
            this.delaybuffer = (float[])(n == 0 ? null : new float[n]);
            this.rovepos = 0;
        }

        public void processReplace(float[] fArray, float[] fArray2) {
            float[] fArray3 = this.delaybuffer;
            if (fArray3 == null) {
                return;
            }
            int n = fArray.length;
            int n2 = fArray3.length;
            int n3 = this.rovepos;
            for (int i = 0; i < n; ++i) {
                float f = fArray[i];
                fArray2[i] = fArray3[n3];
                fArray3[n3] = f;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.rovepos = n3;
        }
    }
}

