/*
 * Decompiled with CFR 0.152.
 */
package biniu.ogg;

import biniu.ogg.Packet;
import biniu.ogg.Page;

public class StreamState {
    private byte[] bodyData;
    private int bodyStorage;
    private int bodyFill;
    private int bodyReturned;
    int[] lacing_vals;
    long[] granule_vals;
    int lacing_storage;
    int lacing_fill;
    int lacing_packet;
    int lacing_returned;
    byte[] header = new byte[282];
    int header_fill;
    public int e_o_s;
    int b_o_s;
    public int serialNo;
    private int pageNo;
    private long packetNo;
    private long granulePos;

    public StreamState() {
        this.init();
    }

    StreamState(int serialno) {
        this();
        this.init(serialno);
    }

    void init() {
        this.bodyStorage = 16384;
        this.bodyData = new byte[this.bodyStorage];
        this.lacing_storage = 1024;
        this.lacing_vals = new int[this.lacing_storage];
        this.granule_vals = new long[this.lacing_storage];
    }

    public void init(int serialno) {
        if (this.bodyData == null) {
            this.init();
        } else {
            int i = 0;
            while (i < this.bodyData.length) {
                this.bodyData[i] = 0;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.lacing_vals.length) {
                this.lacing_vals[i2] = 0;
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.granule_vals.length) {
                this.granule_vals[i3] = 0L;
                ++i3;
            }
        }
        this.serialNo = serialno;
    }

    public void clear() {
        this.bodyData = null;
        this.lacing_vals = null;
        this.granule_vals = null;
    }

    void destroy() {
        this.clear();
    }

    void bodyExpand(int needed) {
        if (this.bodyStorage <= this.bodyFill + needed) {
            this.bodyStorage += needed + 1024;
            byte[] foo = new byte[this.bodyStorage];
            System.arraycopy(this.bodyData, 0, foo, 0, this.bodyData.length);
            this.bodyData = foo;
        }
    }

    void lacingExpand(int needed) {
        if (this.lacing_storage <= this.lacing_fill + needed) {
            this.lacing_storage += needed + 32;
            int[] foo = new int[this.lacing_storage];
            System.arraycopy(this.lacing_vals, 0, foo, 0, this.lacing_vals.length);
            this.lacing_vals = foo;
            long[] bar = new long[this.lacing_storage];
            System.arraycopy(this.granule_vals, 0, bar, 0, this.granule_vals.length);
            this.granule_vals = bar;
        }
    }

    public int packetIn(Packet op) {
        int lacing_val = op.bytes / 255 + 1;
        if (this.bodyReturned != 0) {
            this.bodyFill -= this.bodyReturned;
            if (this.bodyFill != 0) {
                System.arraycopy(this.bodyData, this.bodyReturned, this.bodyData, 0, this.bodyFill);
            }
            this.bodyReturned = 0;
        }
        this.bodyExpand(op.bytes);
        this.lacingExpand(lacing_val);
        System.arraycopy(op.packetByte, 0, this.bodyData, this.bodyFill, op.bytes);
        this.bodyFill += op.bytes;
        int j = 0;
        while (j < lacing_val - 1) {
            this.lacing_vals[this.lacing_fill + j] = 255;
            this.granule_vals[this.lacing_fill + j] = this.granulePos;
            ++j;
        }
        this.lacing_vals[this.lacing_fill + j] = op.bytes % 255;
        long l = op.granulePos;
        this.granule_vals[this.lacing_fill + j] = l;
        this.granulePos = l;
        int n = this.lacing_fill;
        this.lacing_vals[n] = this.lacing_vals[n] | 0x100;
        this.lacing_fill += lacing_val;
        ++this.packetNo;
        if (op.e_o_s != 0) {
            this.e_o_s = 1;
        }
        return 0;
    }

    public int packetout(Packet op) {
        int ptr;
        if (this.lacing_packet <= (ptr = this.lacing_returned++)) {
            return 0;
        }
        if ((this.lacing_vals[ptr] & 0x400) != 0) {
            ++this.packetNo;
            return -1;
        }
        int size = this.lacing_vals[ptr] & 0xFF;
        int bytes = 0;
        op.packetByte = this.bodyData;
        op.e_o_s = this.lacing_vals[ptr] & 0x200;
        op.b_o_s = this.lacing_vals[ptr] & 0x100;
        bytes += size;
        while (size == 255) {
            int val = this.lacing_vals[++ptr];
            size = val & 0xFF;
            if ((val & 0x200) != 0) {
                op.e_o_s = 512;
            }
            bytes += size;
        }
        op.packetNo = this.packetNo++;
        op.granulePos = this.granule_vals[ptr];
        op.bytes = bytes;
        this.bodyReturned += bytes;
        this.lacing_returned = ptr + 1;
        return 1;
    }

    public int pagein(Page og) {
        int val;
        byte[] header_base = og.header_base;
        int header = og.header;
        byte[] body_base = og.body_base;
        int body = og.body;
        int bodysize = og.body_len;
        int segptr = 0;
        int version = og.version();
        int continued = og.continued();
        int bos = og.bos();
        boolean eos = og.eos();
        long granulepos = og.granulepos();
        int _serialno = og.serialno();
        int _pageno = og.pageno();
        int segments = header_base[header + 26] & 0xFF;
        int lr = this.lacing_returned;
        int br = this.bodyReturned;
        if (br != 0) {
            this.bodyFill -= br;
            if (this.bodyFill != 0) {
                System.arraycopy(this.bodyData, br, this.bodyData, 0, this.bodyFill);
            }
            this.bodyReturned = 0;
        }
        if (lr != 0) {
            if (this.lacing_fill - lr != 0) {
                System.arraycopy(this.lacing_vals, lr, this.lacing_vals, 0, this.lacing_fill - lr);
                System.arraycopy(this.granule_vals, lr, this.granule_vals, 0, this.lacing_fill - lr);
            }
            this.lacing_fill -= lr;
            this.lacing_packet -= lr;
            this.lacing_returned = 0;
        }
        if (_serialno != this.serialNo) {
            return -1;
        }
        if (version > 0) {
            return -1;
        }
        this.lacingExpand(segments + 1);
        if (_pageno != this.pageNo) {
            int i = this.lacing_packet;
            while (i < this.lacing_fill) {
                this.bodyFill -= this.lacing_vals[i] & 0xFF;
                ++i;
            }
            this.lacing_fill = this.lacing_packet++;
            if (this.pageNo != -1) {
                this.lacing_vals[this.lacing_fill++] = 1024;
            }
            if (continued != 0) {
                bos = 0;
                while (segptr < segments) {
                    val = header_base[header + 27 + segptr] & 0xFF;
                    body += val;
                    bodysize -= val;
                    if (val < 255) {
                        ++segptr;
                        break;
                    }
                    ++segptr;
                }
            }
        }
        if (bodysize != 0) {
            this.bodyExpand(bodysize);
            System.arraycopy(body_base, body, this.bodyData, this.bodyFill, bodysize);
            this.bodyFill += bodysize;
        }
        int saved = -1;
        while (segptr < segments) {
            this.lacing_vals[this.lacing_fill] = val = header_base[header + 27 + segptr] & 0xFF;
            this.granule_vals[this.lacing_fill] = -1L;
            if (bos != 0) {
                int n = this.lacing_fill;
                this.lacing_vals[n] = this.lacing_vals[n] | 0x100;
                bos = 0;
            }
            if (val < 255) {
                saved = this.lacing_fill;
            }
            ++this.lacing_fill;
            ++segptr;
            if (val >= 255) continue;
            this.lacing_packet = this.lacing_fill;
        }
        if (saved != -1) {
            this.granule_vals[saved] = granulepos;
        }
        if (eos) {
            this.e_o_s = 1;
            if (this.lacing_fill > 0) {
                int n = this.lacing_fill - 1;
                this.lacing_vals[n] = this.lacing_vals[n] | 0x200;
            }
        }
        this.pageNo = _pageno + 1;
        return 0;
    }

    public boolean flush(Page og) {
        int vals = 0;
        int maxvals = this.lacing_fill > 255 ? 255 : this.lacing_fill;
        int bytes = 0;
        int acc = 0;
        long granule_pos = this.granule_vals[0];
        if (maxvals == 0) {
            return false;
        }
        if (this.b_o_s == 0) {
            granule_pos = 0L;
            vals = 0;
            while (vals < maxvals) {
                if ((this.lacing_vals[vals] & 0xFF) < 255) {
                    ++vals;
                    break;
                }
                ++vals;
            }
        } else {
            vals = 0;
            while (vals < maxvals) {
                if (acc <= 4096) {
                    acc += this.lacing_vals[vals] & 0xFF;
                    granule_pos = this.granule_vals[vals];
                    ++vals;
                    continue;
                }
                break;
            }
        }
        System.arraycopy("OggS".getBytes(), 0, this.header, 0, 4);
        this.header[4] = 0;
        this.header[5] = 0;
        if ((this.lacing_vals[0] & 0x100) == 0) {
            this.header[5] = (byte)(this.header[5] | 1);
        }
        if (this.b_o_s == 0) {
            this.header[5] = (byte)(this.header[5] | 2);
        }
        if (this.e_o_s != 0 && this.lacing_fill == vals) {
            this.header[5] = (byte)(this.header[5] | 4);
        }
        this.b_o_s = 1;
        int i = 6;
        while (i < 14) {
            this.header[i] = (byte)(granule_pos & 0xFFL);
            granule_pos >>>= 8;
            ++i;
        }
        int _serialno = this.serialNo;
        i = 14;
        while (i < 18) {
            this.header[i] = (byte)(_serialno & 0xFF);
            _serialno >>>= 8;
            ++i;
        }
        if (this.pageNo == -1) {
            this.pageNo = 0;
        }
        int _pageno = this.pageNo++;
        i = 18;
        while (i < 22) {
            this.header[i] = (byte)(_pageno & 0xFF);
            _pageno >>>= 8;
            ++i;
        }
        this.header[22] = 0;
        this.header[23] = 0;
        this.header[24] = 0;
        this.header[25] = 0;
        this.header[26] = (byte)vals;
        i = 0;
        while (i < vals) {
            bytes += this.lacing_vals[i] & 0xFF;
            this.header[i + 27] = (byte)(this.lacing_vals[i] & 0xFF);
            ++i;
        }
        og.header_base = this.header;
        og.header = 0;
        og.header_len = this.header_fill = vals + 27;
        og.body_base = this.bodyData;
        og.body = this.bodyReturned;
        og.body_len = bytes;
        this.lacing_fill -= vals;
        System.arraycopy(this.lacing_vals, vals, this.lacing_vals, 0, this.lacing_fill);
        System.arraycopy(this.granule_vals, vals, this.granule_vals, 0, this.lacing_fill);
        this.bodyReturned += bytes;
        og.checksum();
        return true;
    }

    public boolean pageOut(Page og) {
        if (this.e_o_s != 0 && this.lacing_fill != 0 || this.bodyFill - this.bodyReturned > 4096 || this.lacing_fill >= 255 || this.lacing_fill != 0 && this.b_o_s == 0) {
            return this.flush(og);
        }
        return false;
    }

    public int eof() {
        return this.e_o_s;
    }

    public int reset() {
        this.bodyFill = 0;
        this.bodyReturned = 0;
        this.lacing_fill = 0;
        this.lacing_packet = 0;
        this.lacing_returned = 0;
        this.header_fill = 0;
        this.e_o_s = 0;
        this.b_o_s = 0;
        this.pageNo = -1;
        this.packetNo = 0L;
        this.granulePos = 0L;
        return 0;
    }
}

