/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.vorbis.DecodeAux;
import biniu.vorbis.EncodeAuxNearestMatch;
import biniu.vorbis.EncodeAuxThreshMatch;
import biniu.vorbis.StaticCodeBook;

class CodeBook {
    int dim;
    int entries;
    int used_entries;
    StaticCodeBook c = new StaticCodeBook();
    float[] valuelist;
    int[] codelist;
    DecodeAux decode_tree;
    private int[] t = new int[15];

    CodeBook() {
    }

    int encode(int a, Buffer b) {
        b.write(this.codelist[a], this.c.lengthlist[a]);
        return this.c.lengthlist[a];
    }

    int errorv(float[] a) {
        int best = this.best(a, 1);
        int k = 0;
        while (k < this.dim) {
            a[k] = this.valuelist[best * this.dim + k];
            ++k;
        }
        return best;
    }

    int encodev(int best, float[] a, Buffer b) {
        int k = 0;
        while (k < this.dim) {
            a[k] = this.valuelist[best * this.dim + k];
            ++k;
        }
        return this.encode(best, b);
    }

    int encodevs(float[] a, Buffer b, int step, int addmul) {
        int best = this.besterror(a, step, addmul);
        return this.encode(best, b);
    }

    synchronized int decodevs_add(float[] a, int offset, Buffer b, int n) {
        int step = n / this.dim;
        if (this.t.length < step) {
            this.t = new int[step];
        }
        int i = 0;
        while (i < step) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            this.t[i] = entry * this.dim;
            ++i;
        }
        i = 0;
        int o = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < step) {
                int n2 = offset + o + j;
                a[n2] = a[n2] + this.valuelist[this.t[j] + i];
                ++j;
            }
            ++i;
            o += step;
        }
        return 0;
    }

    int decodev_add(float[] a, int offset, Buffer b, int n) {
        if (this.dim > 8) {
            int i = 0;
            while (i < n) {
                int entry = this.decode(b);
                if (entry == -1) {
                    return -1;
                }
                int t = entry * this.dim;
                int j = 0;
                while (j < this.dim) {
                    int n2 = offset + i++;
                    a[n2] = a[n2] + this.valuelist[t + j++];
                }
            }
        } else {
            int i = 0;
            while (i < n) {
                int entry = this.decode(b);
                if (entry == -1) {
                    return -1;
                }
                int t = entry * this.dim;
                int j = 0;
                switch (this.dim) {
                    case 8: {
                        int n3 = offset + i++;
                        a[n3] = a[n3] + this.valuelist[t + j++];
                    }
                    case 7: {
                        int n4 = offset + i++;
                        a[n4] = a[n4] + this.valuelist[t + j++];
                    }
                    case 6: {
                        int n5 = offset + i++;
                        a[n5] = a[n5] + this.valuelist[t + j++];
                    }
                    case 5: {
                        int n6 = offset + i++;
                        a[n6] = a[n6] + this.valuelist[t + j++];
                    }
                    case 4: {
                        int n7 = offset + i++;
                        a[n7] = a[n7] + this.valuelist[t + j++];
                    }
                    case 3: {
                        int n8 = offset + i++;
                        a[n8] = a[n8] + this.valuelist[t + j++];
                    }
                    case 2: {
                        int n9 = offset + i++;
                        a[n9] = a[n9] + this.valuelist[t + j++];
                    }
                    case 1: {
                        int n10 = offset + i++;
                        a[n10] = a[n10] + this.valuelist[t + j++];
                    }
                }
            }
        }
        return 0;
    }

    int decodev_set(float[] a, int offset, Buffer b, int n) {
        int i = 0;
        while (i < n) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            int t = entry * this.dim;
            int j = 0;
            while (j < this.dim) {
                a[offset + i++] = this.valuelist[t + j++];
            }
        }
        return 0;
    }

    int decodevv_add(float[][] a, int offset, int ch, Buffer b, int n) {
        int chptr = 0;
        int i = offset / ch;
        while (i < (offset + n) / ch) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            int t = entry * this.dim;
            int j = 0;
            while (j < this.dim) {
                float[] fArray = a[chptr++];
                int n2 = i++;
                fArray[n2] = fArray[n2] + this.valuelist[t + j];
                if (chptr == ch) {
                    chptr = 0;
                }
                ++j;
            }
        }
        return 0;
    }

    int decode(Buffer b) {
        int ptr = 0;
        DecodeAux t = this.decode_tree;
        int lok = b.look(t.tabn);
        if (lok >= 0) {
            ptr = t.tab[lok];
            b.adv(t.tabl[lok]);
            if (ptr <= 0) {
                return -ptr;
            }
        }
        do {
            switch (b.read1()) {
                case 0: {
                    ptr = t.ptr0[ptr];
                    break;
                }
                case 1: {
                    ptr = t.ptr1[ptr];
                    break;
                }
                default: {
                    return -1;
                }
            }
        } while (ptr > 0);
        return -ptr;
    }

    int decodevs(float[] a, int index, Buffer b, int step, int addmul) {
        int entry = this.decode(b);
        if (entry == -1) {
            return -1;
        }
        switch (addmul) {
            case -1: {
                int i = 0;
                int o = 0;
                while (i < this.dim) {
                    a[index + o] = this.valuelist[entry * this.dim + i];
                    ++i;
                    o += step;
                }
                break;
            }
            case 0: {
                int i = 0;
                int o = 0;
                while (i < this.dim) {
                    int n = index + o;
                    a[n] = a[n] + this.valuelist[entry * this.dim + i];
                    ++i;
                    o += step;
                }
                break;
            }
            case 1: {
                int i = 0;
                int o = 0;
                while (i < this.dim) {
                    int n = index + o;
                    a[n] = a[n] * this.valuelist[entry * this.dim + i];
                    ++i;
                    o += step;
                }
                break;
            }
        }
        return entry;
    }

    int best(float[] a, int step) {
        int i;
        EncodeAuxNearestMatch nt = this.c.nearest_tree;
        EncodeAuxThreshMatch tt = this.c.thresh_tree;
        int ptr = 0;
        if (tt != null) {
            int index = 0;
            int k = 0;
            int o = step * (this.dim - 1);
            while (k < this.dim) {
                i = 0;
                while (i < tt.threshvals - 1) {
                    if (a[o] < tt.quantthresh[i]) break;
                    ++i;
                }
                index = index * tt.quantvals + tt.quantmap[i];
                ++k;
                o -= step;
            }
            if (this.c.lengthlist[index] > 0) {
                return index;
            }
        }
        if (nt != null) {
            float c;
            do {
                c = 0.0f;
                int p = nt.p[ptr];
                int q = nt.q[ptr];
                int k = 0;
                int o = 0;
                while (k < this.dim) {
                    c = (float)((double)c + (double)(this.valuelist[p + k] - this.valuelist[q + k]) * ((double)a[o] - (double)(this.valuelist[p + k] + this.valuelist[q + k]) * 0.5));
                    ++k;
                    o += step;
                }
            } while ((ptr = (double)c > 0.0 ? -nt.ptr0[ptr] : -nt.ptr1[ptr]) > 0);
            return -ptr;
        }
        int besti = -1;
        float best = 0.0f;
        int e = 0;
        i = 0;
        while (i < this.entries) {
            if (this.c.lengthlist[i] > 0) {
                float _this = CodeBook.dist(this.dim, this.valuelist, e, a, step);
                if (besti == -1 || _this < best) {
                    best = _this;
                    besti = i;
                }
            }
            e += this.dim;
            ++i;
        }
        return besti;
    }

    int besterror(float[] a, int step, int addmul) {
        int best = this.best(a, step);
        switch (addmul) {
            case 0: {
                int i = 0;
                int o = 0;
                while (i < this.dim) {
                    int n = o;
                    a[n] = a[n] - this.valuelist[best * this.dim + i];
                    ++i;
                    o += step;
                }
                break;
            }
            case 1: {
                int i = 0;
                int o = 0;
                while (i < this.dim) {
                    float val = this.valuelist[best * this.dim + i];
                    if (val == 0.0f) {
                        a[o] = 0.0f;
                    } else {
                        int n = o;
                        a[n] = a[n] / val;
                    }
                    ++i;
                    o += step;
                }
                break;
            }
        }
        return best;
    }

    void clear() {
    }

    private static float dist(int el, float[] ref, int index, float[] b, int step) {
        float acc = 0.0f;
        int i = 0;
        while (i < el) {
            float val = ref[index + i] - b[i * step];
            acc += val * val;
            ++i;
        }
        return acc;
    }

    private static int ilog(int v) {
        int ret = 0;
        while (v != 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    public int bookEncode(int a, Buffer b) {
        b.write(this.codelist[a], this.c.lengthlist[a]);
        return this.c.lengthlist[a];
    }

    public int bookInitEncode(StaticCodeBook s) {
        this.c = s;
        this.entries = s.entries;
        this.used_entries = s.entries;
        this.dim = s.dim;
        this.codelist = this.makeWords(s.lengthlist, s.entries, 0);
        this.valuelist = this.bookUnquantize(s, s.entries, null);
        return 0;
    }

    private int[] makeWords(int[] l, int n, int sparsecount) {
        int j;
        int count = 0;
        int[] marker = new int[33];
        int[] r = new int[sparsecount != 0 ? sparsecount : n];
        int i = 0;
        while (i < n) {
            int length = l[i];
            if (length > 0) {
                int entry = marker[length];
                if (length < 32 && entry >> length != 0) {
                    return null;
                }
                r[count++] = entry;
                j = length;
                while (j > 0) {
                    if ((marker[j] & 1) != 0) {
                        if (j == 1) {
                            marker[1] = marker[1] + 1;
                            break;
                        }
                        marker[j] = marker[j - 1] << 1;
                        break;
                    }
                    int n2 = j--;
                    marker[n2] = marker[n2] + 1;
                }
                j = length + 1;
                while (j < 33) {
                    if (marker[j] >> 1 == entry) {
                        entry = marker[j];
                        marker[j] = marker[j - 1] << 1;
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (sparsecount == 0) {
                ++count;
            }
            ++i;
        }
        i = 0;
        count = 0;
        while (i < n) {
            int temp = 0;
            j = 0;
            while (j < l[i]) {
                temp <<= 1;
                temp |= r[count] >> j & 1;
                ++j;
            }
            if (sparsecount != 0) {
                if (l[i] != 0) {
                    r[count++] = temp;
                }
            } else {
                r[count++] = temp;
            }
            ++i;
        }
        return r;
    }

    private float[] bookUnquantize(StaticCodeBook b, int n, int[] sparsemap) {
        int count = 0;
        if (b.maptype == 1 || b.maptype == 2) {
            float mindel = b.float32_unpack(b.q_min);
            float delta = b.float32_unpack(b.q_delta);
            float[] r = new float[n * b.dim];
            switch (b.maptype) {
                case 1: {
                    int quantvals = this.bookMaptype1Quantvals(b);
                    int j = 0;
                    while (j < b.entries) {
                        if (sparsemap != null && b.lengthlist[j] != 0 || sparsemap == null) {
                            float last = 0.0f;
                            int indexdiv = 1;
                            int k = 0;
                            while (k < b.dim) {
                                int index = j / indexdiv % quantvals;
                                float val = b.quantlist[index];
                                val = Math.abs(val) * delta + mindel + last;
                                if (b.q_sequencep != 0) {
                                    last = val;
                                }
                                if (sparsemap != null) {
                                    r[sparsemap[count] * b.dim + k] = val;
                                } else {
                                    r[count * b.dim + k] = val;
                                }
                                indexdiv *= quantvals;
                                ++k;
                            }
                            ++count;
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    int j = 0;
                    while (j < b.entries) {
                        if (sparsemap != null && b.lengthlist[j] != 0 || sparsemap != null) {
                            float last = 0.0f;
                            int k = 0;
                            while (k < b.dim) {
                                float val = b.quantlist[j * b.dim + k];
                                val = Math.abs(val) * delta + mindel + last;
                                if (b.q_sequencep != 0) {
                                    last = val;
                                }
                                if (sparsemap != null) {
                                    r[sparsemap[count] * b.dim + k] = val;
                                } else {
                                    r[count * b.dim + k] = val;
                                }
                                ++k;
                            }
                            ++count;
                        }
                        ++j;
                    }
                    break;
                }
            }
            return r;
        }
        return null;
    }

    private int bookMaptype1Quantvals(StaticCodeBook b) {
        int vals = (int)Math.floor(Math.pow(b.entries, 1.0 / (double)b.dim));
        while (true) {
            long acc = 1L;
            long acc1 = 1L;
            int i = 0;
            while (i < b.dim) {
                acc *= (long)vals;
                acc1 *= (long)(vals + 1);
                ++i;
            }
            if (acc <= (long)b.entries && acc1 > (long)b.entries) {
                return vals;
            }
            if (acc > (long)b.entries) {
                --vals;
                continue;
            }
            ++vals;
        }
    }
}

